/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.path;

import com.twelvemonkeys.lang.Validate;

final class AdobePathSegment {
    static final int CLOSED_SUBPATH_LENGTH_RECORD = 0;
    static final int CLOSED_SUBPATH_BEZIER_LINKED = 1;
    static final int CLOSED_SUBPATH_BEZIER_UNLINKED = 2;
    static final int OPEN_SUBPATH_LENGTH_RECORD = 3;
    static final int OPEN_SUBPATH_BEZIER_LINKED = 4;
    static final int OPEN_SUBPATH_BEZIER_UNLINKED = 5;
    static final int PATH_FILL_RULE_RECORD = 6;
    static final int CLIPBOARD_RECORD = 7;
    static final int INITIAL_FILL_RULE_RECORD = 8;
    static final String[] SELECTOR_NAMES = new String[]{"Closed subpath length record", "Closed subpath Bezier knot, linked", "Closed subpath Bezier knot, unlinked", "Open subpath length record", "Open subpath Bezier knot, linked", "Open subpath Bezier knot, unlinked", "Path fill rule record", "Clipboard record", "Initial fill rule record"};
    final int selector;
    final int lengthOrRule;
    final double cppy;
    final double cppx;
    final double apy;
    final double apx;
    final double cply;
    final double cplx;

    AdobePathSegment(int n, double d, double d2, double d3, double d4, double d5, double d6) {
        this(n, -1, d, d2, d3, d4, d5, d6);
    }

    AdobePathSegment(int n, int n2) {
        this((Integer)Validate.isTrue((n == 0 || n == 3 || n == 6 || n == 8 ? 1 : 0) != 0, (Object)n, (String)"Expected path length or fill rule record (0/3 or 6/8): %s"), n2, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0);
    }

    private AdobePathSegment(int n, int n2, double d, double d2, double d3, double d4, double d5, double d6) {
        switch (n) {
            case 0: 
            case 3: {
                Validate.isTrue((n2 >= 0 ? 1 : 0) != 0, (Object)n2, (String)"Expected positive length: %d");
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                Validate.isTrue((d2 >= 0.0 && d2 <= 1.0 && d >= 0.0 && d <= 1.0 ? 1 : 0) != 0, (String)String.format("Expected point in range [0...1]: (%f, %f)", d2, d));
                break;
            }
            case 6: 
            case 8: {
                Validate.isTrue((n2 == 0 || n2 == 1 ? 1 : 0) != 0, (Object)n2, (String)"Expected rule (1 or 0): %d");
                break;
            }
            case 7: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown selector: " + n);
            }
        }
        this.selector = n;
        this.lengthOrRule = n2;
        this.cppy = d;
        this.cppx = d2;
        this.apy = d3;
        this.apx = d4;
        this.cply = d5;
        this.cplx = d6;
    }

    static int toFixedPoint(double d) {
        return (int)Math.round(d * 1.6777216E7);
    }

    static double fromFixedPoint(int n) {
        return (double)n / 1.6777216E7;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        AdobePathSegment adobePathSegment = (AdobePathSegment)object;
        return Double.compare(adobePathSegment.apx, this.apx) == 0 && Double.compare(adobePathSegment.apy, this.apy) == 0 && Double.compare(adobePathSegment.cplx, this.cplx) == 0 && Double.compare(adobePathSegment.cply, this.cply) == 0 && Double.compare(adobePathSegment.cppx, this.cppx) == 0 && Double.compare(adobePathSegment.cppy, this.cppy) == 0 && this.selector == adobePathSegment.selector && this.lengthOrRule == adobePathSegment.lengthOrRule;
    }

    public int hashCode() {
        int n = this.selector;
        n = 31 * n + this.lengthOrRule;
        long l = Double.doubleToLongBits(this.cppy);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.cppx);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.apy);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.apx);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.cply);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.cplx);
        n = 31 * n + (int)(l ^ l >>> 32);
        return n;
    }

    public String toString() {
        switch (this.selector) {
            case 6: 
            case 8: {
                return String.format("Rule(selector=%s, rule=%d)", SELECTOR_NAMES[this.selector], this.lengthOrRule);
            }
            case 0: 
            case 3: {
                return String.format("Len(selector=%s, length=%d)", SELECTOR_NAMES[this.selector], this.lengthOrRule);
            }
        }
        return String.format("Pt(pre=(%.3f, %.3f), knot=(%.3f, %.3f), post=(%.3f, %.3f), selector=%s)", this.cppx, this.cppy, this.apx, this.apy, this.cplx, this.cply, SELECTOR_NAMES[this.selector]);
    }
}

