/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.svg;

import com.twelvemonkeys.image.ImageUtil;
import com.twelvemonkeys.imageio.ImageReaderBase;
import com.twelvemonkeys.imageio.plugins.svg.SVGReadParam;
import com.twelvemonkeys.imageio.util.IIOUtil;
import com.twelvemonkeys.lang.StringUtil;
import java.awt.AlphaComposite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Transparency;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import org.apache.batik.anim.dom.SVGDOMImplementation;
import org.apache.batik.anim.dom.SVGOMDocument;
import org.apache.batik.bridge.BaseScriptingEnvironment;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.EmbededExternalResourceSecurity;
import org.apache.batik.bridge.ExternalResourceSecurity;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.ViewBox;
import org.apache.batik.dom.util.DOMUtilities;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.gvt.CanvasGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.renderer.ConcreteImageRendererFactory;
import org.apache.batik.gvt.renderer.ImageRenderer;
import org.apache.batik.parser.UnitProcessor;
import org.apache.batik.transcoder.SVGAbstractTranscoder;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.util.ParsedURL;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGSVGElement;

public class SVGImageReader
extends ImageReaderBase {
    static final boolean DEFAULT_ALLOW_EXTERNAL_RESOURCES = "true".equalsIgnoreCase(System.getProperty("com.twelvemonkeys.imageio.plugins.svg.allowexternalresources"));
    private Rasterizer rasterizer;
    private boolean allowExternalResources = DEFAULT_ALLOW_EXTERNAL_RESOURCES;

    public SVGImageReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
    }

    protected void resetMembers() {
        this.rasterizer = new Rasterizer();
    }

    public void dispose() {
        super.dispose();
        this.rasterizer = null;
    }

    public void setInput(Object object, boolean bl, boolean bl2) {
        super.setInput(object, bl, bl2);
        if (this.imageInput != null) {
            TranscoderInput transcoderInput = new TranscoderInput(IIOUtil.createStreamAdapter((ImageInputStream)this.imageInput));
            this.rasterizer.setInput(transcoderInput);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IOException {
        Object object;
        Object object2;
        this.checkBounds(n);
        if (imageReadParam instanceof SVGReadParam) {
            object2 = (SVGReadParam)imageReadParam;
            this.allowExternalResources = ((SVGReadParam)object2).isAllowExternalResources();
            object = ((SVGReadParam)object2).getBaseURI();
            this.rasterizer.transcoderInput.setURI((String)object);
            this.rasterizer.setTranscodingHints((Map)this.paramsToHints((SVGReadParam)object2));
        }
        object2 = null;
        if (imageReadParam != null) {
            object2 = imageReadParam.getSourceRenderSize();
        }
        if (object2 == null) {
            object2 = new Dimension(this.getWidth(n), this.getHeight(n));
        }
        object = SVGImageReader.getDestination((ImageReadParam)imageReadParam, this.getImageTypes(n), (int)((Dimension)object2).width, (int)((Dimension)object2).height);
        try {
            this.processImageStarted(n);
            BufferedImage bufferedImage = this.rasterizer.getImage();
            Graphics2D graphics2D = ((BufferedImage)object).createGraphics();
            try {
                graphics2D.setComposite(AlphaComposite.Src);
                graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
                graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
            }
            finally {
                graphics2D.dispose();
            }
            this.processImageComplete();
            return object;
        }
        catch (TranscoderException transcoderException) {
            Throwable throwable = SVGImageReader.unwrapException(transcoderException);
            throw new IIOException(throwable.getMessage(), throwable);
        }
    }

    private static Throwable unwrapException(TranscoderException transcoderException) {
        return transcoderException.getException() != null ? transcoderException.getException() : transcoderException;
    }

    private TranscodingHints paramsToHints(SVGReadParam sVGReadParam) throws IOException {
        Rectangle rectangle;
        TranscodingHints transcodingHints = new TranscodingHints();
        Dimension dimension = sVGReadParam.getSourceRenderSize();
        Dimension dimension2 = new Dimension(this.getWidth(0), this.getHeight(0));
        if (dimension == null) {
            dimension = this.getSourceRenderSizeFromSubsamping(sVGReadParam, dimension2);
        }
        if (dimension != null) {
            transcodingHints.put((Object)ImageTranscoder.KEY_WIDTH, (Object)Float.valueOf((float)dimension.getWidth()));
            transcodingHints.put((Object)ImageTranscoder.KEY_HEIGHT, (Object)Float.valueOf((float)dimension.getHeight()));
        }
        if ((rectangle = sVGReadParam.getSourceRegion()) != null) {
            transcodingHints.put((Object)ImageTranscoder.KEY_AOI, (Object)rectangle);
            if (dimension == null) {
                transcodingHints.put((Object)ImageTranscoder.KEY_WIDTH, (Object)Float.valueOf((float)rectangle.getWidth()));
                transcodingHints.put((Object)ImageTranscoder.KEY_HEIGHT, (Object)Float.valueOf((float)rectangle.getHeight()));
            } else {
                double d = dimension.getWidth() / dimension2.getWidth();
                double d2 = dimension.getHeight() / dimension2.getHeight();
                transcodingHints.put((Object)ImageTranscoder.KEY_WIDTH, (Object)Float.valueOf((float)(rectangle.getWidth() * d)));
                transcodingHints.put((Object)ImageTranscoder.KEY_HEIGHT, (Object)Float.valueOf((float)(rectangle.getHeight() * d2)));
            }
        } else if (dimension != null) {
            transcodingHints.put((Object)ImageTranscoder.KEY_AOI, (Object)new Rectangle(dimension2));
        }
        Paint paint = sVGReadParam.getBackgroundColor();
        if (paint != null) {
            transcodingHints.put((Object)ImageTranscoder.KEY_BACKGROUND_COLOR, (Object)paint);
        }
        return transcodingHints;
    }

    private Dimension getSourceRenderSizeFromSubsamping(ImageReadParam imageReadParam, Dimension dimension) {
        if (imageReadParam.getSourceXSubsampling() > 1 || imageReadParam.getSourceYSubsampling() > 1) {
            return new Dimension((int)((float)dimension.width / (float)imageReadParam.getSourceXSubsampling()), (int)((float)dimension.height / (float)imageReadParam.getSourceYSubsampling()));
        }
        return null;
    }

    public SVGReadParam getDefaultReadParam() {
        return new SVGReadParam();
    }

    public int getWidth(int n) throws IOException {
        this.checkBounds(n);
        try {
            return this.rasterizer.getDefaultWidth();
        }
        catch (TranscoderException transcoderException) {
            throw new IIOException(transcoderException.getMessage(), transcoderException);
        }
    }

    public int getHeight(int n) throws IOException {
        this.checkBounds(n);
        try {
            return this.rasterizer.getDefaultHeight();
        }
        catch (TranscoderException transcoderException) {
            throw new IIOException(transcoderException.getMessage(), transcoderException);
        }
    }

    public Iterator<ImageTypeSpecifier> getImageTypes(int n) {
        return Collections.singleton(ImageTypeSpecifier.createFromRenderedImage(this.rasterizer.createImage(1, 1))).iterator();
    }

    private class Rasterizer
    extends SVGAbstractTranscoder {
        private BufferedImage image;
        private TranscoderInput transcoderInput;
        private float defaultWidth;
        private float defaultHeight;
        private boolean initialized = false;
        private SVGOMDocument document;
        private String uri;
        private GraphicsNode gvtRoot;
        private TranscoderException exception;
        private BridgeContext context;

        private Rasterizer() {
        }

        private BufferedImage createImage(int n, int n2) {
            return ImageUtil.createTransparent((int)n, (int)n2);
        }

        protected void transcode(Document document, String string, TranscoderOutput transcoderOutput) {
            boolean bl;
            boolean bl2;
            Object object;
            if (document != null) {
                if (!(document.getImplementation() instanceof SVGDOMImplementation)) {
                    object = (DOMImplementation)this.hints.get((Object)KEY_DOM_IMPLEMENTATION);
                    document = DOMUtilities.deepCloneDocument((Document)document, (DOMImplementation)object);
                }
                if (string != null) {
                    try {
                        object = new URL(string);
                        ((SVGOMDocument)document).setURLObject((URL)object);
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
            }
            this.ctx = this.createBridgeContext();
            object = (SVGOMDocument)document;
            this.builder = new GVTBuilder();
            boolean bl3 = bl2 = this.hints.containsKey((Object)KEY_EXECUTE_ONLOAD) && (Boolean)this.hints.get((Object)KEY_EXECUTE_ONLOAD) != false && BaseScriptingEnvironment.isDynamicDocument((BridgeContext)this.ctx, (Document)object);
            if (bl2) {
                this.ctx.setDynamicState(2);
            }
            GraphicsNode graphicsNode = null;
            try {
                graphicsNode = this.builder.build(this.ctx, (Document)object);
            }
            catch (BridgeException bridgeException) {
                this.exception = new TranscoderException((Exception)((Object)bridgeException));
            }
            SVGSVGElement sVGSVGElement = object.getRootElement();
            UnitProcessor.Context context = UnitProcessor.createContext((BridgeContext)this.ctx, (Element)sVGSVGElement);
            String string2 = sVGSVGElement.getAttributeNS(null, "width");
            String string3 = sVGSVGElement.getAttributeNS(null, "height");
            if (!StringUtil.isEmpty((String)string2)) {
                this.defaultWidth = UnitProcessor.svgToUserSpace((String)string2, (String)"width", (short)2, (UnitProcessor.Context)context);
            }
            if (!StringUtil.isEmpty((String)string3)) {
                this.defaultHeight = UnitProcessor.svgToUserSpace((String)string3, (String)"height", (short)1, (UnitProcessor.Context)context);
            }
            boolean bl4 = (double)this.defaultWidth > 0.0;
            boolean bl5 = bl = (double)this.defaultHeight > 0.0;
            if (!bl4 || !bl) {
                String string4 = sVGSVGElement.getAttributeNS(null, "viewBox");
                if (string4.length() != 0) {
                    float[] fArray = ViewBox.parseViewBoxAttribute((Element)sVGSVGElement, (String)string4, null);
                    if (bl4) {
                        this.defaultHeight = this.defaultWidth * fArray[3] / fArray[2];
                    } else if (bl) {
                        this.defaultWidth = this.defaultHeight * fArray[2] / fArray[3];
                    } else {
                        this.defaultWidth = fArray[2];
                        this.defaultHeight = fArray[3];
                    }
                } else if (bl) {
                    this.defaultWidth = this.defaultHeight;
                } else if (bl4) {
                    this.defaultHeight = this.defaultWidth;
                } else {
                    this.defaultWidth = 400.0f;
                    this.defaultHeight = 400.0f;
                }
            }
            if (graphicsNode != null) {
                this.gvtRoot = graphicsNode;
            }
            this.document = object;
            this.uri = string;
            this.context = this.ctx;
            this.ctx = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private BufferedImage readImage() throws TranscoderException {
            AffineTransform affineTransform;
            this.init();
            if (SVGImageReader.this.abortRequested()) {
                SVGImageReader.this.processReadAborted();
                return null;
            }
            SVGImageReader.this.processImageProgress(10.0f);
            if (this.gvtRoot == null) {
                if (this.uri != this.transcoderInput.getURI()) {
                    try {
                        this.context.dispose();
                        this.document.setURLObject(new URL(this.transcoderInput.getURI()));
                        this.transcode((Document)this.document, this.transcoderInput.getURI(), null);
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
                if (this.gvtRoot == null) {
                    throw this.exception;
                }
            }
            this.ctx = this.context;
            if (SVGImageReader.this.abortRequested()) {
                SVGImageReader.this.processReadAborted();
                return null;
            }
            SVGImageReader.this.processImageProgress(20.0f);
            SVGSVGElement sVGSVGElement = this.document.getRootElement();
            this.setImageSize(this.defaultWidth, this.defaultHeight);
            if (SVGImageReader.this.abortRequested()) {
                SVGImageReader.this.processReadAborted();
                return null;
            }
            SVGImageReader.this.processImageProgress(40.0f);
            String string = new ParsedURL(this.uri).getRef();
            try {
                affineTransform = ViewBox.getViewTransform((String)string, (Element)sVGSVGElement, (float)this.width, (float)this.height, null);
            }
            catch (BridgeException bridgeException) {
                throw new TranscoderException((Exception)((Object)bridgeException));
            }
            if (affineTransform.isIdentity() && (this.width != this.defaultWidth || this.height != this.defaultHeight)) {
                float f = this.width / this.defaultWidth;
                float f2 = this.height / this.defaultHeight;
                float f3 = Math.min(f, f2);
                affineTransform = AffineTransform.getScaleInstance(f3, f3);
            }
            if (this.hints.containsKey((Object)KEY_AOI)) {
                Rectangle2D rectangle2D = (Rectangle2D)this.hints.get((Object)KEY_AOI);
                rectangle2D = affineTransform.createTransformedShape(rectangle2D).getBounds2D();
                AffineTransform affineTransform2 = new AffineTransform();
                double d = (double)this.width / rectangle2D.getWidth();
                double d2 = (double)this.height / rectangle2D.getHeight();
                affineTransform2.scale(d, d2);
                double d3 = -rectangle2D.getX();
                double d4 = -rectangle2D.getY();
                affineTransform2.translate(d3, d4);
                affineTransform.preConcatenate(affineTransform2);
                this.curAOI = rectangle2D;
            } else {
                this.curAOI = new Rectangle2D.Float(0.0f, 0.0f, this.width, this.height);
            }
            if (SVGImageReader.this.abortRequested()) {
                SVGImageReader.this.processReadAborted();
                return null;
            }
            SVGImageReader.this.processImageProgress(50.0f);
            CanvasGraphicsNode canvasGraphicsNode = this.getCanvasGraphicsNode(this.gvtRoot);
            if (canvasGraphicsNode != null) {
                canvasGraphicsNode.setViewingTransform(affineTransform);
                this.curTxf = new AffineTransform();
            } else {
                this.curTxf = affineTransform;
            }
            try {
                if (this.ctx.isDynamic()) {
                    BaseScriptingEnvironment baseScriptingEnvironment = new BaseScriptingEnvironment(this.ctx);
                    baseScriptingEnvironment.loadScripts();
                    baseScriptingEnvironment.dispatchSVGLoadEvent();
                }
            }
            catch (BridgeException bridgeException) {
                throw new TranscoderException((Exception)((Object)bridgeException));
            }
            this.root = this.gvtRoot;
            int n = (int)((double)this.width + 0.5);
            int n2 = (int)((double)this.height + 0.5);
            ConcreteImageRendererFactory concreteImageRendererFactory = new ConcreteImageRendererFactory();
            ImageRenderer imageRenderer = concreteImageRendererFactory.createStaticImageRenderer();
            imageRenderer.updateOffScreen(n, n2);
            imageRenderer.setTransform(this.curTxf);
            imageRenderer.setTree(this.root);
            this.root = null;
            if (SVGImageReader.this.abortRequested()) {
                SVGImageReader.this.processReadAborted();
                return null;
            }
            SVGImageReader.this.processImageProgress(75.0f);
            try {
                Transparency transparency;
                Rectangle2D.Float float_ = new Rectangle2D.Float(0.0f, 0.0f, this.width, this.height);
                imageRenderer.repaint(this.curTxf.createInverse().createTransformedShape(float_));
                BufferedImage bufferedImage = imageRenderer.getOffScreen();
                imageRenderer = null;
                BufferedImage bufferedImage2 = this.createImage(n, n2);
                Graphics2D graphics2D = GraphicsUtil.createGraphics((BufferedImage)bufferedImage2);
                try {
                    if (this.hints.containsKey((Object)ImageTranscoder.KEY_BACKGROUND_COLOR)) {
                        transparency = (Paint)this.hints.get((Object)ImageTranscoder.KEY_BACKGROUND_COLOR);
                        graphics2D.setComposite(AlphaComposite.SrcOver);
                        graphics2D.setPaint((Paint)transparency);
                        graphics2D.fillRect(0, 0, n, n2);
                    }
                    if (bufferedImage != null) {
                        graphics2D.drawRenderedImage(bufferedImage, new AffineTransform());
                    }
                }
                finally {
                    if (graphics2D != null) {
                        graphics2D.dispose();
                    }
                }
                if (SVGImageReader.this.abortRequested()) {
                    SVGImageReader.this.processReadAborted();
                    transparency = null;
                    return transparency;
                }
                SVGImageReader.this.processImageProgress(99.0f);
                transparency = bufferedImage2;
                return transparency;
            }
            catch (Exception exception) {
                throw new TranscoderException(exception.getMessage(), exception);
            }
            finally {
                if (this.context != null) {
                    this.context.dispose();
                }
            }
        }

        private synchronized void init() throws TranscoderException {
            if (!this.initialized) {
                if (this.transcoderInput == null) {
                    throw new IllegalStateException("input == null");
                }
                this.initialized = true;
                super.transcode(this.transcoderInput, null);
            }
        }

        private BufferedImage getImage() throws TranscoderException {
            if (this.image == null) {
                this.image = this.readImage();
            }
            return this.image;
        }

        int getDefaultWidth() throws TranscoderException {
            this.init();
            return (int)Math.ceil(this.defaultWidth);
        }

        int getDefaultHeight() throws TranscoderException {
            this.init();
            return (int)Math.ceil(this.defaultHeight);
        }

        void setInput(TranscoderInput transcoderInput) {
            this.transcoderInput = transcoderInput;
        }

        protected UserAgent createUserAgent() {
            return new SVGImageReaderUserAgent();
        }

        private class SVGImageReaderUserAgent
        extends SVGAbstractTranscoder.SVGAbstractTranscoderUserAgent {
            private SVGImageReaderUserAgent() {
                super((SVGAbstractTranscoder)Rasterizer.this);
            }

            public void displayError(Exception exception) {
                this.displayError(exception.getMessage());
            }

            public void displayError(String string) {
                this.displayMessage(string);
            }

            public void displayMessage(String string) {
                SVGImageReader.this.processWarningOccurred(string.replaceAll("[\\r\\n]+", " "));
            }

            public ExternalResourceSecurity getExternalResourceSecurity(ParsedURL parsedURL, ParsedURL parsedURL2) {
                if (SVGImageReader.this.allowExternalResources) {
                    return super.getExternalResourceSecurity(parsedURL, parsedURL2);
                }
                return new EmbededExternalResourceSecurity(parsedURL);
            }
        }
    }
}

