/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.wmf;

import com.twelvemonkeys.imageio.plugins.wmf.WMF;
import com.twelvemonkeys.imageio.plugins.wmf.WMFImageReader;
import com.twelvemonkeys.imageio.spi.ProviderInfo;
import com.twelvemonkeys.imageio.util.IIOUtil;
import com.twelvemonkeys.lang.SystemUtil;
import java.io.IOException;
import java.util.Locale;
import javax.imageio.ImageReader;
import javax.imageio.spi.IIOServiceProvider;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WMFImageReaderSpi
extends ImageReaderSpi {
    private static final boolean WMF_READER_AVAILABLE = SystemUtil.isClassAvailable((String)"com.twelvemonkeys.imageio.plugins.svg.SVGImageReader");

    public WMFImageReaderSpi() {
        this(IIOUtil.getProviderInfo(WMFImageReaderSpi.class));
    }

    private WMFImageReaderSpi(ProviderInfo providerInfo) {
        String[] stringArray;
        String[] stringArray2;
        String[] stringArray3;
        String string = providerInfo.getVendorName();
        String string2 = providerInfo.getVersion();
        if (WMF_READER_AVAILABLE) {
            String[] stringArray4 = new String[2];
            stringArray4[0] = "wmf";
            stringArray3 = stringArray4;
            stringArray4[1] = "WMF";
        } else {
            String[] stringArray5 = new String[1];
            stringArray3 = stringArray5;
            stringArray5[0] = "";
        }
        if (WMF_READER_AVAILABLE) {
            String[] stringArray6 = new String[2];
            stringArray6[0] = "wmf";
            stringArray2 = stringArray6;
            stringArray6[1] = "emf";
        } else {
            stringArray2 = null;
        }
        if (WMF_READER_AVAILABLE) {
            String[] stringArray7 = new String[2];
            stringArray7[0] = "application/x-msmetafile";
            stringArray = stringArray7;
            stringArray7[1] = "image/x-wmf";
        } else {
            stringArray = null;
        }
        super(string, string2, stringArray3, stringArray2, stringArray, "com.twelvemonkeys.imageio.plugins.wmf.WMFImageReader", new Class[]{ImageInputStream.class}, null, true, null, null, null, null, true, null, null, null, null);
    }

    @Override
    public boolean canDecodeInput(Object object) throws IOException {
        return object instanceof ImageInputStream && WMF_READER_AVAILABLE && WMFImageReaderSpi.canDecode((ImageInputStream)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canDecode(ImageInputStream imageInputStream) throws IOException {
        if (imageInputStream == null) {
            throw new IllegalArgumentException("input == null");
        }
        try {
            imageInputStream.mark();
            for (byte by : WMF.HEADER) {
                byte by2 = (byte)imageInputStream.read();
                if (by == by2) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            imageInputStream.reset();
        }
    }

    @Override
    public ImageReader createReaderInstance(Object object) throws IOException {
        return new WMFImageReader(this);
    }

    @Override
    public String getDescription(Locale locale) {
        return "Windows Meta File (WMF) image reader";
    }

    @Override
    public void onRegistration(ServiceRegistry serviceRegistry, Class<?> clazz) {
        if (!WMF_READER_AVAILABLE) {
            IIOUtil.deregisterProvider((ServiceRegistry)serviceRegistry, (IIOServiceProvider)this, clazz);
        }
    }
}

