/*
 * Decompiled with CFR 0.152.
 */
package com.turo.pushy.apns.server;

import com.turo.pushy.apns.ApnsPushNotification;
import com.turo.pushy.apns.DeliveryPriority;
import com.turo.pushy.apns.server.MockApnsServerListener;
import com.turo.pushy.apns.server.RejectionReason;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.util.AsciiString;
import java.nio.charset.StandardCharsets;
import java.util.Date;

public abstract class ParsingMockApnsServerListenerAdapter
implements MockApnsServerListener {
    private static final String APNS_PATH_PREFIX = "/3/device/";
    private static final AsciiString APNS_TOPIC_HEADER = new AsciiString((CharSequence)"apns-topic");
    private static final AsciiString APNS_PRIORITY_HEADER = new AsciiString((CharSequence)"apns-priority");
    private static final AsciiString APNS_EXPIRATION_HEADER = new AsciiString((CharSequence)"apns-expiration");
    private static final AsciiString APNS_COLLAPSE_ID_HEADER = new AsciiString((CharSequence)"apns-collapse-id");

    @Override
    public void handlePushNotificationAccepted(Http2Headers headers, ByteBuf payload) {
        this.handlePushNotificationAccepted(ParsingMockApnsServerListenerAdapter.parsePushNotification(headers, payload));
    }

    public abstract void handlePushNotificationAccepted(ApnsPushNotification var1);

    @Override
    public void handlePushNotificationRejected(Http2Headers headers, ByteBuf payload, RejectionReason rejectionReason, Date deviceTokenExpirationTimestamp) {
        this.handlePushNotificationRejected(ParsingMockApnsServerListenerAdapter.parsePushNotification(headers, payload), rejectionReason, deviceTokenExpirationTimestamp);
    }

    public abstract void handlePushNotificationRejected(ApnsPushNotification var1, RejectionReason var2, Date var3);

    private static ApnsPushNotification parsePushNotification(Http2Headers headers, ByteBuf payload) {
        DeliveryPriority priorityFromCode;
        String pathString;
        CharSequence pathSequence = (CharSequence)headers.get((Object)Http2Headers.PseudoHeaderName.PATH.value());
        String deviceToken = pathSequence != null ? ((pathString = pathSequence.toString()).startsWith(APNS_PATH_PREFIX) ? pathString.substring(APNS_PATH_PREFIX.length()) : null) : null;
        CharSequence topicSequence = (CharSequence)headers.get((Object)APNS_TOPIC_HEADER);
        String topic = topicSequence != null ? topicSequence.toString() : null;
        Integer priorityCode = headers.getInt((Object)APNS_PRIORITY_HEADER);
        try {
            priorityFromCode = priorityCode != null ? DeliveryPriority.getFromCode(priorityCode) : null;
        }
        catch (IllegalArgumentException e) {
            priorityFromCode = null;
        }
        DeliveryPriority deliveryPriority = priorityFromCode;
        Integer expirationTimestamp = headers.getInt((Object)APNS_EXPIRATION_HEADER);
        Date expiration = expirationTimestamp != null ? new Date(expirationTimestamp * 1000) : null;
        CharSequence collapseIdSequence = (CharSequence)headers.get((Object)APNS_COLLAPSE_ID_HEADER);
        String collapseId = collapseIdSequence != null ? collapseIdSequence.toString() : null;
        return new LenientApnsPushNotification(deviceToken, topic, payload != null ? payload.toString(StandardCharsets.UTF_8) : null, expiration, deliveryPriority, collapseId);
    }

    private static class LenientApnsPushNotification
    implements ApnsPushNotification {
        private final String token;
        private final String payload;
        private final Date invalidationTime;
        private final DeliveryPriority priority;
        private final String topic;
        private final String collapseId;

        private LenientApnsPushNotification(String token, String topic, String payload, Date invalidationTime, DeliveryPriority priority, String collapseId) {
            this.token = token;
            this.payload = payload;
            this.invalidationTime = invalidationTime;
            this.priority = priority;
            this.topic = topic;
            this.collapseId = collapseId;
        }

        @Override
        public String getToken() {
            return this.token;
        }

        @Override
        public String getPayload() {
            return this.payload;
        }

        @Override
        public Date getExpiration() {
            return this.invalidationTime;
        }

        @Override
        public DeliveryPriority getPriority() {
            return this.priority;
        }

        @Override
        public String getTopic() {
            return this.topic;
        }

        @Override
        public String getCollapseId() {
            return this.collapseId;
        }
    }
}

