/*
 * Decompiled with CFR 0.152.
 */
package com.turo.pushy.apns.server;

import com.turo.pushy.apns.server.MockApnsServerHandler;
import com.turo.pushy.apns.server.MockApnsServerListener;
import com.turo.pushy.apns.server.PushNotificationHandler;
import com.turo.pushy.apns.server.PushNotificationHandlerFactory;
import com.turo.pushy.apns.server.ServerSocketChannelClassUtil;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.ReferenceCounted;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.SucceededFuture;
import java.util.concurrent.atomic.AtomicBoolean;

public class MockApnsServer {
    private final SslContext sslContext;
    private final AtomicBoolean hasReleasedSslContext = new AtomicBoolean(false);
    private final ServerBootstrap bootstrap;
    private final boolean shouldShutDownEventLoopGroup;
    private ChannelGroup allChannels;

    MockApnsServer(final SslContext sslContext, final PushNotificationHandlerFactory handlerFactory, final MockApnsServerListener listener, final int maxConcurrentStreams, EventLoopGroup eventLoopGroup) {
        this.sslContext = sslContext;
        if (this.sslContext instanceof ReferenceCounted) {
            ((ReferenceCounted)this.sslContext).retain();
        }
        this.bootstrap = new ServerBootstrap();
        if (eventLoopGroup != null) {
            this.bootstrap.group(eventLoopGroup);
            this.shouldShutDownEventLoopGroup = false;
        } else {
            this.bootstrap.group((EventLoopGroup)new NioEventLoopGroup(1));
            this.shouldShutDownEventLoopGroup = true;
        }
        this.bootstrap.channel(ServerSocketChannelClassUtil.getServerSocketChannelClass(this.bootstrap.config().group()));
        this.bootstrap.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel channel) throws Exception {
                final SslHandler sslHandler = sslContext.newHandler(channel.alloc());
                channel.pipeline().addLast(new ChannelHandler[]{sslHandler});
                channel.pipeline().addLast(new ChannelHandler[]{new ApplicationProtocolNegotiationHandler("http/1.1"){

                    protected void configurePipeline(ChannelHandlerContext context, String protocol) throws Exception {
                        if (!"h2".equals(protocol)) {
                            throw new IllegalStateException("Unexpected protocol: " + protocol);
                        }
                        PushNotificationHandler pushNotificationHandler = handlerFactory.buildHandler(sslHandler.engine().getSession());
                        MockApnsServerHandler serverHandler = new MockApnsServerHandler.MockApnsServerHandlerBuilder().pushNotificationHandler(pushNotificationHandler).initialSettings(Http2Settings.defaultSettings().maxConcurrentStreams((long)maxConcurrentStreams)).listener(listener).build();
                        context.pipeline().addLast(new ChannelHandler[]{serverHandler});
                        MockApnsServer.this.allChannels.add((Object)context.channel());
                    }
                }});
            }
        });
    }

    public Future<Void> start(int port) {
        ChannelFuture channelFuture = this.bootstrap.bind(port);
        this.allChannels = new DefaultChannelGroup((EventExecutor)channelFuture.channel().eventLoop(), true);
        this.allChannels.add((Object)channelFuture.channel());
        return channelFuture;
    }

    public Future<Void> shutdown() {
        SucceededFuture disconnectFuture;
        SucceededFuture channelCloseFuture;
        Object object = channelCloseFuture = this.allChannels != null ? this.allChannels.close() : new SucceededFuture((EventExecutor)GlobalEventExecutor.INSTANCE, null);
        if (this.shouldShutDownEventLoopGroup) {
            channelCloseFuture.addListener((GenericFutureListener)new GenericFutureListener<Future<Void>>(){

                public void operationComplete(Future<Void> future) throws Exception {
                    MockApnsServer.this.bootstrap.config().group().shutdownGracefully();
                }
            });
            disconnectFuture = new DefaultPromise((EventExecutor)GlobalEventExecutor.INSTANCE);
            this.bootstrap.config().group().terminationFuture().addListener(new GenericFutureListener((Future)disconnectFuture){
                final /* synthetic */ Future val$disconnectFuture;
                {
                    this.val$disconnectFuture = future;
                }

                public void operationComplete(Future future) throws Exception {
                    ((Promise)this.val$disconnectFuture).trySuccess(null);
                }
            });
        } else {
            disconnectFuture = channelCloseFuture;
        }
        disconnectFuture.addListener((GenericFutureListener)new GenericFutureListener<Future<Void>>(){

            public void operationComplete(Future<Void> future) throws Exception {
                if (MockApnsServer.this.sslContext instanceof ReferenceCounted && MockApnsServer.this.hasReleasedSslContext.compareAndSet(false, true)) {
                    ((ReferenceCounted)MockApnsServer.this.sslContext).release();
                }
            }
        });
        return disconnectFuture;
    }
}

