/*
 * Decompiled with CFR 0.152.
 */
package com.turo.pushy.apns.auth;

import com.turo.pushy.apns.auth.ApnsKey;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.interfaces.ECPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import org.apache.commons.codec.binary.Base64;

public class ApnsSigningKey
extends ApnsKey
implements ECPrivateKey {
    private static final long serialVersionUID = 1L;

    public ApnsSigningKey(String keyId, String teamId, ECPrivateKey key) throws NoSuchAlgorithmException, InvalidKeyException {
        super(keyId, teamId, key);
        Signature signature = Signature.getInstance("SHA256withECDSA");
        signature.initSign(key);
    }

    @Override
    protected ECPrivateKey getKey() {
        return (ECPrivateKey)super.getKey();
    }

    @Override
    public String getAlgorithm() {
        return this.getKey().getAlgorithm();
    }

    @Override
    public String getFormat() {
        return this.getKey().getFormat();
    }

    @Override
    public byte[] getEncoded() {
        return this.getKey().getEncoded();
    }

    @Override
    public BigInteger getS() {
        return this.getKey().getS();
    }

    public static ApnsSigningKey loadFromPkcs8File(File pkcs8File, String teamId, String keyId) throws IOException, NoSuchAlgorithmException, InvalidKeyException {
        try (FileInputStream fileInputStream = new FileInputStream(pkcs8File);){
            ApnsSigningKey apnsSigningKey = ApnsSigningKey.loadFromInputStream(fileInputStream, teamId, keyId);
            return apnsSigningKey;
        }
    }

    public static ApnsSigningKey loadFromInputStream(InputStream inputStream, String teamId, String keyId) throws IOException, NoSuchAlgorithmException, InvalidKeyException {
        ECPrivateKey signingKey;
        String line;
        StringBuilder privateKeyBuilder = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        boolean haveReadHeader = false;
        boolean haveReadFooter = false;
        while ((line = reader.readLine()) != null) {
            if (!haveReadHeader) {
                if (!line.contains("BEGIN PRIVATE KEY")) continue;
                haveReadHeader = true;
                continue;
            }
            if (line.contains("END PRIVATE KEY")) {
                haveReadFooter = true;
                break;
            }
            privateKeyBuilder.append(line);
        }
        if (!haveReadHeader || !haveReadFooter) {
            throw new IOException("Could not find private key header/footer");
        }
        String base64EncodedPrivateKey = privateKeyBuilder.toString();
        byte[] keyBytes = Base64.decodeBase64((String)base64EncodedPrivateKey);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("EC");
        try {
            signingKey = (ECPrivateKey)keyFactory.generatePrivate(keySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new InvalidKeyException(e);
        }
        return new ApnsSigningKey(keyId, teamId, signingKey);
    }
}

