/*
 * Decompiled with CFR 0.152.
 */
package com.turo.pushy.apns;

import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.oio.OioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.channel.socket.oio.OioSocketChannel;
import java.util.Objects;

class ClientSocketChannelClassUtil {
    private static final String EPOLL_EVENT_LOOP_GROUP_CLASS = "io.netty.channel.epoll.EpollEventLoopGroup";
    private static final String EPOLL_SOCKET_CHANNEL_CLASS = "io.netty.channel.epoll.EpollSocketChannel";
    private static final String KQUEUE_EVENT_LOOP_GROUP_CLASS = "io.netty.channel.kqueue.KQueueEventLoopGroup";
    private static final String KQUEUE_SOCKET_CHANNEL_CLASS = "io.netty.channel.kqueue.KQueueSocketChannel";

    ClientSocketChannelClassUtil() {
    }

    static Class<? extends Channel> getSocketChannelClass(EventLoopGroup eventLoopGroup) {
        Class<NioSocketChannel> socketChannelClass;
        Objects.requireNonNull(eventLoopGroup);
        if (eventLoopGroup instanceof NioEventLoopGroup) {
            socketChannelClass = NioSocketChannel.class;
        } else if (eventLoopGroup instanceof OioEventLoopGroup) {
            socketChannelClass = OioSocketChannel.class;
        } else if (EPOLL_EVENT_LOOP_GROUP_CLASS.equals(eventLoopGroup.getClass().getName())) {
            socketChannelClass = ClientSocketChannelClassUtil.loadSocketChannelClass(EPOLL_SOCKET_CHANNEL_CLASS);
        } else if (KQUEUE_EVENT_LOOP_GROUP_CLASS.equals(eventLoopGroup.getClass().getName())) {
            socketChannelClass = ClientSocketChannelClassUtil.loadSocketChannelClass(KQUEUE_SOCKET_CHANNEL_CLASS);
        } else {
            throw new IllegalArgumentException("Could not find socket class for event loop group class: " + eventLoopGroup.getClass().getName());
        }
        return socketChannelClass;
    }

    private static Class<? extends Channel> loadSocketChannelClass(String className) {
        try {
            return Class.forName(className).asSubclass(Channel.class);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

