/*
 * Decompiled with CFR 0.152.
 */
package com.turo.pushy.apns;

import com.turo.pushy.apns.ApnsChannelFactory;
import com.turo.pushy.apns.ApnsChannelPool;
import com.turo.pushy.apns.ApnsChannelPoolMetricsListener;
import com.turo.pushy.apns.ApnsClientMetricsListener;
import com.turo.pushy.apns.ApnsPushNotification;
import com.turo.pushy.apns.PushNotificationAndResponsePromise;
import com.turo.pushy.apns.PushNotificationResponse;
import com.turo.pushy.apns.auth.ApnsSigningKey;
import com.turo.pushy.apns.proxy.ProxyHandlerFactory;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.handler.ssl.SslContext;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.FailedFuture;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.OrderedEventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.SucceededFuture;
import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApnsClient {
    private final EventLoopGroup eventLoopGroup;
    private final boolean shouldShutDownEventLoopGroup;
    private final ApnsChannelPool channelPool;
    private final ApnsClientMetricsListener metricsListener;
    private final AtomicLong nextNotificationId = new AtomicLong(0L);
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private static final IllegalStateException CLIENT_CLOSED_EXCEPTION = new IllegalStateException("Client has been closed and can no longer send push notifications.");
    private static final Logger log = LoggerFactory.getLogger(ApnsClient.class);

    protected ApnsClient(InetSocketAddress apnsServerAddress, SslContext sslContext, ApnsSigningKey signingKey, ProxyHandlerFactory proxyHandlerFactory, int connectTimeoutMillis, long idlePingIntervalMillis, long gracefulShutdownTimeoutMillis, int concurrentConnections, ApnsClientMetricsListener metricsListener, EventLoopGroup eventLoopGroup) {
        if (eventLoopGroup != null) {
            this.eventLoopGroup = eventLoopGroup;
            this.shouldShutDownEventLoopGroup = false;
        } else {
            this.eventLoopGroup = new NioEventLoopGroup(1);
            this.shouldShutDownEventLoopGroup = true;
        }
        this.metricsListener = metricsListener != null ? metricsListener : new NoopApnsClientMetricsListener();
        ApnsChannelFactory channelFactory = new ApnsChannelFactory(sslContext, signingKey, proxyHandlerFactory, connectTimeoutMillis, idlePingIntervalMillis, gracefulShutdownTimeoutMillis, apnsServerAddress, this.eventLoopGroup);
        ApnsChannelPoolMetricsListener channelPoolMetricsListener = new ApnsChannelPoolMetricsListener(){

            @Override
            public void handleConnectionAdded() {
                ApnsClient.this.metricsListener.handleConnectionAdded(ApnsClient.this);
            }

            @Override
            public void handleConnectionRemoved() {
                ApnsClient.this.metricsListener.handleConnectionRemoved(ApnsClient.this);
            }

            @Override
            public void handleConnectionCreationFailed() {
                ApnsClient.this.metricsListener.handleConnectionCreationFailed(ApnsClient.this);
            }
        };
        this.channelPool = new ApnsChannelPool(channelFactory, concurrentConnections, (OrderedEventExecutor)this.eventLoopGroup.next(), channelPoolMetricsListener);
    }

    public <T extends ApnsPushNotification> Future<PushNotificationResponse<T>> sendNotification(final T notification) {
        FailedFuture responseFuture;
        if (!this.isClosed.get()) {
            DefaultPromise responsePromise = new DefaultPromise((EventExecutor)this.eventLoopGroup.next());
            final long notificationId = this.nextNotificationId.getAndIncrement();
            this.channelPool.acquire().addListener((GenericFutureListener)new GenericFutureListener<Future<Channel>>((Promise)responsePromise, notificationId){
                final /* synthetic */ Promise val$responsePromise;
                final /* synthetic */ long val$notificationId;
                {
                    this.val$responsePromise = promise;
                    this.val$notificationId = l;
                }

                public void operationComplete(Future<Channel> acquireFuture) throws Exception {
                    if (acquireFuture.isSuccess()) {
                        Channel channel = (Channel)acquireFuture.getNow();
                        channel.writeAndFlush((Object)new PushNotificationAndResponsePromise(notification, (Promise<PushNotificationResponse<ApnsPushNotification>>)this.val$responsePromise)).addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

                            public void operationComplete(ChannelFuture future) throws Exception {
                                if (future.isSuccess()) {
                                    ApnsClient.this.metricsListener.handleNotificationSent(ApnsClient.this, val$notificationId);
                                } else {
                                    ApnsClient.this.metricsListener.handleWriteFailure(ApnsClient.this, val$notificationId);
                                    val$responsePromise.tryFailure(future.cause());
                                }
                            }
                        });
                        ApnsClient.this.channelPool.release(channel);
                    } else {
                        this.val$responsePromise.tryFailure(acquireFuture.cause());
                    }
                }
            });
            responsePromise.addListener((GenericFutureListener)new GenericFutureListener<Future<PushNotificationResponse<ApnsPushNotification>>>(){

                public void operationComplete(Future<PushNotificationResponse<ApnsPushNotification>> future) throws Exception {
                    if (future.isSuccess()) {
                        PushNotificationResponse response = (PushNotificationResponse)future.getNow();
                        if (response.isAccepted()) {
                            ApnsClient.this.metricsListener.handleNotificationAccepted(ApnsClient.this, notificationId);
                        } else {
                            ApnsClient.this.metricsListener.handleNotificationRejected(ApnsClient.this, notificationId);
                        }
                    } else {
                        ApnsClient.this.metricsListener.handleWriteFailure(ApnsClient.this, notificationId);
                    }
                }
            });
            responseFuture = responsePromise;
        } else {
            responseFuture = new FailedFuture((EventExecutor)GlobalEventExecutor.INSTANCE, (Throwable)CLIENT_CLOSED_EXCEPTION);
        }
        return responseFuture;
    }

    public Future<Void> close() {
        SucceededFuture closeFuture;
        log.info("Shutting down.");
        if (this.isClosed.compareAndSet(false, true)) {
            DefaultPromise closePromise = new DefaultPromise((EventExecutor)GlobalEventExecutor.INSTANCE);
            this.channelPool.close().addListener((GenericFutureListener)new GenericFutureListener<Future<Void>>((Promise)closePromise){
                final /* synthetic */ Promise val$closePromise;
                {
                    this.val$closePromise = promise;
                }

                public void operationComplete(Future<Void> closePoolFuture) throws Exception {
                    if (ApnsClient.this.shouldShutDownEventLoopGroup) {
                        ApnsClient.this.eventLoopGroup.shutdownGracefully().addListener(new GenericFutureListener(){

                            public void operationComplete(Future future) throws Exception {
                                val$closePromise.trySuccess(null);
                            }
                        });
                    } else {
                        this.val$closePromise.trySuccess(null);
                    }
                }
            });
            closeFuture = closePromise;
        } else {
            closeFuture = new SucceededFuture((EventExecutor)GlobalEventExecutor.INSTANCE, null);
        }
        return closeFuture;
    }

    private static class NoopApnsClientMetricsListener
    implements ApnsClientMetricsListener {
        private NoopApnsClientMetricsListener() {
        }

        @Override
        public void handleWriteFailure(ApnsClient apnsClient, long notificationId) {
        }

        @Override
        public void handleNotificationSent(ApnsClient apnsClient, long notificationId) {
        }

        @Override
        public void handleNotificationAccepted(ApnsClient apnsClient, long notificationId) {
        }

        @Override
        public void handleNotificationRejected(ApnsClient apnsClient, long notificationId) {
        }

        @Override
        public void handleConnectionAdded(ApnsClient apnsClient) {
        }

        @Override
        public void handleConnectionRemoved(ApnsClient apnsClient) {
        }

        @Override
        public void handleConnectionCreationFailed(ApnsClient apnsClient) {
        }
    }
}

