/*
 * Decompiled with CFR 0.152.
 */
package com.turo.pushy.apns;

import com.turo.pushy.apns.ApnsClientHandler;
import com.turo.pushy.apns.ApnsPushNotification;
import com.turo.pushy.apns.AuthenticationToken;
import com.turo.pushy.apns.ErrorResponse;
import com.turo.pushy.apns.auth.ApnsSigningKey;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.util.AsciiString;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TokenAuthenticationApnsClientHandler
extends ApnsClientHandler {
    private final ApnsSigningKey signingKey;
    private AuthenticationToken authenticationToken;
    private int mostRecentStreamWithNewToken = 0;
    private static final AsciiString APNS_AUTHORIZATION_HEADER = new AsciiString((CharSequence)"authorization");
    private static final String EXPIRED_AUTH_TOKEN_REASON = "ExpiredProviderToken";
    private static final Logger log = LoggerFactory.getLogger(TokenAuthenticationApnsClientHandler.class);

    protected TokenAuthenticationApnsClientHandler(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings, String authority, ApnsSigningKey signingKey, long idlePingIntervalMillis) {
        super(decoder, encoder, initialSettings, authority, idlePingIntervalMillis);
        Objects.requireNonNull(signingKey, "Signing key must not be null for token-based client handlers.");
        this.signingKey = signingKey;
    }

    @Override
    protected Http2Headers getHeadersForPushNotification(ApnsPushNotification pushNotification, int streamId) {
        Http2Headers headers = super.getHeadersForPushNotification(pushNotification, streamId);
        if (this.authenticationToken == null) {
            try {
                this.authenticationToken = new AuthenticationToken(this.signingKey, new Date());
                this.mostRecentStreamWithNewToken = streamId;
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
                log.error("Failed to generate authentication token.", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        headers.add((Object)APNS_AUTHORIZATION_HEADER, (Object)("bearer " + this.authenticationToken.toString()));
        return headers;
    }

    @Override
    protected void handleErrorResponse(ChannelHandlerContext context, int streamId, Http2Headers headers, ApnsPushNotification pushNotification, ErrorResponse errorResponse) {
        if (EXPIRED_AUTH_TOKEN_REASON.equals(errorResponse.getReason())) {
            if (streamId >= this.mostRecentStreamWithNewToken) {
                this.authenticationToken = null;
            }
            this.retryPushNotificationFromStream(context, streamId);
        } else {
            super.handleErrorResponse(context, streamId, headers, pushNotification, errorResponse);
        }
    }

    public static class TokenAuthenticationApnsClientHandlerBuilder
    extends ApnsClientHandler.ApnsClientHandlerBuilder {
        private ApnsSigningKey signingKey;

        public TokenAuthenticationApnsClientHandlerBuilder signingKey(ApnsSigningKey signingKey) {
            this.signingKey = signingKey;
            return this;
        }

        public ApnsSigningKey signingKey() {
            return this.signingKey;
        }

        @Override
        public ApnsClientHandler build(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings) {
            Objects.requireNonNull(this.authority(), "Authority must be set before building a TokenAuthenticationApnsClientHandler.");
            Objects.requireNonNull(this.signingKey(), "Signing key must be set before building a TokenAuthenticationApnsClientHandler.");
            TokenAuthenticationApnsClientHandler handler = new TokenAuthenticationApnsClientHandler(decoder, encoder, initialSettings, this.authority(), this.signingKey(), this.idlePingIntervalMillis());
            this.frameListener(handler);
            return handler;
        }
    }
}

