/*
 * Decompiled with CFR 0.152.
 */
package com.turo.pushy.apns;

import com.turo.pushy.apns.ApnsClient;
import com.turo.pushy.apns.ApnsClientMetricsListener;
import com.turo.pushy.apns.P12Util;
import com.turo.pushy.apns.SslUtil;
import com.turo.pushy.apns.auth.ApnsSigningKey;
import com.turo.pushy.apns.proxy.ProxyHandlerFactory;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.http2.Http2SecurityUtil;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApnsClientBuilder {
    private X509Certificate clientCertificate;
    private PrivateKey privateKey;
    private String privateKeyPassword;
    private ApnsSigningKey signingKey;
    private File trustedServerCertificatePemFile;
    private InputStream trustedServerCertificateInputStream;
    private X509Certificate[] trustedServerCertificates;
    private EventLoopGroup eventLoopGroup;
    private ApnsClientMetricsListener metricsListener;
    private ProxyHandlerFactory proxyHandlerFactory;
    private Long connectionTimeout;
    private TimeUnit connectionTimeoutUnit;
    private Long idlePingInterval;
    private TimeUnit idlePingIntervalUnit;
    private Long gracefulShutdownTimeout;
    private TimeUnit gracefulShutdownTimeoutUnit;
    private static final Logger log = LoggerFactory.getLogger(ApnsClientBuilder.class);

    public ApnsClientBuilder setClientCredentials(File p12File, String p12Password) throws SSLException, IOException {
        try (FileInputStream p12InputStream = new FileInputStream(p12File);){
            ApnsClientBuilder apnsClientBuilder = this.setClientCredentials(p12InputStream, p12Password);
            return apnsClientBuilder;
        }
    }

    public ApnsClientBuilder setClientCredentials(InputStream p12InputStream, String p12Password) throws SSLException, IOException {
        PrivateKey privateKey;
        X509Certificate x509Certificate;
        try {
            KeyStore.PrivateKeyEntry privateKeyEntry = P12Util.getFirstPrivateKeyEntryFromP12InputStream(p12InputStream, p12Password);
            Certificate certificate = privateKeyEntry.getCertificate();
            if (!(certificate instanceof X509Certificate)) {
                throw new KeyStoreException("Found a certificate in the provided PKCS#12 file, but it was not an X.509 certificate.");
            }
            x509Certificate = (X509Certificate)certificate;
            privateKey = privateKeyEntry.getPrivateKey();
        }
        catch (KeyStoreException e) {
            throw new SSLException(e);
        }
        return this.setClientCredentials(x509Certificate, privateKey, p12Password);
    }

    public ApnsClientBuilder setClientCredentials(X509Certificate clientCertificate, PrivateKey privateKey, String privateKeyPassword) {
        this.clientCertificate = clientCertificate;
        this.privateKey = privateKey;
        this.privateKeyPassword = privateKeyPassword;
        return this;
    }

    public ApnsClientBuilder setSigningKey(ApnsSigningKey signingKey) {
        this.signingKey = signingKey;
        return this;
    }

    public ApnsClientBuilder setTrustedServerCertificateChain(File certificatePemFile) {
        this.trustedServerCertificatePemFile = certificatePemFile;
        this.trustedServerCertificateInputStream = null;
        this.trustedServerCertificates = null;
        return this;
    }

    public ApnsClientBuilder setTrustedServerCertificateChain(InputStream certificateInputStream) {
        this.trustedServerCertificatePemFile = null;
        this.trustedServerCertificateInputStream = certificateInputStream;
        this.trustedServerCertificates = null;
        return this;
    }

    public ApnsClientBuilder setTrustedServerCertificateChain(X509Certificate ... certificates) {
        this.trustedServerCertificatePemFile = null;
        this.trustedServerCertificateInputStream = null;
        this.trustedServerCertificates = certificates;
        return this;
    }

    public ApnsClientBuilder setEventLoopGroup(EventLoopGroup eventLoopGroup) {
        this.eventLoopGroup = eventLoopGroup;
        return this;
    }

    public ApnsClientBuilder setMetricsListener(ApnsClientMetricsListener metricsListener) {
        this.metricsListener = metricsListener;
        return this;
    }

    public ApnsClientBuilder setProxyHandlerFactory(ProxyHandlerFactory proxyHandlerFactory) {
        this.proxyHandlerFactory = proxyHandlerFactory;
        return this;
    }

    public ApnsClientBuilder setConnectionTimeout(long connectionTimeout, TimeUnit timeoutUnit) {
        this.connectionTimeout = connectionTimeout;
        this.connectionTimeoutUnit = timeoutUnit;
        return this;
    }

    public ApnsClientBuilder setIdlePingInterval(long pingInterval, TimeUnit timeoutUnit) {
        this.idlePingInterval = pingInterval;
        this.idlePingIntervalUnit = timeoutUnit;
        return this;
    }

    public ApnsClientBuilder setGracefulShutdownTimeout(long gracefulShutdownTimeout, TimeUnit timeoutUnit) {
        this.gracefulShutdownTimeout = gracefulShutdownTimeout;
        this.gracefulShutdownTimeoutUnit = timeoutUnit;
        return this;
    }

    public ApnsClient build() throws SSLException {
        if (this.clientCertificate == null && this.privateKey == null && this.signingKey == null) {
            throw new IllegalStateException("No client credentials specified; either TLS credentials (a certificate/private key) or an APNs signing key must be provided before building a client.");
        }
        if ((this.clientCertificate != null || this.privateKey != null) && this.signingKey != null) {
            throw new IllegalStateException("Clients may not have both a signing key and TLS credentials.");
        }
        SslProvider sslProvider = SslUtil.getSslProvider();
        SslContextBuilder sslContextBuilder = SslContextBuilder.forClient().sslProvider(sslProvider).ciphers((Iterable)Http2SecurityUtil.CIPHERS, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE).applicationProtocolConfig(new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"h2"}));
        if (this.clientCertificate != null && this.privateKey != null) {
            sslContextBuilder.keyManager(this.privateKey, this.privateKeyPassword, new X509Certificate[]{this.clientCertificate});
        }
        if (this.trustedServerCertificatePemFile != null) {
            sslContextBuilder.trustManager(this.trustedServerCertificatePemFile);
        } else if (this.trustedServerCertificateInputStream != null) {
            sslContextBuilder.trustManager(this.trustedServerCertificateInputStream);
        } else if (this.trustedServerCertificates != null) {
            sslContextBuilder.trustManager(this.trustedServerCertificates);
        }
        SslContext sslContext = sslContextBuilder.build();
        ApnsClient apnsClient = new ApnsClient(sslContext, this.signingKey, this.eventLoopGroup);
        apnsClient.setMetricsListener(this.metricsListener);
        apnsClient.setProxyHandlerFactory(this.proxyHandlerFactory);
        if (this.connectionTimeout != null) {
            apnsClient.setConnectionTimeout((int)this.connectionTimeoutUnit.toMillis(this.connectionTimeout));
        }
        if (this.idlePingInterval != null) {
            apnsClient.setPingInterval(this.idlePingIntervalUnit.toMillis(this.idlePingInterval));
        }
        if (this.gracefulShutdownTimeout != null) {
            apnsClient.setGracefulShutdownTimeout(this.gracefulShutdownTimeoutUnit.toMillis(this.gracefulShutdownTimeout));
        }
        return apnsClient;
    }
}

