/*
 * Decompiled with CFR 0.152.
 */
package com.turo.pushy.apns;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.turo.pushy.apns.DateAsTimeSinceEpochTypeAdapter;
import com.turo.pushy.apns.DeliveryPriority;
import com.turo.pushy.apns.ErrorResponse;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http2.AbstractHttp2ConnectionHandlerBuilder;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.util.AsciiString;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseCombiner;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractMockApnsServerHandler
extends Http2ConnectionHandler
implements Http2FrameListener {
    private final boolean emulateInternalErrors;
    private final Http2Connection.PropertyKey apnsIdPropertyKey = this.connection().newKey();
    private final Map<String, Map<String, Date>> deviceTokenExpirationsByTopic;
    private static final Http2Headers SUCCESS_HEADERS = new DefaultHttp2Headers().status((CharSequence)HttpResponseStatus.OK.codeAsText());
    private static final String APNS_PATH_PREFIX = "/3/device/";
    private static final AsciiString APNS_TOPIC_HEADER = new AsciiString((CharSequence)"apns-topic");
    private static final AsciiString APNS_PRIORITY_HEADER = new AsciiString((CharSequence)"apns-priority");
    private static final AsciiString APNS_ID_HEADER = new AsciiString((CharSequence)"apns-id");
    private static final int MAX_CONTENT_LENGTH = 4096;
    private static final Pattern DEVICE_TOKEN_PATTERN = Pattern.compile("[0-9a-fA-F]{64}");
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(Date.class, (Object)new DateAsTimeSinceEpochTypeAdapter(TimeUnit.MILLISECONDS)).create();
    private static final Logger log = LoggerFactory.getLogger(AbstractMockApnsServerHandler.class);

    protected AbstractMockApnsServerHandler(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings, boolean emulateInternalErrors, Map<String, Map<String, Date>> deviceTokenExpirationsByTopic) {
        super(decoder, encoder, initialSettings);
        this.emulateInternalErrors = emulateInternalErrors;
        this.deviceTokenExpirationsByTopic = deviceTokenExpirationsByTopic;
    }

    public int onDataRead(ChannelHandlerContext context, int streamId, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
        Http2Stream stream;
        int bytesProcessed = data.readableBytes() + padding;
        if (endOfStream && (stream = this.connection().stream(streamId)).state() == Http2Stream.State.OPEN) {
            UUID apnsId = (UUID)stream.getProperty(this.apnsIdPropertyKey);
            if (data.readableBytes() <= 4096) {
                context.channel().writeAndFlush((Object)new AcceptNotificationResponse(streamId));
            } else {
                context.channel().writeAndFlush((Object)new RejectNotificationResponse(streamId, apnsId, ErrorReason.PAYLOAD_TOO_LARGE, null));
            }
        }
        return bytesProcessed;
    }

    public void onHeadersRead(ChannelHandlerContext context, int streamId, Http2Headers headers, int padding, boolean endOfStream) throws Http2Exception {
        if (this.emulateInternalErrors) {
            context.channel().writeAndFlush((Object)new InternalServerErrorResponse(streamId));
        } else {
            Http2Stream stream = this.connection().stream(streamId);
            UUID apnsId = null;
            try {
                CharSequence apnsIdSequence = (CharSequence)headers.get((Object)APNS_ID_HEADER);
                if (apnsIdSequence != null) {
                    try {
                        apnsId = UUID.fromString(apnsIdSequence.toString());
                    }
                    catch (IllegalArgumentException e) {
                        throw new RejectedNotificationException(ErrorReason.BAD_MESSAGE_ID);
                    }
                } else {
                    apnsId = UUID.randomUUID();
                }
                if (!HttpMethod.POST.asciiName().contentEquals((CharSequence)headers.get((Object)Http2Headers.PseudoHeaderName.METHOD.value()))) {
                    throw new RejectedNotificationException(ErrorReason.METHOD_NOT_ALLOWED);
                }
                if (endOfStream) {
                    throw new RejectedNotificationException(ErrorReason.PAYLOAD_EMPTY);
                }
                this.verifyHeaders(headers);
                stream.setProperty(this.apnsIdPropertyKey, (Object)apnsId);
            }
            catch (RejectedNotificationException e) {
                context.channel().writeAndFlush((Object)new RejectNotificationResponse(streamId, apnsId, e.getErrorReason(), e.getDeviceTokenExpirationTimestamp()));
            }
        }
    }

    protected void verifyHeaders(Http2Headers headers) throws RejectedNotificationException {
        CharSequence pathSequence;
        String topic;
        CharSequence topicSequence = (CharSequence)headers.get((Object)APNS_TOPIC_HEADER);
        String string = topic = topicSequence != null ? topicSequence.toString() : null;
        if (topic == null) {
            throw new RejectedNotificationException(ErrorReason.MISSING_TOPIC);
        }
        Integer priorityCode = headers.getInt((Object)APNS_PRIORITY_HEADER);
        if (priorityCode != null) {
            try {
                DeliveryPriority.getFromCode(priorityCode);
            }
            catch (IllegalArgumentException e) {
                throw new RejectedNotificationException(ErrorReason.BAD_PRIORITY);
            }
        }
        if ((pathSequence = (CharSequence)headers.get((Object)Http2Headers.PseudoHeaderName.PATH.value())) != null) {
            String pathString = pathSequence.toString();
            if (pathString.startsWith(APNS_PATH_PREFIX)) {
                boolean deviceTokenRegisteredForTopic;
                String tokenString = pathString.substring(APNS_PATH_PREFIX.length());
                Matcher tokenMatcher = DEVICE_TOKEN_PATTERN.matcher(tokenString);
                if (!tokenMatcher.matches()) {
                    throw new RejectedNotificationException(ErrorReason.BAD_DEVICE_TOKEN);
                }
                Map<String, Date> expirationTimestampsByDeviceToken = this.deviceTokenExpirationsByTopic.get(topic);
                Date expirationTimestamp = expirationTimestampsByDeviceToken != null ? expirationTimestampsByDeviceToken.get(tokenString) : null;
                boolean bl = deviceTokenRegisteredForTopic = expirationTimestampsByDeviceToken != null && expirationTimestampsByDeviceToken.containsKey(tokenString);
                if (expirationTimestamp != null) {
                    throw new RejectedNotificationException(ErrorReason.UNREGISTERED, expirationTimestamp);
                }
                if (!deviceTokenRegisteredForTopic) {
                    throw new RejectedNotificationException(ErrorReason.DEVICE_TOKEN_NOT_FOR_TOPIC);
                }
            }
        } else {
            throw new RejectedNotificationException(ErrorReason.BAD_PATH);
        }
    }

    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endOfStream) throws Http2Exception {
        this.onHeadersRead(ctx, streamId, headers, padding, endOfStream);
    }

    public void onPriorityRead(ChannelHandlerContext ctx, int streamId, int streamDependency, short weight, boolean exclusive) throws Http2Exception {
    }

    public void onRstStreamRead(ChannelHandlerContext ctx, int streamId, long errorCode) throws Http2Exception {
    }

    public void onSettingsAckRead(ChannelHandlerContext ctx) throws Http2Exception {
    }

    public void onSettingsRead(ChannelHandlerContext ctx, Http2Settings settings) throws Http2Exception {
    }

    public void onPingRead(ChannelHandlerContext ctx, ByteBuf data) throws Http2Exception {
    }

    public void onPingAckRead(ChannelHandlerContext ctx, ByteBuf data) throws Http2Exception {
    }

    public void onPushPromiseRead(ChannelHandlerContext ctx, int streamId, int promisedStreamId, Http2Headers headers, int padding) throws Http2Exception {
    }

    public void onGoAwayRead(ChannelHandlerContext ctx, int lastStreamId, long errorCode, ByteBuf debugData) throws Http2Exception {
    }

    public void onWindowUpdateRead(ChannelHandlerContext ctx, int streamId, int windowSizeIncrement) throws Http2Exception {
    }

    public void onUnknownFrame(ChannelHandlerContext ctx, byte frameType, int streamId, Http2Flags flags, ByteBuf payload) throws Http2Exception {
    }

    public void write(ChannelHandlerContext context, Object message, ChannelPromise writePromise) throws Exception {
        if (message instanceof AcceptNotificationResponse) {
            AcceptNotificationResponse acceptNotificationResponse = (AcceptNotificationResponse)message;
            this.encoder().writeHeaders(context, acceptNotificationResponse.getStreamId(), SUCCESS_HEADERS, 0, true, writePromise);
            log.trace("Accepted push notification on stream {}", (Object)acceptNotificationResponse.getStreamId());
        } else if (message instanceof RejectNotificationResponse) {
            RejectNotificationResponse rejectNotificationResponse = (RejectNotificationResponse)message;
            DefaultHttp2Headers headers = new DefaultHttp2Headers();
            headers.status((CharSequence)rejectNotificationResponse.getErrorReason().getHttpResponseStatus().codeAsText());
            headers.add((Object)HttpHeaderNames.CONTENT_TYPE, (Object)"application/json");
            if (rejectNotificationResponse.getApnsId() != null) {
                headers.add((Object)APNS_ID_HEADER, (Object)rejectNotificationResponse.getApnsId().toString());
            }
            ErrorResponse errorResponse = new ErrorResponse(rejectNotificationResponse.getErrorReason().getReasonText(), rejectNotificationResponse.getTimestamp());
            byte[] payloadBytes = GSON.toJson((Object)errorResponse).getBytes();
            ChannelPromise headersPromise = context.newPromise();
            this.encoder().writeHeaders(context, rejectNotificationResponse.getStreamId(), (Http2Headers)headers, 0, false, headersPromise);
            ChannelPromise dataPromise = context.newPromise();
            this.encoder().writeData(context, rejectNotificationResponse.getStreamId(), Unpooled.wrappedBuffer((byte[])payloadBytes), 0, true, dataPromise);
            PromiseCombiner promiseCombiner = new PromiseCombiner();
            promiseCombiner.addAll(new Future[]{headersPromise, dataPromise});
            promiseCombiner.finish((Promise)writePromise);
            log.trace("Rejected push notification on stream {}: {}", (Object)rejectNotificationResponse.getStreamId(), (Object)rejectNotificationResponse.getErrorReason());
        } else if (message instanceof InternalServerErrorResponse) {
            InternalServerErrorResponse internalServerErrorResponse = (InternalServerErrorResponse)message;
            DefaultHttp2Headers headers = new DefaultHttp2Headers();
            headers.status((CharSequence)HttpResponseStatus.INTERNAL_SERVER_ERROR.codeAsText());
            this.encoder().writeHeaders(context, internalServerErrorResponse.getStreamId(), (Http2Headers)headers, 0, true, writePromise);
            log.trace("Encountered an internal error on stream {}", (Object)internalServerErrorResponse.getStreamId());
        } else {
            context.write(message, writePromise);
        }
    }

    private static class InternalServerErrorResponse {
        private final int streamId;

        public InternalServerErrorResponse(int streamId) {
            this.streamId = streamId;
        }

        public int getStreamId() {
            return this.streamId;
        }
    }

    private static class RejectNotificationResponse {
        private final int streamId;
        private final UUID apnsId;
        private final ErrorReason errorReason;
        private final Date timestamp;

        public RejectNotificationResponse(int streamId, UUID apnsId, ErrorReason errorReason, Date timestamp) {
            this.streamId = streamId;
            this.apnsId = apnsId;
            this.errorReason = errorReason;
            this.timestamp = timestamp;
        }

        public int getStreamId() {
            return this.streamId;
        }

        public UUID getApnsId() {
            return this.apnsId;
        }

        public ErrorReason getErrorReason() {
            return this.errorReason;
        }

        public Date getTimestamp() {
            return this.timestamp;
        }
    }

    private static class AcceptNotificationResponse {
        private final int streamId;

        public AcceptNotificationResponse(int streamId) {
            this.streamId = streamId;
        }

        public int getStreamId() {
            return this.streamId;
        }
    }

    public static abstract class AbstractMockApnsServerHandlerBuilder
    extends AbstractHttp2ConnectionHandlerBuilder<AbstractMockApnsServerHandler, AbstractMockApnsServerHandlerBuilder> {
        private boolean emulateInternalErrors;
        private Map<String, Map<String, Date>> deviceTokenExpirationsByTopic;

        public AbstractMockApnsServerHandlerBuilder initialSettings(Http2Settings initialSettings) {
            return (AbstractMockApnsServerHandlerBuilder)super.initialSettings(initialSettings);
        }

        public AbstractMockApnsServerHandlerBuilder emulateInternalErrors(boolean emulateInternalErrors) {
            this.emulateInternalErrors = emulateInternalErrors;
            return this;
        }

        public boolean emulateInternalErrors() {
            return this.emulateInternalErrors;
        }

        public AbstractMockApnsServerHandlerBuilder deviceTokenExpirationsByTopic(Map<String, Map<String, Date>> deviceTokenExpirationsByTopic) {
            this.deviceTokenExpirationsByTopic = deviceTokenExpirationsByTopic;
            return this;
        }

        public Map<String, Map<String, Date>> deviceTokenExpirationsByTopic() {
            return this.deviceTokenExpirationsByTopic;
        }

        public AbstractMockApnsServerHandler build() {
            return (AbstractMockApnsServerHandler)super.build();
        }
    }

    static class RejectedNotificationException
    extends Exception {
        private final ErrorReason errorReason;
        private final Date deviceTokenExpirationTimestamp;

        public RejectedNotificationException(ErrorReason errorReason) {
            this(errorReason, null);
        }

        public RejectedNotificationException(ErrorReason errorReason, Date deviceTokenExpirationTimestamp) {
            Objects.requireNonNull(errorReason, "Error reason must not be null.");
            this.errorReason = errorReason;
            this.deviceTokenExpirationTimestamp = deviceTokenExpirationTimestamp;
        }

        public ErrorReason getErrorReason() {
            return this.errorReason;
        }

        public Date getDeviceTokenExpirationTimestamp() {
            return this.deviceTokenExpirationTimestamp;
        }
    }

    protected static enum ErrorReason {
        BAD_COLLAPSE_ID("BadCollapseId", HttpResponseStatus.BAD_REQUEST),
        BAD_DEVICE_TOKEN("BadDeviceToken", HttpResponseStatus.BAD_REQUEST),
        BAD_EXPIRATION_DATE("BadExpirationDate", HttpResponseStatus.BAD_REQUEST),
        BAD_MESSAGE_ID("BadMessageId", HttpResponseStatus.BAD_REQUEST),
        BAD_PRIORITY("BadPriority", HttpResponseStatus.BAD_REQUEST),
        BAD_TOPIC("BadTopic", HttpResponseStatus.BAD_REQUEST),
        DEVICE_TOKEN_NOT_FOR_TOPIC("DeviceTokenNotForTopic", HttpResponseStatus.BAD_REQUEST),
        DUPLICATE_HEADERS("DuplicateHeaders", HttpResponseStatus.BAD_REQUEST),
        IDLE_TIMEOUT("IdleTimeout", HttpResponseStatus.BAD_REQUEST),
        MISSING_DEVICE_TOKEN("MissingDeviceToken", HttpResponseStatus.BAD_REQUEST),
        MISSING_TOPIC("MissingTopic", HttpResponseStatus.BAD_REQUEST),
        PAYLOAD_EMPTY("PayloadEmpty", HttpResponseStatus.BAD_REQUEST),
        TOPIC_DISALLOWED("TopicDisallowed", HttpResponseStatus.BAD_REQUEST),
        BAD_CERTIFICATE("BadCertificate", HttpResponseStatus.FORBIDDEN),
        BAD_CERTIFICATE_ENVIRONMENT("BadCertificateEnvironment", HttpResponseStatus.FORBIDDEN),
        EXPIRED_PROVIDER_TOKEN("ExpiredProviderToken", HttpResponseStatus.FORBIDDEN),
        FORBIDDEN("Forbidden", HttpResponseStatus.FORBIDDEN),
        INVALID_PROVIDER_TOKEN("InvalidProviderToken", HttpResponseStatus.FORBIDDEN),
        MISSING_PROVIDER_TOKEN("MissingProviderToken", HttpResponseStatus.FORBIDDEN),
        BAD_PATH("BadPath", HttpResponseStatus.NOT_FOUND),
        METHOD_NOT_ALLOWED("MethodNotAllowed", HttpResponseStatus.METHOD_NOT_ALLOWED),
        UNREGISTERED("Unregistered", HttpResponseStatus.GONE),
        PAYLOAD_TOO_LARGE("PayloadTooLarge", HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE),
        TOO_MANY_PROVIDER_TOKEN_UPDATES("TooManyProviderTokenUpdates", HttpResponseStatus.TOO_MANY_REQUESTS),
        TOO_MANY_REQUESTS("TooManyRequests", HttpResponseStatus.TOO_MANY_REQUESTS),
        INTERNAL_SERVER_ERROR("InternalServerError", HttpResponseStatus.INTERNAL_SERVER_ERROR),
        SERVICE_UNAVAILABLE("ServiceUnavailable", HttpResponseStatus.SERVICE_UNAVAILABLE),
        SHUTDOWN("Shutdown", HttpResponseStatus.SERVICE_UNAVAILABLE);

        private final String reasonText;
        private final HttpResponseStatus httpResponseStatus;

        private ErrorReason(String reasonText, HttpResponseStatus httpResponseStatus) {
            this.reasonText = reasonText;
            this.httpResponseStatus = httpResponseStatus;
        }

        public String getReasonText() {
            return this.reasonText;
        }

        public HttpResponseStatus getHttpResponseStatus() {
            return this.httpResponseStatus;
        }
    }
}

