/*
 * Decompiled with CFR 0.152.
 */
package com.turo.pushy.apns.auth;

import com.turo.pushy.apns.auth.ApnsKey;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECPoint;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import org.apache.commons.codec.binary.Base64;

public class ApnsVerificationKey
extends ApnsKey
implements ECPublicKey {
    private static final long serialVersionUID = 1L;

    public ApnsVerificationKey(String keyId, String teamId, ECPublicKey key) throws NoSuchAlgorithmException, InvalidKeyException {
        super(keyId, teamId, key);
        Signature signature = Signature.getInstance("SHA256withECDSA");
        signature.initVerify(key);
    }

    @Override
    public ECPublicKey getKey() {
        return (ECPublicKey)super.getKey();
    }

    @Override
    public String getAlgorithm() {
        return this.getKey().getAlgorithm();
    }

    @Override
    public String getFormat() {
        return this.getKey().getFormat();
    }

    @Override
    public byte[] getEncoded() {
        return this.getKey().getEncoded();
    }

    @Override
    public ECPoint getW() {
        return this.getKey().getW();
    }

    public static ApnsVerificationKey loadFromPkcs8File(File pkcs8File, String teamId, String keyId) throws IOException, NoSuchAlgorithmException, InvalidKeyException {
        try (FileInputStream fileInputStream = new FileInputStream(pkcs8File);){
            ApnsVerificationKey apnsVerificationKey = ApnsVerificationKey.loadFromInputStream(fileInputStream, teamId, keyId);
            return apnsVerificationKey;
        }
    }

    public static ApnsVerificationKey loadFromInputStream(InputStream inputStream, String teamId, String keyId) throws IOException, NoSuchAlgorithmException, InvalidKeyException {
        ECPublicKey verificationKey;
        String line;
        StringBuilder publicKeyBuilder = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        boolean haveReadHeader = false;
        boolean haveReadFooter = false;
        while ((line = reader.readLine()) != null) {
            if (!haveReadHeader) {
                if (!line.contains("BEGIN PUBLIC KEY")) continue;
                haveReadHeader = true;
                continue;
            }
            if (line.contains("END PUBLIC KEY")) {
                haveReadFooter = true;
                break;
            }
            publicKeyBuilder.append(line);
        }
        if (!haveReadHeader || !haveReadFooter) {
            throw new IOException("Could not find public key header/footer");
        }
        String base64EncodedPublicKey = publicKeyBuilder.toString();
        byte[] keyBytes = Base64.decodeBase64((String)base64EncodedPublicKey);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("EC");
        try {
            verificationKey = (ECPublicKey)keyFactory.generatePublic(keySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new InvalidKeyException(e);
        }
        return new ApnsVerificationKey(keyId, teamId, verificationKey);
    }
}

