/*
 * Decompiled with CFR 0.152.
 */
package com.turo.pushy.apns;

import com.turo.pushy.apns.MockApnsServer;
import com.turo.pushy.apns.SslUtil;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.http2.Http2SecurityUtil;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import java.io.File;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockApnsServerBuilder {
    private X509Certificate[] certificateChain;
    private PrivateKey privateKey;
    private File certificateChainPemFile;
    private File privateKeyPkcs8File;
    private InputStream certificateChainInputStream;
    private InputStream privateKeyPkcs8InputStream;
    private String privateKeyPassword;
    private File trustedClientCertificatePemFile;
    private InputStream trustedClientCertificateInputStream;
    private X509Certificate[] trustedClientCertificates;
    private EventLoopGroup eventLoopGroup;
    private boolean emulateInternalErrors = false;
    private boolean emulateExpiredFirstToken = false;
    private static final Logger log = LoggerFactory.getLogger(MockApnsServerBuilder.class);

    public MockApnsServerBuilder setServerCredentials(File certificatePemFile, File privateKeyPkcs8File, String privateKeyPassword) {
        this.certificateChain = null;
        this.privateKey = null;
        this.certificateChainPemFile = certificatePemFile;
        this.privateKeyPkcs8File = privateKeyPkcs8File;
        this.certificateChainInputStream = null;
        this.privateKeyPkcs8InputStream = null;
        this.privateKeyPassword = privateKeyPassword;
        return this;
    }

    public MockApnsServerBuilder setServerCredentials(InputStream certificatePemInputStream, InputStream privateKeyPkcs8InputStream, String privateKeyPassword) {
        this.certificateChain = null;
        this.privateKey = null;
        this.certificateChainPemFile = null;
        this.privateKeyPkcs8File = null;
        this.certificateChainInputStream = certificatePemInputStream;
        this.privateKeyPkcs8InputStream = privateKeyPkcs8InputStream;
        this.privateKeyPassword = privateKeyPassword;
        return this;
    }

    public MockApnsServerBuilder setServerCredentials(X509Certificate[] certificates, PrivateKey privateKey, String privateKeyPassword) {
        this.certificateChain = certificates;
        this.privateKey = privateKey;
        this.certificateChainPemFile = null;
        this.privateKeyPkcs8File = null;
        this.certificateChainInputStream = null;
        this.privateKeyPkcs8InputStream = null;
        this.privateKeyPassword = privateKeyPassword;
        return this;
    }

    public MockApnsServerBuilder setTrustedClientCertificateChain(File certificatePemFile) {
        this.trustedClientCertificatePemFile = certificatePemFile;
        this.trustedClientCertificateInputStream = null;
        this.trustedClientCertificates = null;
        return this;
    }

    public MockApnsServerBuilder setTrustedClientCertificateChain(InputStream certificateInputStream) {
        this.trustedClientCertificatePemFile = null;
        this.trustedClientCertificateInputStream = certificateInputStream;
        this.trustedClientCertificates = null;
        return this;
    }

    public MockApnsServerBuilder setTrustedServerCertificateChain(X509Certificate ... certificates) {
        this.trustedClientCertificatePemFile = null;
        this.trustedClientCertificateInputStream = null;
        this.trustedClientCertificates = certificates;
        return this;
    }

    public MockApnsServerBuilder setEventLoopGroup(EventLoopGroup eventLoopGroup) {
        this.eventLoopGroup = eventLoopGroup;
        return this;
    }

    public MockApnsServerBuilder setEmulateInternalErrors(boolean emulateInternalErrors) {
        this.emulateInternalErrors = emulateInternalErrors;
        return this;
    }

    public MockApnsServerBuilder setEmulateExpiredFirstToken(boolean emulateExpiredFirstToken) {
        this.emulateExpiredFirstToken = emulateExpiredFirstToken;
        return this;
    }

    public MockApnsServer build() throws SSLException {
        SslContextBuilder sslContextBuilder;
        SslProvider sslProvider = SslUtil.getSslProvider();
        if (this.certificateChain != null && this.privateKey != null) {
            sslContextBuilder = SslContextBuilder.forServer((PrivateKey)this.privateKey, (String)this.privateKeyPassword, (X509Certificate[])this.certificateChain);
        } else if (this.certificateChainPemFile != null && this.privateKeyPkcs8File != null) {
            sslContextBuilder = SslContextBuilder.forServer((File)this.certificateChainPemFile, (File)this.privateKeyPkcs8File, (String)this.privateKeyPassword);
        } else if (this.certificateChainInputStream != null && this.privateKeyPkcs8InputStream != null) {
            sslContextBuilder = SslContextBuilder.forServer((InputStream)this.certificateChainInputStream, (InputStream)this.privateKeyPkcs8InputStream, (String)this.privateKeyPassword);
        } else {
            throw new IllegalStateException("Must specify server credentials before building a mock server.");
        }
        sslContextBuilder.sslProvider(sslProvider).ciphers((Iterable)Http2SecurityUtil.CIPHERS, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE).clientAuth(ClientAuth.OPTIONAL).applicationProtocolConfig(new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"h2"}));
        if (this.trustedClientCertificatePemFile != null) {
            sslContextBuilder.trustManager(this.trustedClientCertificatePemFile);
        } else if (this.trustedClientCertificateInputStream != null) {
            sslContextBuilder.trustManager(this.trustedClientCertificateInputStream);
        } else if (this.trustedClientCertificates != null) {
            sslContextBuilder.trustManager(this.trustedClientCertificates);
        }
        SslContext sslContext = sslContextBuilder.build();
        MockApnsServer server = new MockApnsServer(sslContext, this.eventLoopGroup);
        server.setEmulateInternalErrors(this.emulateInternalErrors);
        server.setEmulateExpiredFirstToken(this.emulateExpiredFirstToken);
        return server;
    }
}

