/*
 * Decompiled with CFR 0.152.
 */
package com.tunjid.androidbootstrap.view.util;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import androidx.annotation.LayoutRes;

public class ViewUtil {
    public static View getItemView(@LayoutRes int res, ViewGroup parent) {
        return LayoutInflater.from((Context)parent.getContext()).inflate(res, parent, false);
    }

    public static ViewGroup.MarginLayoutParams getLayoutParams(View view) {
        return (ViewGroup.MarginLayoutParams)view.getLayoutParams();
    }

    public static String transitionName(Object object, View view) {
        return object.hashCode() + "-" + view.getId();
    }

    public static void listenForLayout(final View view, final Runnable onLayout) {
        final ViewTreeObserver observer = view.getViewTreeObserver();
        if (!observer.isAlive()) {
            return;
        }
        observer.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                ViewTreeObserver current;
                if (observer.isAlive()) {
                    observer.removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                if ((current = view.getViewTreeObserver()).isAlive()) {
                    current.removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                onLayout.run();
            }
        });
    }
}

