/*
 * Decompiled with CFR 0.152.
 */
package com.trustdecision.liveness.cw.st.widget.finder.childs;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Point;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.LinearInterpolator;

public class DotCircularProgressView
extends View {
    private final int DURATION = 500;
    private final Paint mSelectedPaint = new Paint();
    private final Paint mPaint = new Paint();
    private final int mColor = 0x979797;
    private final int mAlpha = 63;
    private final int mSelectedColor = 0x979797;
    private final int mSelectedAlpha = 255;
    private final int mDotRadius = 6;
    private final int mSelectDotRadius = 10;
    private final float mRadiusChangeRate = 0.5f;
    private int mCurrentProgress = 0;
    private int mAnimatorProgress = 0;
    private final TimeInterpolator timeInterpolator = new LinearInterpolator();
    private static final int DOT_COUNT = 90;
    private static final int TRANSITION_DOT_COUNT = 5;
    private static ValueAnimator animator;

    public DotCircularProgressView(Context context) {
        super(context);
        this.init();
    }

    public DotCircularProgressView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init();
    }

    public DotCircularProgressView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.init();
    }

    private void init() {
        this.mSelectedPaint.setColor(0x979797);
        this.mSelectedPaint.setAntiAlias(true);
        this.mSelectedPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setColor(0x979797);
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStyle(Paint.Style.FILL);
    }

    public void setProgress(int n) {
        this.setProgress(n, null);
    }

    public void setProgress(int n, OnProgressAnimatorListener onProgressAnimatorListener) {
        this.startAnimator(n, onProgressAnimatorListener);
    }

    private void startAnimator(int n, final OnProgressAnimatorListener onProgressAnimatorListener) {
        if (animator != null && animator.isRunning()) {
            animator.cancel();
        }
        animator = ValueAnimator.ofInt((int[])new int[]{this.mCurrentProgress, n}).setDuration(500L);
        this.mCurrentProgress = n;
        animator.setInterpolator(this.timeInterpolator);
        animator.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animator) {
            }

            public void onAnimationEnd(Animator animator) {
                if (onProgressAnimatorListener != null) {
                    onProgressAnimatorListener.onAnimatorEnd();
                }
            }

            public void onAnimationCancel(Animator animator) {
            }

            public void onAnimationRepeat(Animator animator) {
            }
        });
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                DotCircularProgressView.this.mAnimatorProgress = (Integer)valueAnimator.getAnimatedValue();
                DotCircularProgressView.this.invalidate();
            }
        });
        animator.start();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.mPaint.setAlpha(255);
        this.mSelectedPaint.setAlpha(255);
        int n = 90;
        int n2 = (int)((double)this.mAnimatorProgress / 100.0 * (double)n);
        int n3 = (Math.min(this.getWidth(), this.getHeight()) - 20) / 2;
        Point point = new Point(this.getWidth() / 2, this.getHeight() / 2);
        int n4 = 360 / n;
        for (int i2 = 0; i2 < n; ++i2) {
            int n5 = (int)((double)point.x + (double)n3 * Math.cos((double)(i2 * n4 - 90) * Math.PI / 180.0));
            int n6 = (int)((double)point.y + (double)n3 * Math.sin((double)(i2 * n4 - 90) * Math.PI / 180.0));
            if (n2 != 0) {
                if (n2 >= n) {
                    this.mSelectedPaint.setAlpha(255);
                    canvas.drawCircle((float)n5, (float)n6, 6.0f, this.mSelectedPaint);
                    continue;
                }
                if (i2 < n2) {
                    this.mSelectedPaint.setAlpha(255);
                    canvas.drawCircle((float)n5, (float)n6, 6.0f, this.mSelectedPaint);
                    continue;
                }
                if (i2 == n2) {
                    this.mSelectedPaint.setAlpha(255);
                    canvas.drawCircle((float)n5, (float)n6, 10.0f, this.mSelectedPaint);
                    continue;
                }
                this.mPaint.setAlpha(63);
                canvas.drawCircle((float)n5, (float)n6, 6.0f, this.mPaint);
                continue;
            }
            this.mPaint.setAlpha(63);
            canvas.drawCircle((float)n5, (float)n6, 6.0f, this.mPaint);
        }
    }

    public static interface OnProgressAnimatorListener {
        public void onAnimatorEnd();
    }
}

