/*
 * Decompiled with CFR 0.152.
 */
package com.trustdecision.liveness.cw.st.widget.camera;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.RSRuntimeException;
import android.renderscript.RenderScript;
import android.renderscript.ScriptIntrinsicBlur;
import android.renderscript.Type;
import android.util.AttributeSet;
import android.util.Base64;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import com.trustdecision.liveness.cw.st.widget.camera.SenseCamera;
import java.io.IOException;

public class SenseCameraPreview
extends ViewGroup {
    private final String TAG = SenseCameraPreview.i1i1iI1I11iI("ICsgPSswLyMrPBIePCs4Gis5");
    public Rect scaledRect = null;
    private Context mContext;
    private SurfaceView mSurfaceView;
    private boolean mStartRequested;
    private boolean mSurfaceAvailable;
    private SenseCamera mCamera;

    public SenseCameraPreview(Context context) {
        super(context);
        this.mContext = context;
        this.mStartRequested = false;
        this.mSurfaceAvailable = false;
        this.mSurfaceView = new SurfaceView(context);
        this.mSurfaceView.getHolder().addCallback((SurfaceHolder.Callback)new SurfaceCallback());
        this.addView((View)this.mSurfaceView);
    }

    public SenseCameraPreview(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mContext = context;
        this.mStartRequested = false;
        this.mSurfaceAvailable = false;
        this.mSurfaceView = new SurfaceView(context);
        this.mSurfaceView.getHolder().addCallback((SurfaceHolder.Callback)new SurfaceCallback());
        this.addView((View)this.mSurfaceView);
    }

    public void start(SenseCamera senseCamera) throws IOException, RuntimeException {
        if (senseCamera == null) {
            this.stop();
        }
        this.mCamera = senseCamera;
        if (this.mCamera != null) {
            this.mStartRequested = true;
            this.startIfReady();
        }
    }

    public void stop() {
        if (this.mCamera != null) {
            this.mCamera.stop();
        }
    }

    public void release() {
        if (this.mCamera != null) {
            this.mCamera.release();
            this.mCamera = null;
        }
    }

    private void startIfReady() throws IOException, RuntimeException {
        if (this.mStartRequested && this.mSurfaceAvailable) {
            this.mCamera.start(this.mSurfaceView.getHolder());
            this.requestLayout();
            this.mStartRequested = false;
        }
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        SenseCamera.Size size;
        if (this.mCamera != null && (size = this.mCamera.getPreviewSize()) != null) {
            int n5;
            int n6;
            float f2;
            int n7;
            float f3;
            int n8;
            int n9 = size.getWidth();
            int n10 = size.getHeight();
            if (this.isPortraitMode()) {
                n8 = n9;
                n9 = n10;
                n10 = n8;
            }
            if (Float.compare(f3 = (float)(n8 = n3 - n) / (float)(n7 = n4 - n2), f2 = (float)n9 / (float)n10) <= 0) {
                n6 = (int)((float)n7 * f2);
                n5 = n7;
            } else {
                n6 = n8;
                n5 = (int)((float)n8 / f2);
            }
            int n11 = (n8 - n6) / 2;
            int n12 = (n7 - n5) / 2;
            for (int i2 = 0; i2 < this.getChildCount(); ++i2) {
                this.getChildAt(i2).layout(n11, n12, n6 + n11, n5 + n12);
            }
            try {
                this.startIfReady();
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public Rect convertViewRectToCameraPreview(Rect rect) {
        int n;
        int n2;
        float f2;
        int n3;
        float f3;
        int n4;
        int n5 = this.mCamera.getRotationDegrees();
        SenseCamera.Size size = this.mCamera.getPreviewSize();
        int n6 = size.getWidth();
        int n7 = size.getHeight();
        if (this.isPortraitMode()) {
            n4 = n6;
            n6 = n7;
            n7 = n4;
        }
        if (Float.compare(f3 = (float)(n4 = this.getWidth()) / (float)(n3 = this.getHeight()), f2 = (float)n6 / (float)n7) <= 0) {
            n2 = (int)((float)n3 * f2);
            n = n3;
        } else {
            n2 = n4;
            n = (int)((float)n4 / f2);
        }
        int n8 = (n4 - n2) / 2;
        int n9 = (n3 - n) / 2;
        float f4 = (float)n6 / (float)n2;
        float f5 = (float)n7 / (float)n;
        float f6 = (float)(rect.left + Math.abs(n8)) * f4;
        float f7 = (float)(rect.top + Math.abs(n9)) * f5;
        return new Rect((int)f6, (int)f7, (int)(f6 + (float)rect.width() * f4), (int)(f7 + (float)rect.height() * f5));
    }

    private boolean isPortraitMode() {
        int n = this.mContext.getResources().getConfiguration().orientation;
        return n != 2 && n == 1;
    }

    public Bitmap getCameraDrawingCache(boolean bl) {
        Bitmap bitmap = this.mCamera.getDrawingCache();
        if (bitmap == null) {
            return null;
        }
        if (bl) {
            return SenseCameraPreview.blur(bitmap, 30, true);
        }
        return bitmap;
    }

    public static Bitmap blur(Bitmap bitmap, int n, boolean bl) {
        int n2;
        int n3;
        int n4;
        int n5;
        int[] nArray;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        Bitmap bitmap2 = bl ? bitmap : bitmap.copy(bitmap.getConfig(), true);
        if (n < 1) {
            return null;
        }
        int n18 = bitmap2.getWidth();
        int n19 = bitmap2.getHeight();
        int[] nArray2 = new int[n18 * n19];
        bitmap2.getPixels(nArray2, 0, n18, 0, 0, n18, n19);
        int n20 = n18 - 1;
        int n21 = n19 - 1;
        int n22 = n18 * n19;
        int n23 = n + n + 1;
        int[] nArray3 = new int[n22];
        int[] nArray4 = new int[n22];
        int[] nArray5 = new int[n22];
        int[] nArray6 = new int[Math.max(n18, n19)];
        int n24 = n23 + 1 >> 1;
        n24 *= n24;
        int[] nArray7 = new int[256 * n24];
        for (n17 = 0; n17 < 256 * n24; ++n17) {
            nArray7[n17] = n17 / n24;
        }
        int n25 = 0;
        int n26 = 0;
        int[][] nArray8 = new int[n23][3];
        int n27 = n + 1;
        for (n16 = 0; n16 < n19; ++n16) {
            n15 = 0;
            n14 = 0;
            n13 = 0;
            n12 = 0;
            n11 = 0;
            n10 = 0;
            n9 = 0;
            n8 = 0;
            n7 = 0;
            for (n17 = -n; n17 <= n; ++n17) {
                n6 = nArray2[n25 + Math.min(n20, Math.max(n17, 0))];
                nArray = nArray8[n17 + n];
                nArray[0] = (n6 & 0xFF0000) >> 16;
                nArray[1] = (n6 & 0xFF00) >> 8;
                nArray[2] = n6 & 0xFF;
                n5 = n27 - Math.abs(n17);
                n13 += nArray[0] * n5;
                n14 += nArray[1] * n5;
                n15 += nArray[2] * n5;
                if (n17 > 0) {
                    n7 += nArray[0];
                    n8 += nArray[1];
                    n9 += nArray[2];
                    continue;
                }
                n10 += nArray[0];
                n11 += nArray[1];
                n12 += nArray[2];
            }
            n4 = n;
            for (n3 = 0; n3 < n18; ++n3) {
                nArray3[n25] = nArray7[n13];
                nArray4[n25] = nArray7[n14];
                nArray5[n25] = nArray7[n15];
                n13 -= n10;
                n14 -= n11;
                n15 -= n12;
                n2 = n4 - n + n23;
                nArray = nArray8[n2 % n23];
                n10 -= nArray[0];
                n11 -= nArray[1];
                n12 -= nArray[2];
                if (n16 == 0) {
                    nArray6[n3] = Math.min(n3 + n + 1, n20);
                }
                n6 = nArray2[n26 + nArray6[n3]];
                nArray[0] = (n6 & 0xFF0000) >> 16;
                nArray[1] = (n6 & 0xFF00) >> 8;
                nArray[2] = n6 & 0xFF;
                n13 += (n7 += nArray[0]);
                n14 += (n8 += nArray[1]);
                n15 += (n9 += nArray[2]);
                n4 = (n4 + 1) % n23;
                nArray = nArray8[n4 % n23];
                n10 += nArray[0];
                n11 += nArray[1];
                n12 += nArray[2];
                n7 -= nArray[0];
                n8 -= nArray[1];
                n9 -= nArray[2];
                ++n25;
            }
            n26 += n18;
        }
        for (n3 = 0; n3 < n18; ++n3) {
            n15 = 0;
            n14 = 0;
            n13 = 0;
            n12 = 0;
            n11 = 0;
            n10 = 0;
            n9 = 0;
            n8 = 0;
            n7 = 0;
            int n28 = -n * n18;
            for (n17 = -n; n17 <= n; ++n17) {
                n25 = Math.max(0, n28) + n3;
                nArray = nArray8[n17 + n];
                nArray[0] = nArray3[n25];
                nArray[1] = nArray4[n25];
                nArray[2] = nArray5[n25];
                n5 = n27 - Math.abs(n17);
                n13 += nArray3[n25] * n5;
                n14 += nArray4[n25] * n5;
                n15 += nArray5[n25] * n5;
                if (n17 > 0) {
                    n7 += nArray[0];
                    n8 += nArray[1];
                    n9 += nArray[2];
                } else {
                    n10 += nArray[0];
                    n11 += nArray[1];
                    n12 += nArray[2];
                }
                if (n17 >= n21) continue;
                n28 += n18;
            }
            n25 = n3;
            n4 = n;
            for (n16 = 0; n16 < n19; ++n16) {
                nArray2[n25] = 0xFF000000 & nArray2[n25] | nArray7[n13] << 16 | nArray7[n14] << 8 | nArray7[n15];
                n13 -= n10;
                n14 -= n11;
                n15 -= n12;
                n2 = n4 - n + n23;
                nArray = nArray8[n2 % n23];
                n10 -= nArray[0];
                n11 -= nArray[1];
                n12 -= nArray[2];
                if (n3 == 0) {
                    nArray6[n16] = Math.min(n16 + n27, n21) * n18;
                }
                n6 = n3 + nArray6[n16];
                nArray[0] = nArray3[n6];
                nArray[1] = nArray4[n6];
                nArray[2] = nArray5[n6];
                n13 += (n7 += nArray[0]);
                n14 += (n8 += nArray[1]);
                n15 += (n9 += nArray[2]);
                n4 = (n4 + 1) % n23;
                nArray = nArray8[n4];
                n10 += nArray[0];
                n11 += nArray[1];
                n12 += nArray[2];
                n7 -= nArray[0];
                n8 -= nArray[1];
                n9 -= nArray[2];
                n25 += n18;
            }
        }
        bitmap2.setPixels(nArray2, 0, n18, 0, 0, n18, n19);
        return bitmap2;
    }

    private static String linkxxxxx(String string2, int n) {
        try {
            int n2;
            int n3;
            int n4 = string2.length() / 2;
            char[] cArray = string2.toCharArray();
            byte[] byArray = new byte[n4];
            for (n3 = 0; n3 < n4; ++n3) {
                n2 = n3 * 2;
                byArray[n3] = (byte)("0123456789abcdef".indexOf(cArray[n2]) << 4 | "0123456789abcdef".indexOf(cArray[n2 + 1]));
            }
            n3 = (byte)(n ^ 0x7D);
            n2 = byArray.length;
            byArray[0] = (byte)(byArray[0] ^ 0x66);
            byte by = byArray[0];
            for (int i2 = 1; i2 < n2; ++i2) {
                byte by2 = byArray[i2];
                byArray[i2] = (byte)(byArray[i2] ^ by ^ n3);
                by = by2;
            }
            return new String(byArray, "utf-8");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static String i1i1iI1I11iI(String string2) {
        try {
            byte[] byArray = Base64.decode((String)string2, (int)0);
            int n = byArray.length;
            byte[] byArray2 = "sNNNN".getBytes();
            int n2 = byArray2.length;
            for (int i2 = 0; i2 < n; ++i2) {
                byArray[i2] = (byte)(byArray[i2] ^ byArray2[i2 % n2]);
            }
            return new String(byArray, "utf-8");
        }
        catch (Exception exception) {
            return null;
        }
    }

    private class SurfaceCallback
    implements SurfaceHolder.Callback {
        private SurfaceCallback() {
        }

        public void surfaceCreated(SurfaceHolder surfaceHolder) {
            SenseCameraPreview.this.mSurfaceAvailable = true;
            try {
                SenseCameraPreview.this.startIfReady();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
            SenseCameraPreview.this.mSurfaceAvailable = false;
        }

        public void surfaceChanged(SurfaceHolder surfaceHolder, int n, int n2, int n3) {
        }
    }

    private static class RSBlur {
        private static RSBlur sInstance;
        private RenderScript renderScript;

        @TargetApi(value=17)
        public static RSBlur getInstance(Context context) {
            if (sInstance == null) {
                sInstance = new RSBlur(context);
            }
            return sInstance;
        }

        private RSBlur(Context context) {
            this.renderScript = RenderScript.create((Context)context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @TargetApi(value=17)
        public Bitmap blur(Bitmap bitmap, int n) throws RSRuntimeException {
            Allocation allocation = null;
            Allocation allocation2 = null;
            ScriptIntrinsicBlur scriptIntrinsicBlur = null;
            try {
                allocation = Allocation.createFromBitmap((RenderScript)this.renderScript, (Bitmap)bitmap, (Allocation.MipmapControl)Allocation.MipmapControl.MIPMAP_NONE, (int)1);
                allocation2 = Allocation.createTyped((RenderScript)this.renderScript, (Type)allocation.getType());
                scriptIntrinsicBlur = ScriptIntrinsicBlur.create((RenderScript)this.renderScript, (Element)Element.U8_4((RenderScript)this.renderScript));
                scriptIntrinsicBlur.setInput(allocation);
                scriptIntrinsicBlur.setRadius((float)n);
                scriptIntrinsicBlur.forEach(allocation2);
                allocation2.copyTo(bitmap);
            }
            finally {
                if (allocation != null) {
                    allocation.destroy();
                }
                if (allocation2 != null) {
                    allocation2.destroy();
                }
                if (scriptIntrinsicBlur != null) {
                    scriptIntrinsicBlur.destroy();
                }
            }
            return bitmap;
        }
    }
}

