/*
 * Decompiled with CFR 0.152.
 */
package com.triposo.barone;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.text.Layout;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.StaticLayout;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EllipsizingTextView
extends TextView {
    private static final String ELLIPSIS = "\u2026";
    private static final Pattern DEFAULT_END_PUNCTUATION = Pattern.compile("[\\.,\u2026;\\:\\s]*$", 32);
    private final List<EllipsizeListener> ellipsizeListeners = new ArrayList<EllipsizeListener>();
    private boolean isEllipsized;
    private boolean isStale;
    private boolean programmaticChange;
    private CharSequence fullText;
    private int maxLines;
    private float lineSpacingMultiplier = 1.0f;
    private float lineAdditionalVerticalPadding = 0.0f;
    private Pattern endPunctuationPattern;

    public EllipsizingTextView(Context context) {
        this(context, null);
    }

    public EllipsizingTextView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public EllipsizingTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        super.setEllipsize(null);
        TypedArray a = context.obtainStyledAttributes(attrs, new int[]{16843091});
        this.setMaxLines(a.getInt(0, Integer.MAX_VALUE));
        a.recycle();
        this.setEndPunctuationPattern(DEFAULT_END_PUNCTUATION);
    }

    public void setEndPunctuationPattern(Pattern pattern) {
        this.endPunctuationPattern = pattern;
    }

    public void addEllipsizeListener(EllipsizeListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.ellipsizeListeners.add(listener);
    }

    public void removeEllipsizeListener(EllipsizeListener listener) {
        this.ellipsizeListeners.remove(listener);
    }

    public boolean isEllipsized() {
        return this.isEllipsized;
    }

    public void setMaxLines(int maxLines) {
        super.setMaxLines(maxLines);
        this.maxLines = maxLines;
        this.isStale = true;
    }

    @SuppressLint(value={"Override"})
    public int getMaxLines() {
        return this.maxLines;
    }

    public boolean ellipsizingLastFullyVisibleLine() {
        return this.maxLines == Integer.MAX_VALUE;
    }

    public void setLineSpacing(float add, float mult) {
        this.lineAdditionalVerticalPadding = add;
        this.lineSpacingMultiplier = mult;
        super.setLineSpacing(add, mult);
    }

    protected void onTextChanged(CharSequence text, int start, int before, int after) {
        super.onTextChanged(text, start, before, after);
        if (!this.programmaticChange) {
            this.fullText = text;
            this.isStale = true;
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (this.ellipsizingLastFullyVisibleLine()) {
            this.isStale = true;
        }
    }

    public void setPadding(int left, int top, int right, int bottom) {
        super.setPadding(left, top, right, bottom);
        if (this.ellipsizingLastFullyVisibleLine()) {
            this.isStale = true;
        }
    }

    protected void onDraw(Canvas canvas) {
        if (this.isStale) {
            this.resetText();
        }
        super.onDraw(canvas);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetText() {
        CharSequence workingText = this.fullText;
        boolean ellipsized = false;
        Layout layout = this.createWorkingLayout(workingText);
        int linesCount = this.getLinesCount();
        if (layout.getLineCount() > linesCount) {
            int lastSpace;
            workingText = this.fullText.subSequence(0, layout.getLineEnd(linesCount - 1));
            while (this.createWorkingLayout(workingText + ELLIPSIS).getLineCount() > linesCount && (lastSpace = workingText.toString().lastIndexOf(32)) != -1) {
                workingText = workingText.subSequence(0, lastSpace);
            }
            if (workingText instanceof Spannable) {
                SpannableStringBuilder builder = new SpannableStringBuilder(workingText);
                Matcher matcher = this.endPunctuationPattern.matcher(workingText);
                if (matcher.find()) {
                    builder.replace(matcher.start(), workingText.length(), (CharSequence)ELLIPSIS);
                }
                workingText = builder;
            } else {
                workingText = this.endPunctuationPattern.matcher(workingText).replaceFirst("");
                workingText = workingText + ELLIPSIS;
            }
            ellipsized = true;
        }
        if (!workingText.equals(this.getText())) {
            this.programmaticChange = true;
            try {
                this.setText(workingText);
            }
            finally {
                this.programmaticChange = false;
            }
        }
        this.isStale = false;
        if (ellipsized != this.isEllipsized) {
            this.isEllipsized = ellipsized;
            for (EllipsizeListener listener : this.ellipsizeListeners) {
                listener.ellipsizeStateChanged(ellipsized);
            }
        }
    }

    private int getLinesCount() {
        if (this.ellipsizingLastFullyVisibleLine()) {
            int fullyVisibleLinesCount = this.getFullyVisibleLinesCount();
            if (fullyVisibleLinesCount == -1) {
                return 1;
            }
            return fullyVisibleLinesCount;
        }
        return this.maxLines;
    }

    private int getFullyVisibleLinesCount() {
        Layout layout = this.createWorkingLayout("");
        int height = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
        int lineHeight = layout.getLineBottom(0);
        return height / lineHeight;
    }

    private Layout createWorkingLayout(CharSequence workingText) {
        return new StaticLayout(workingText, this.getPaint(), this.getWidth() - this.getPaddingLeft() - this.getPaddingRight(), Layout.Alignment.ALIGN_NORMAL, this.lineSpacingMultiplier, this.lineAdditionalVerticalPadding, false);
    }

    public void setEllipsize(TextUtils.TruncateAt where) {
    }

    public static interface EllipsizeListener {
        public void ellipsizeStateChanged(boolean var1);
    }
}

