/*
 * Decompiled with CFR 0.152.
 */
package com.trello.rxlifecycle;

import com.trello.rxlifecycle.LifecycleTransformer;
import com.trello.rxlifecycle.TakeUntilGenerator;
import com.trello.rxlifecycle.UntilCorrespondingEventCompletableTransformer;
import com.trello.rxlifecycle.UntilCorrespondingEventSingleTransformer;
import javax.annotation.Nonnull;
import rx.Completable;
import rx.Observable;
import rx.Single;
import rx.functions.Func1;

final class UntilCorrespondingEventObservableTransformer<T, R>
implements LifecycleTransformer<T> {
    final Observable<R> sharedLifecycle;
    final Func1<R, R> correspondingEvents;

    public UntilCorrespondingEventObservableTransformer(@Nonnull Observable<R> sharedLifecycle, @Nonnull Func1<R, R> correspondingEvents) {
        this.sharedLifecycle = sharedLifecycle;
        this.correspondingEvents = correspondingEvents;
    }

    public Observable<T> call(Observable<T> source) {
        return source.takeUntil(TakeUntilGenerator.takeUntilCorrespondingEvent(this.sharedLifecycle, this.correspondingEvents));
    }

    @Override
    @Nonnull
    public Single.Transformer<T, T> forSingle() {
        return new UntilCorrespondingEventSingleTransformer(this.sharedLifecycle, this.correspondingEvents);
    }

    @Override
    @Nonnull
    public Completable.CompletableTransformer forCompletable() {
        return new UntilCorrespondingEventCompletableTransformer<R>(this.sharedLifecycle, this.correspondingEvents);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UntilCorrespondingEventObservableTransformer that = (UntilCorrespondingEventObservableTransformer)o;
        if (!this.sharedLifecycle.equals(that.sharedLifecycle)) {
            return false;
        }
        return this.correspondingEvents.equals(that.correspondingEvents);
    }

    public int hashCode() {
        int result = this.sharedLifecycle.hashCode();
        result = 31 * result + this.correspondingEvents.hashCode();
        return result;
    }

    public String toString() {
        return "UntilCorrespondingEventObservableTransformer{sharedLifecycle=" + this.sharedLifecycle + ", correspondingEvents=" + this.correspondingEvents + '}';
    }
}

