/*
 * Decompiled with CFR 0.152.
 */
package com.trello.rxlifecycle;

import android.support.annotation.CheckResult;
import android.support.annotation.NonNull;
import android.view.View;
import com.jakewharton.rxbinding.view.RxView;
import com.trello.rxlifecycle.ActivityEvent;
import com.trello.rxlifecycle.FragmentEvent;
import com.trello.rxlifecycle.OutsideLifecycleException;
import com.trello.rxlifecycle.internal.Preconditions;
import rx.Observable;
import rx.exceptions.Exceptions;
import rx.functions.Func1;
import rx.functions.Func2;

public class RxLifecycle {
    private static final Func1<Throwable, Boolean> RESUME_FUNCTION = new Func1<Throwable, Boolean>(){

        public Boolean call(Throwable throwable) {
            if (throwable instanceof OutsideLifecycleException) {
                return true;
            }
            Exceptions.propagate((Throwable)throwable);
            return false;
        }
    };
    private static final Func1<Boolean, Boolean> SHOULD_COMPLETE = new Func1<Boolean, Boolean>(){

        public Boolean call(Boolean shouldComplete) {
            return shouldComplete;
        }
    };
    private static final Func1<ActivityEvent, ActivityEvent> ACTIVITY_LIFECYCLE = new Func1<ActivityEvent, ActivityEvent>(){

        public ActivityEvent call(ActivityEvent lastEvent) {
            switch (lastEvent) {
                case CREATE: {
                    return ActivityEvent.DESTROY;
                }
                case START: {
                    return ActivityEvent.STOP;
                }
                case RESUME: {
                    return ActivityEvent.PAUSE;
                }
                case PAUSE: {
                    return ActivityEvent.STOP;
                }
                case STOP: {
                    return ActivityEvent.DESTROY;
                }
                case DESTROY: {
                    throw new OutsideLifecycleException("Cannot bind to Activity lifecycle when outside of it.");
                }
            }
            throw new UnsupportedOperationException("Binding to " + (Object)((Object)lastEvent) + " not yet implemented");
        }
    };
    private static final Func1<FragmentEvent, FragmentEvent> FRAGMENT_LIFECYCLE = new Func1<FragmentEvent, FragmentEvent>(){

        public FragmentEvent call(FragmentEvent lastEvent) {
            switch (lastEvent) {
                case ATTACH: {
                    return FragmentEvent.DETACH;
                }
                case CREATE: {
                    return FragmentEvent.DESTROY;
                }
                case CREATE_VIEW: {
                    return FragmentEvent.DESTROY_VIEW;
                }
                case START: {
                    return FragmentEvent.STOP;
                }
                case RESUME: {
                    return FragmentEvent.PAUSE;
                }
                case PAUSE: {
                    return FragmentEvent.STOP;
                }
                case STOP: {
                    return FragmentEvent.DESTROY_VIEW;
                }
                case DESTROY_VIEW: {
                    return FragmentEvent.DESTROY;
                }
                case DESTROY: {
                    return FragmentEvent.DETACH;
                }
                case DETACH: {
                    throw new OutsideLifecycleException("Cannot bind to Fragment lifecycle when outside of it.");
                }
            }
            throw new UnsupportedOperationException("Binding to " + (Object)((Object)lastEvent) + " not yet implemented");
        }
    };

    private RxLifecycle() {
        throw new AssertionError((Object)"No instances");
    }

    @Deprecated
    @NonNull
    @CheckResult
    public static <T> Observable.Transformer<T, T> bindUntilFragmentEvent(@NonNull Observable<FragmentEvent> lifecycle, @NonNull FragmentEvent event) {
        return RxLifecycle.bindUntilEvent(lifecycle, event);
    }

    @Deprecated
    @NonNull
    @CheckResult
    public static <T> Observable.Transformer<T, T> bindUntilActivityEvent(@NonNull Observable<ActivityEvent> lifecycle, @NonNull ActivityEvent event) {
        return RxLifecycle.bindUntilEvent(lifecycle, event);
    }

    @NonNull
    @CheckResult
    public static <T, R> Observable.Transformer<T, T> bindUntilEvent(final @NonNull Observable<R> lifecycle, final @NonNull R event) {
        Preconditions.checkNotNull(lifecycle, "lifecycle == null");
        Preconditions.checkNotNull(event, "event == null");
        return new Observable.Transformer<T, T>(){

            public Observable<T> call(Observable<T> source) {
                return source.takeUntil(lifecycle.takeFirst(new Func1<R, Boolean>(){

                    public Boolean call(R lifecycleEvent) {
                        return lifecycleEvent.equals(event);
                    }
                }));
            }
        };
    }

    @NonNull
    @CheckResult
    public static <T> Observable.Transformer<T, T> bindActivity(@NonNull Observable<ActivityEvent> lifecycle) {
        return RxLifecycle.bind(lifecycle, ACTIVITY_LIFECYCLE);
    }

    @NonNull
    @CheckResult
    public static <T> Observable.Transformer<T, T> bindFragment(@NonNull Observable<FragmentEvent> lifecycle) {
        return RxLifecycle.bind(lifecycle, FRAGMENT_LIFECYCLE);
    }

    @NonNull
    @CheckResult
    public static <T> Observable.Transformer<T, T> bindView(@NonNull View view) {
        Preconditions.checkNotNull(view, "view == null");
        return RxLifecycle.bind(RxView.detaches((View)view));
    }

    @Deprecated
    @NonNull
    @CheckResult
    public static <T, E> Observable.Transformer<T, T> bindView(@NonNull Observable<? extends E> lifecycle) {
        return RxLifecycle.bind(lifecycle);
    }

    @NonNull
    @CheckResult
    public static <T, R> Observable.Transformer<T, T> bind(final @NonNull Observable<R> lifecycle) {
        Preconditions.checkNotNull(lifecycle, "lifecycle == null");
        return new Observable.Transformer<T, T>(){

            public Observable<T> call(Observable<T> source) {
                return source.takeUntil(lifecycle);
            }
        };
    }

    @NonNull
    @CheckResult
    public static <T, R> Observable.Transformer<T, T> bind(@NonNull Observable<R> lifecycle, final @NonNull Func1<R, R> correspondingEvents) {
        Preconditions.checkNotNull(lifecycle, "lifecycle == null");
        Preconditions.checkNotNull(correspondingEvents, "correspondingEvents == null");
        final Observable sharedLifecycle = lifecycle.share();
        return new Observable.Transformer<T, T>(){

            public Observable<T> call(Observable<T> source) {
                return source.takeUntil(Observable.combineLatest((Observable)sharedLifecycle.take(1).map(correspondingEvents), (Observable)sharedLifecycle.skip(1), (Func2)new Func2<R, R, Boolean>(){

                    public Boolean call(R bindUntilEvent, R lifecycleEvent) {
                        return lifecycleEvent.equals(bindUntilEvent);
                    }
                }).onErrorReturn(RESUME_FUNCTION).takeFirst(SHOULD_COMPLETE));
            }
        };
    }
}

