/*
 * Decompiled with CFR 0.152.
 */
package com.trafi.anchorbottomsheetbehavior;

import android.support.design.widget.CoordinatorLayout;
import android.support.v4.view.ViewPager;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import com.trafi.anchorbottomsheetbehavior.AnchorBottomSheetBehavior;

public class BottomSheetUtils {
    public static void setupViewPager(ViewPager viewPager) {
        View bottomSheetParent = BottomSheetUtils.findBottomSheetParent((View)viewPager);
        if (bottomSheetParent != null) {
            viewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)new BottomSheetViewPagerListener(viewPager, bottomSheetParent));
        }
    }

    private static View findBottomSheetParent(View view) {
        View current = view;
        while (current != null) {
            ViewGroup.LayoutParams params = current.getLayoutParams();
            if (params instanceof CoordinatorLayout.LayoutParams && ((CoordinatorLayout.LayoutParams)params).getBehavior() instanceof AnchorBottomSheetBehavior) {
                return current;
            }
            ViewParent parent = current.getParent();
            current = parent == null || !(parent instanceof View) ? null : (View)parent;
        }
        return null;
    }

    private static class BottomSheetViewPagerListener
    extends ViewPager.SimpleOnPageChangeListener {
        private final ViewPager viewPager;
        private final AnchorBottomSheetBehavior<View> behavior;

        public BottomSheetViewPagerListener(ViewPager viewPager, View bottomSheetParent) {
            this.viewPager = viewPager;
            this.behavior = AnchorBottomSheetBehavior.from(bottomSheetParent);
        }

        public void onPageSelected(int position) {
            this.viewPager.post(new Runnable(){

                @Override
                public void run() {
                    BottomSheetViewPagerListener.this.behavior.invalidateScrollingChild();
                }
            });
        }
    }
}

