/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.junit.dataprovider;

import com.tngtech.junit.dataprovider.AbstractDataProviderInvocationContextProvider;
import com.tngtech.junit.dataprovider.DataProviderInvocationContext;
import com.tngtech.junit.dataprovider.DisplayNameContext;
import com.tngtech.junit.dataprovider.Preconditions;
import com.tngtech.junit.dataprovider.convert.ConverterContext;
import com.tngtech.junit.dataprovider.convert.DataConverter;
import com.tngtech.junit.dataprovider.resolver.DataProviderMethodResolverHelper;
import com.tngtech.junit.dataprovider.resolver.DataProviderResolverContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.jupiter.engine.config.DefaultJupiterConfiguration;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.jupiter.engine.execution.ExecutableInvoker;
import org.junit.jupiter.engine.extension.ExtensionRegistry;
import org.junit.jupiter.engine.extension.MutableExtensionRegistry;
import org.junit.platform.engine.ConfigurationParameters;

public abstract class UseDataProviderInvocationContextProvider<TEST_ANNOTATION extends Annotation, DATAPROVIDER_ANNOTATION extends Annotation>
extends AbstractDataProviderInvocationContextProvider<TEST_ANNOTATION> {
    private static final ExecutableInvoker executableInvoker = new ExecutableInvoker();
    protected static final ExtensionContext.Namespace NAMESPACE_USE_DATAPROVIDER = ExtensionContext.Namespace.create((Object[])new Object[]{UseDataProviderInvocationContextProvider.class, "dataCache"});
    private final Class<DATAPROVIDER_ANNOTATION> dataProviderAnnotationClass;

    protected UseDataProviderInvocationContextProvider(Class<TEST_ANNOTATION> annotationClass, Class<DATAPROVIDER_ANNOTATION> dataProviderAnnotationClass, DataConverter dataConverter) {
        super(annotationClass, dataConverter);
        this.dataProviderAnnotationClass = dataProviderAnnotationClass;
    }

    protected UseDataProviderInvocationContextProvider(Class<TEST_ANNOTATION> annotationClass, Class<DATAPROVIDER_ANNOTATION> dataProviderAnnotationClass) {
        super(annotationClass);
        this.dataProviderAnnotationClass = dataProviderAnnotationClass;
    }

    @Override
    protected Stream<TestTemplateInvocationContext> provideInvocationContexts(ExtensionContext context, TEST_ANNOTATION annotation) {
        Method testMethod = context.getRequiredTestMethod();
        DataProviderResolverContext dataProviderResolverContext = this.getDataProviderResolverContext(context, annotation);
        List dataProviderMethods = DataProviderMethodResolverHelper.findDataProviderMethods((DataProviderResolverContext)dataProviderResolverContext);
        Preconditions.checkArgument((dataProviderMethods.size() > 0 ? 1 : 0) != 0, (String)String.format("Could not find a dataprovider for test '%s' using resolvers '%s'.", testMethod, dataProviderResolverContext.getResolverClasses()));
        return dataProviderMethods.stream().flatMap(dpm -> {
            DATAPROVIDER_ANNOTATION dataProviderAnnotation = dpm.getAnnotation(this.dataProviderAnnotationClass);
            boolean cacheDataProviderResult = this.cacheDataProviderResult(dataProviderAnnotation);
            Object data = this.invokeDataProviderMethodToRetrieveData((Method)dpm, cacheDataProviderResult, context);
            return this.convertData(testMethod, data, this.getConverterContext(dataProviderAnnotation)).map(d -> new DataProviderInvocationContext(testMethod, (List<Object>)d, this.getDisplayNameContext(dataProviderAnnotation)));
        });
    }

    protected abstract DataProviderResolverContext getDataProviderResolverContext(ExtensionContext var1, TEST_ANNOTATION var2);

    protected abstract ConverterContext getConverterContext(DATAPROVIDER_ANNOTATION var1);

    protected boolean cacheDataProviderResult(DATAPROVIDER_ANNOTATION dataProviderAnnotation) {
        return true;
    }

    protected abstract DisplayNameContext getDisplayNameContext(DATAPROVIDER_ANNOTATION var1);

    @Deprecated
    protected Object invokeDataProviderMethodToRetrieveData(Method dataProviderMethod, ExtensionContext context) {
        return this.invokeDataProviderMethodToRetrieveData(dataProviderMethod, true, context);
    }

    protected Object invokeDataProviderMethodToRetrieveData(Method dataProviderMethod, boolean cacheDataProviderResult, ExtensionContext context) {
        Preconditions.checkNotNull((Object)dataProviderMethod, (String)"'dataProviderMethod' must not be null");
        Preconditions.checkNotNull((Object)context, (String)"'context' must not be null");
        ExtensionContext.Store store = context.getRoot().getStore(NAMESPACE_USE_DATAPROVIDER);
        Object cached = store.get((Object)dataProviderMethod);
        if (cached != null) {
            return cached;
        }
        try {
            MutableExtensionRegistry extensionRegistry = MutableExtensionRegistry.createRegistryWithDefaultExtensions((JupiterConfiguration)new DefaultJupiterConfiguration(this.emptyConfigurationParameters()));
            Object data = executableInvoker.invoke(dataProviderMethod, context.getTestInstance().orElse(null), context, (ExtensionRegistry)extensionRegistry, InvocationInterceptor::interceptTestFactoryMethod);
            if (cacheDataProviderResult) {
                store.put((Object)dataProviderMethod, data);
            }
            return data;
        }
        catch (Exception e) {
            throw new ParameterResolutionException(String.format("Exception while invoking dataprovider method '%s': %s", dataProviderMethod.getName(), e.getMessage()), (Throwable)e);
        }
    }

    private ConfigurationParameters emptyConfigurationParameters() {
        return new ConfigurationParameters(){

            public int size() {
                return 0;
            }

            public Optional<Boolean> getBoolean(String key) {
                return Optional.empty();
            }

            public Optional<String> get(String key) {
                return Optional.empty();
            }
        };
    }
}

