/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.junit;

import com.tngtech.archunit.junit.ArchIgnore;
import com.tngtech.archunit.junit.ArchTag;
import com.tngtech.archunit.junit.ArchUnitEngineExecutionContext;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.TestTag;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.AbstractTestDescriptor;
import org.junit.platform.engine.support.hierarchical.Node;

abstract class AbstractArchUnitTestDescriptor
extends AbstractTestDescriptor
implements Node<ArchUnitEngineExecutionContext> {
    private final Set<TestTag> tags;
    private final Node.SkipResult skipResult;

    AbstractArchUnitTestDescriptor(UniqueId uniqueId, String displayName, TestSource source, AnnotatedElement ... elements) {
        super(uniqueId, displayName, source);
        this.tags = Arrays.stream(elements).map(this::findTagsOn).flatMap(Collection::stream).collect(Collectors.toSet());
        this.skipResult = Arrays.stream(elements).map(e -> AnnotationSupport.findAnnotation((AnnotatedElement)e, ArchIgnore.class)).filter(Optional::isPresent).map(Optional::get).findFirst().map(ignore -> Node.SkipResult.skip((String)ignore.reason())).orElse(Node.SkipResult.doNotSkip());
    }

    private Set<TestTag> findTagsOn(AnnotatedElement annotatedElement) {
        return AnnotationSupport.findRepeatableAnnotations((AnnotatedElement)annotatedElement, ArchTag.class).stream().map(annotation -> TestTag.create((String)annotation.value())).collect(Collectors.toSet());
    }

    public Node.SkipResult shouldBeSkipped(ArchUnitEngineExecutionContext context) {
        return this.skipResult;
    }

    public Set<TestTag> getTags() {
        HashSet<TestTag> result = new HashSet<TestTag>(this.tags);
        result.addAll(this.getParent().map(TestDescriptor::getTags).orElse(Collections.emptySet()));
        return result;
    }
}

