/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.junit;

import com.tngtech.archunit.core.MayResolveTypesViaReflection;
import com.tngtech.archunit.junit.ArchTestInitializationException;
import com.tngtech.archunit.junit.ArchUnitEngineDescriptor;
import com.tngtech.archunit.junit.CreatesChildren;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Deque;
import java.util.LinkedList;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;

class ElementResolver {
    private final ArchUnitEngineDescriptor engineDescriptor;
    private final UniqueId processedId;
    private final Deque<UniqueId.Segment> segmentsToResolve;

    private ElementResolver(ArchUnitEngineDescriptor engineDescriptor, UniqueId processedId, Deque<UniqueId.Segment> segmentsToResolve) {
        this.engineDescriptor = (ArchUnitEngineDescriptor)((Object)Preconditions.checkNotNull((Object)((Object)engineDescriptor)));
        this.processedId = (UniqueId)Preconditions.checkNotNull((Object)processedId);
        this.segmentsToResolve = (Deque)Preconditions.checkNotNull(segmentsToResolve);
    }

    PossiblyResolvedClass resolveClass() {
        UniqueId.Segment nextSegment = (UniqueId.Segment)Preconditions.checkNotNull((Object)this.segmentsToResolve.peekFirst());
        if (!"class".equals(nextSegment.getType())) {
            return new ClassNotRequested();
        }
        return this.tryResolveClass(this.classOf(nextSegment), this.processedId.append(nextSegment));
    }

    PossiblyResolvedClass resolveClass(Class<?> clazz) {
        return this.tryResolveClass(clazz, this.processedId.append("class", clazz.getName()));
    }

    PossiblyResolvedMember resolveMethod(Method method) {
        return this.resolveMember(method, "method");
    }

    PossiblyResolvedMember resolveField(Field field) {
        return this.resolveMember(field, "field");
    }

    private PossiblyResolvedMember resolveMember(Member member, String segmentType) {
        UniqueId requestedId = this.processedId.append(segmentType, member.getName());
        return this.engineDescriptor.findByUniqueId(requestedId).isPresent() ? new SuccessfullyResolvedMember() : new UnresolvedMember(member, segmentType);
    }

    void resolve(String segmentType, String segmentValue, Consumer<ElementResolver> doIfResolved) {
        if (this.segmentsToResolve.isEmpty()) {
            this.handleNewSegment(segmentType, segmentValue, doIfResolved);
        } else {
            this.handleRequestedSegment(segmentType, segmentValue, doIfResolved);
        }
    }

    UniqueId getUniqueId() {
        return this.processedId;
    }

    private PossiblyResolvedClass tryResolveClass(Class<?> clazz, UniqueId classId) {
        ElementResolver childResolver = new ElementResolver(this.engineDescriptor, classId, this.tail(this.segmentsToResolve));
        return this.engineDescriptor.findByUniqueId(classId).map(testDescriptor -> new RequestedAndSuccessfullyResolvedClass((TestDescriptor)testDescriptor, childResolver)).orElseGet(() -> new RequestedButUnresolvedClass(clazz, childResolver));
    }

    private Deque<UniqueId.Segment> tail(Deque<UniqueId.Segment> segmentsToResolve) {
        LinkedList<UniqueId.Segment> result = new LinkedList<UniqueId.Segment>(segmentsToResolve);
        result.pollFirst();
        return result;
    }

    @MayResolveTypesViaReflection(reason="Within the ArchUnitTestEngine we may resolve types via reflection, since they are needed anyway")
    private Class<?> classOf(UniqueId.Segment segment) {
        try {
            return Class.forName(segment.getValue());
        }
        catch (ClassNotFoundException e) {
            throw new ArchTestInitializationException(e, "Failed to load class from %s segment %s", UniqueId.class.getSimpleName(), segment);
        }
    }

    private void handleRequestedSegment(String segmentType, String segmentValue, Consumer<ElementResolver> doIfResolved) {
        UniqueId.Segment nextSegment = (UniqueId.Segment)Preconditions.checkNotNull((Object)this.segmentsToResolve.peekFirst());
        if (this.matches(segmentType, segmentValue).test(nextSegment)) {
            doIfResolved.accept(new ElementResolver(this.engineDescriptor, this.processedId.append(nextSegment), this.tail(this.segmentsToResolve)));
        }
    }

    private Predicate<UniqueId.Segment> matches(String segmentType, String segmentValue) {
        return nextSegment -> nextSegment.getType().equals(segmentType) && nextSegment.getValue().equals(segmentValue);
    }

    private void handleNewSegment(String segmentType, String segmentValue, Consumer<ElementResolver> doIfResolved) {
        doIfResolved.accept(new ElementResolver(this.engineDescriptor, this.processedId.append(segmentType, segmentValue), new LinkedList<UniqueId.Segment>()));
    }

    static ElementResolver create(ArchUnitEngineDescriptor engineDescriptor, UniqueId rootId, UniqueId targetId) {
        return new ElementResolver(engineDescriptor, rootId, ElementResolver.getRemainingSegments(rootId, targetId));
    }

    static ElementResolver create(ArchUnitEngineDescriptor engineDescriptor, UniqueId rootId, Class<?> testClass) {
        UniqueId targetId = rootId.append("class", testClass.getName());
        return ElementResolver.create(engineDescriptor, rootId, targetId);
    }

    static ElementResolver create(ArchUnitEngineDescriptor engineDescriptor, UniqueId rootId, Class<?> testClass, Method testMethod) {
        UniqueId targetId = rootId.append("class", testClass.getName()).append("method", testMethod.getName());
        return ElementResolver.create(engineDescriptor, rootId, targetId);
    }

    static ElementResolver create(ArchUnitEngineDescriptor engineDescriptor, UniqueId rootId, Class<?> testClass, Field testField) {
        UniqueId targetId = rootId.append("class", testClass.getName()).append("field", testField.getName());
        return ElementResolver.create(engineDescriptor, rootId, targetId);
    }

    private static Deque<UniqueId.Segment> getRemainingSegments(UniqueId rootId, UniqueId targetId) {
        LinkedList<UniqueId.Segment> remainingSegments = new LinkedList<UniqueId.Segment>(targetId.getSegments());
        rootId.getSegments().forEach(segment -> {
            Preconditions.checkState((boolean)segment.equals(remainingSegments.peekFirst()), (String)"targetId %s should start with rootId %s", (Object)targetId, (Object)rootId);
            remainingSegments.pollFirst();
        });
        return remainingSegments;
    }

    private class UnresolvedMember
    extends PossiblyResolvedMember {
        private final Member member;
        private String segmentType;

        UnresolvedMember(Member member, String segmentType) {
            this.member = member;
            this.segmentType = segmentType;
        }

        @Override
        void ifUnresolved(Consumer<ElementResolver> doWithChildResolver) {
            ElementResolver.this.resolve(this.segmentType, this.member.getName(), doWithChildResolver);
        }
    }

    private class SuccessfullyResolvedMember
    extends PossiblyResolvedMember {
        private SuccessfullyResolvedMember() {
        }

        @Override
        void ifUnresolved(Consumer<ElementResolver> childResolver) {
        }
    }

    abstract class PossiblyResolvedMember {
        PossiblyResolvedMember() {
        }

        abstract void ifUnresolved(Consumer<ElementResolver> var1);
    }

    private class ClassNotRequested
    extends PossiblyResolvedClass {
        private ClassNotRequested() {
        }
    }

    private class RequestedButUnresolvedClass
    extends PossiblyResolvedClass {
        private final Class<?> clazz;
        private final ElementResolver childResolver;

        RequestedButUnresolvedClass(Class<?> clazz, ElementResolver childResolver) {
            this.clazz = clazz;
            this.childResolver = childResolver;
        }

        @Override
        void ifRequestedButUnresolved(BiConsumer<Class<?>, ElementResolver> doWithChildResolver) {
            doWithChildResolver.accept(this.clazz, this.childResolver);
        }
    }

    private class RequestedAndSuccessfullyResolvedClass
    extends PossiblyResolvedClass {
        private final CreatesChildren classDescriptor;
        private final ElementResolver childResolver;

        RequestedAndSuccessfullyResolvedClass(TestDescriptor classDescriptor, ElementResolver childResolver) {
            Preconditions.checkArgument((boolean)(classDescriptor instanceof CreatesChildren), (String)"descriptor with uniqueId %s is expected to implement %s", (Object)classDescriptor.getUniqueId(), (Object)CreatesChildren.class.getSimpleName());
            this.classDescriptor = (CreatesChildren)classDescriptor;
            this.childResolver = childResolver;
        }

        @Override
        RequestedAndSuccessfullyResolvedClass ifRequestedAndResolved(BiConsumer<CreatesChildren, ElementResolver> doIfResolved) {
            doIfResolved.accept(this.classDescriptor, this.childResolver);
            return this;
        }
    }

    abstract class PossiblyResolvedClass {
        PossiblyResolvedClass() {
        }

        void ifRequestedButUnresolved(BiConsumer<Class<?>, ElementResolver> doIfResolved) {
        }

        PossiblyResolvedClass ifRequestedAndResolved(BiConsumer<CreatesChildren, ElementResolver> doIfResolved) {
            return this;
        }
    }
}

