/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.junit;

import com.tngtech.archunit.PublicAPI;
import java.lang.reflect.Field;
import java.util.Objects;
import org.junit.platform.engine.TestSource;

@PublicAPI(usage=PublicAPI.Usage.ACCESS)
public final class FieldSource
implements TestSource {
    private final String className;
    private final String fieldName;

    private FieldSource(Field field) {
        this.className = field.getDeclaringClass().getName();
        this.fieldName = field.getName();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public String getClassName() {
        return this.className;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public String getFieldName() {
        return this.fieldName;
    }

    public int hashCode() {
        return Objects.hash(this.className, this.fieldName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FieldSource other = (FieldSource)obj;
        return Objects.equals(this.className, other.className) && Objects.equals(this.fieldName, other.fieldName);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.className + '.' + this.fieldName + '}';
    }

    static FieldSource from(Field field) {
        return new FieldSource(field);
    }
}

