/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.junit.internal;

import com.tngtech.archunit.core.domain.JavaClasses;
import com.tngtech.archunit.junit.internal.ArchTestExecution;
import com.tngtech.archunit.junit.internal.ArchTestInitializationException;
import com.tngtech.archunit.lang.ArchRule;
import java.lang.reflect.Field;
import java.util.List;
import org.junit.runner.Description;

class ArchRuleExecution
extends ArchTestExecution {
    private final Field ruleField;

    ArchRuleExecution(List<Class<?>> testClassPath, Class<?> ruleDeclaringClass, Field ruleField, boolean ignore) {
        super(testClassPath, ruleDeclaringClass, ignore);
        ArchTestInitializationException.check(ArchRule.class.isAssignableFrom(ruleField.getType()), "Rule field %s.%s to check must be of type %s", ruleDeclaringClass.getSimpleName(), ruleField.getName(), ArchRule.class.getSimpleName());
        this.ruleField = ruleField;
    }

    @Override
    ArchTestExecution.Result evaluateOn(JavaClasses classes) {
        ArchRule rule = (ArchRule)ArchRuleExecution.getValue(this.ruleField, this.ruleDeclaringClass);
        try {
            rule.check(classes);
        }
        catch (AssertionError | Exception e) {
            return new ArchTestExecution.NegativeResult(this.describeSelf(), (Throwable)e);
        }
        return new ArchTestExecution.PositiveResult();
    }

    @Override
    Description describeSelf() {
        return this.createDescription(this.ruleField);
    }

    @Override
    String getName() {
        return this.ruleField.getName();
    }
}

