/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.junit;

import com.tngtech.archunit.junit.ArchIgnore;
import com.tngtech.archunit.junit.ArchRules;
import com.tngtech.archunit.junit.ArchTestExecution;
import com.tngtech.archunit.junit.ReflectionUtils;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;

abstract class ArchRuleDeclaration<T extends AnnotatedElement> {
    private final Class<?> testClass;
    final T declaration;
    private final boolean forceIgnore;

    ArchRuleDeclaration(Class<?> testClass, T declaration, boolean forceIgnore) {
        this.testClass = testClass;
        this.declaration = declaration;
        this.forceIgnore = forceIgnore;
    }

    abstract void handleWith(Handler var1);

    private static ArchRuleDeclaration<Method> from(Class<?> testClass, Method method, boolean forceIgnore) {
        return new AsMethod(testClass, method, forceIgnore);
    }

    private static ArchRuleDeclaration<Field> from(Class<?> testClass, Field field, boolean forceIgnore) {
        return new AsField(testClass, field, forceIgnore);
    }

    static <T extends AnnotatedElement & Member> boolean elementShouldBeIgnored(T member) {
        return ArchRuleDeclaration.elementShouldBeIgnored(((Member)member).getDeclaringClass(), member);
    }

    static boolean elementShouldBeIgnored(Class<?> testClass, AnnotatedElement ruleDeclaration) {
        return testClass.getAnnotation(ArchIgnore.class) != null || ruleDeclaration.getAnnotation(ArchIgnore.class) != null;
    }

    boolean shouldBeIgnored() {
        return this.forceIgnore || ArchRuleDeclaration.elementShouldBeIgnored(this.testClass, this.declaration);
    }

    static Set<ArchRuleDeclaration<?>> toDeclarations(ArchRules rules, Class<?> testClass, Class<? extends Annotation> archTestAnnotationType, boolean forceIgnore) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (Field field : ReflectionUtils.getAllFields(rules.getDefinitionLocation(), ReflectionUtils.withAnnotation(archTestAnnotationType))) {
            result.addAll(ArchRuleDeclaration.archRuleDeclarationsFrom(testClass, field, archTestAnnotationType, forceIgnore));
        }
        for (Method method : ReflectionUtils.getAllMethods(rules.getDefinitionLocation(), ReflectionUtils.withAnnotation(archTestAnnotationType))) {
            result.add(ArchRuleDeclaration.from(testClass, method, forceIgnore));
        }
        return result.build();
    }

    private static Set<ArchRuleDeclaration<?>> archRuleDeclarationsFrom(Class<?> testClass, Field field, Class<? extends Annotation> archTestAnnotationType, boolean forceIgnore) {
        return ArchRules.class.isAssignableFrom(field.getType()) ? ArchRuleDeclaration.toDeclarations(ArchRuleDeclaration.getArchRulesIn(field), testClass, archTestAnnotationType, forceIgnore || ArchRuleDeclaration.elementShouldBeIgnored(field)) : Collections.singleton(ArchRuleDeclaration.from(testClass, field, forceIgnore));
    }

    private static ArchRules getArchRulesIn(Field field) {
        ArchRules value = (ArchRules)ArchTestExecution.getValue(field);
        return (ArchRules)Preconditions.checkNotNull((Object)value, (String)"Field %s.%s is not initialized", (Object)field.getDeclaringClass().getName(), (Object)field.getName());
    }

    static interface Handler {
        public void handleFieldDeclaration(Field var1, boolean var2);

        public void handleMethodDeclaration(Method var1, boolean var2);
    }

    private static class AsField
    extends ArchRuleDeclaration<Field> {
        AsField(Class<?> testClass, Field field, boolean forceIgnore) {
            super(testClass, field, forceIgnore);
        }

        @Override
        void handleWith(Handler handler) {
            handler.handleFieldDeclaration((Field)this.declaration, this.shouldBeIgnored());
        }
    }

    private static class AsMethod
    extends ArchRuleDeclaration<Method> {
        AsMethod(Class<?> testClass, Method method, boolean forceIgnore) {
            super(testClass, method, forceIgnore);
        }

        @Override
        void handleWith(Handler handler) {
            handler.handleMethodDeclaration((Method)this.declaration, this.shouldBeIgnored());
        }
    }
}

