package com.tinkerpatch.sdk.okhttp;

import com.squareup.okhttp.OkHttpClient;
import com.tinkerpatch.sdk.server.RequestLoader;
import com.tinkerpatch.sdk.server.model.DataFetcher;
import com.tinkerpatch.sdk.server.model.TinkerClientUrl;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;


/**
 * Okhttp 加载器
 */
public class OkHttpLoader implements RequestLoader {

    private final OkHttpClient client;

    /**
     * 使用用户传递的okhttp client
     * @param okHttpClient custom {@link com.squareup.okhttp.OkHttpClient}
     */
    public OkHttpLoader(OkHttpClient okHttpClient) {
        this.client = okHttpClient;
    }

    /**
     * 使用默认的okhttpclient
     */
    public OkHttpLoader() {
        this.client = new OkHttpClient();
        this.client.setConnectTimeout(30, TimeUnit.SECONDS);
        this.client.setReadTimeout(100, TimeUnit.SECONDS);
        this.client.setWriteTimeout(30, TimeUnit.SECONDS);
        this.client.setRetryOnConnectionFailure(true);
    }

    @Override
    public DataFetcher<InputStream> buildLoadData(TinkerClientUrl url) {
        return new OkHttpStreamFetcher(this.client, url);
    }
}
