/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpatch.sdk.okhttp;

import com.squareup.okhttp.OkHttpClient;
import com.tinkerpatch.sdk.okhttp.OkHttpStreamFetcher;
import com.tinkerpatch.sdk.server.RequestLoader;
import com.tinkerpatch.sdk.server.model.DataFetcher;
import com.tinkerpatch.sdk.server.model.TinkerClientUrl;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;

public class OkHttpLoader
implements RequestLoader {
    private final OkHttpClient client;

    public OkHttpLoader(OkHttpClient okHttpClient) {
        this.client = okHttpClient;
    }

    public OkHttpLoader() {
        this.client = new OkHttpClient();
        this.client.setConnectTimeout(30L, TimeUnit.SECONDS);
        this.client.setReadTimeout(100L, TimeUnit.SECONDS);
        this.client.setWriteTimeout(30L, TimeUnit.SECONDS);
        this.client.setRetryOnConnectionFailure(true);
    }

    public DataFetcher<InputStream> buildLoadData(TinkerClientUrl tinkerClientUrl) {
        return new OkHttpStreamFetcher(this.client, tinkerClientUrl);
    }
}

