/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpatch.sdk.server.callback;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.os.Process;
import com.tencent.tinker.lib.tinker.Tinker;
import com.tencent.tinker.lib.tinker.TinkerInstaller;
import com.tencent.tinker.lib.tinker.TinkerLoadResult;
import com.tencent.tinker.lib.util.TinkerLog;
import com.tencent.tinker.lib.util.TinkerServiceInternals;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import com.tencent.tinker.loader.shareutil.SharePatchInfo;
import com.tencent.tinker.loader.shareutil.ShareSecurityCheck;
import com.tencent.tinker.loader.shareutil.ShareTinkerInternals;
import com.tinkerpatch.sdk.server.a;
import com.tinkerpatch.sdk.server.callback.PatchRequestCallback;
import com.tinkerpatch.sdk.server.callback.RollbackCallBack;
import com.tinkerpatch.sdk.server.utils.d;
import com.tinkerpatch.sdk.util.b;
import com.tinkerpatch.sdk.util.e;
import com.tinkerpatch.sdk.util.f;
import com.tinkerpatch.sdk.util.g;
import java.io.File;

public class TinkerPatchRequestCallback
implements PatchRequestCallback {
    private static final String TAG = "Tinker.PatchRequestCallback";
    public static final String TINKER_DOWNLOAD_FAIL_TIMES = "tinker_download_fail";
    public static final int DOWNLOAD_FAIL_MAX_TIMES = 3;
    public static final int PATCH_MAX_RETRY_COUNT = 3;
    private static boolean rollbackOnScreenOff;
    private static RollbackCallBack rollbackCallBack;

    public static void setRollbackOnScreenOff(boolean bl) {
        rollbackOnScreenOff = bl;
    }

    public static void setPatchRollbackCallBack(RollbackCallBack rollbackCallBack) {
        TinkerPatchRequestCallback.rollbackCallBack = rollbackCallBack;
    }

    @Override
    public boolean beforePatchRequest() {
        Context context = e.a();
        Tinker tinker = Tinker.with((Context)context);
        if (!b.a(context)) {
            TinkerLog.i((String)TAG, (String)"TinkerPatchRequestCallback: beforePatchRequest return false, not connect to internet", (Object[])new Object[0]);
            return false;
        }
        if (TinkerServiceInternals.isTinkerPatchServiceRunning((Context)context)) {
            TinkerLog.i((String)TAG, (String)"TinkerPatchRequestCallback: beforePatchRequest return false, tinker service is running", (Object[])new Object[0]);
            return false;
        }
        if (!tinker.isMainProcess()) {
            TinkerLog.i((String)TAG, (String)"TinkerPatchRequestCallback: beforePatchRequest return false, only request on the main process", (Object[])new Object[0]);
            return false;
        }
        if (f.b()) {
            TinkerLog.e((String)TAG, (String)"TinkerPatchRequestCallback: beforePatchRequest return false, is in ignore channel, current channel:%s", (Object[])new Object[]{f.a()});
            return false;
        }
        return true;
    }

    @Override
    public void onPatchRollback() {
        Context context = e.a();
        Tinker tinker = Tinker.with((Context)context);
        if (!tinker.isTinkerLoaded()) {
            TinkerLog.w((String)TAG, (String)"TinkerPatchRequestCallback: onPatchRollback, tinker is not loaded, just return", (Object[])new Object[0]);
            return;
        }
        if (rollbackCallBack != null) {
            rollbackCallBack.onPatchRollback();
        }
        if (rollbackOnScreenOff) {
            TinkerLog.i((String)TAG, (String)"tinker wait screen to clean patch and kill all process", (Object[])new Object[0]);
            new f.b(context, new f.a(){

                @Override
                public void onScreenOff() {
                    TinkerPatchRequestCallback.this.rollbackPatchDirectly();
                }
            });
        }
        SharePatchInfo sharePatchInfo = new SharePatchInfo(tinker.getTinkerLoadResultIfPresent().currentVersion, "00000000000000000000000000000000", false, false, Build.FINGERPRINT, "odex");
        SharePatchInfo.rewritePatchInfoFileWithLock((File)tinker.getPatchInfoFile(), (SharePatchInfo)sharePatchInfo, (File)tinker.getPatchInfoLockFile());
    }

    @Override
    public void onPatchDownloadFail(Exception exception, Integer n, Integer n2) {
        TinkerLog.w((String)TAG, (String)"TinkerPatchRequestCallback: onPatchDownloadFail: %s", (Object[])new Object[]{exception.getMessage()});
    }

    @Override
    public boolean onPatchUpgrade(File file, Integer n, Integer n2) {
        TinkerLog.i((String)TAG, (String)"TinkerPatchRequestCallback: onPatchUpgrade, file:%s, newVersion:%d, currentVersion:%d", (Object[])new Object[]{file.getPath(), n, n2});
        a a2 = a.a();
        Context context = e.a();
        ShareSecurityCheck shareSecurityCheck = new ShareSecurityCheck(context);
        if (!shareSecurityCheck.verifyPatchMetaSignature(file)) {
            TinkerLog.e((String)TAG, (String)"onPatchUpgrade, signature check failed. file: %s, version:%d", (Object[])new Object[]{file.getPath(), n});
            if (this.increaseDownloadError(context)) {
                g.a().a(n, SharePatchFileUtil.getMD5((File)file));
                a2.a(n, -1);
            }
            SharePatchFileUtil.safeDeleteFile((File)file);
            return false;
        }
        if (ShareTinkerInternals.isVmJit()) {
            TinkerLog.e((String)TAG, (String)"TinkerPatchRequestCallback: is jvm jit, just return", (Object[])new Object[0]);
            g.a().a(n, SharePatchFileUtil.getMD5((File)file));
            SharePatchFileUtil.safeDeleteFile((File)file);
            a2.a(n, -205);
            return false;
        }
        this.handleUpgradePatch(file, n);
        SharedPreferences sharedPreferences = context.getSharedPreferences("patch_server_config", 0);
        sharedPreferences.edit().putInt(TINKER_DOWNLOAD_FAIL_TIMES, 0).apply();
        return true;
    }

    @Override
    public void onPatchNeedNotUpgrade() {
        String string;
        File file;
        Integer n;
        a a2 = a.a();
        Context context = e.a();
        Tinker tinker = Tinker.with((Context)context);
        g g2 = g.a();
        String string2 = g2.k();
        TinkerLoadResult tinkerLoadResult = tinker.getTinkerLoadResultIfPresent();
        if (!string2.equals(tinkerLoadResult.currentVersion) && (n = g2.e()) > 0 && (file = d.a(context, a2.d(), String.valueOf(n))).exists() && file.isFile() && (string = SharePatchFileUtil.getMD5((File)file)).equals(string2) && this.retryPendingPatch(context, n, string, file)) {
            return;
        }
    }

    @Override
    public void onPatchSyncFail(Exception exception) {
        TinkerLog.w((String)TAG, (String)("TinkerPatchRequestCallback onPatchSyncFail error: " + exception), (Object[])new Object[0]);
        TinkerLog.e((String)TAG, (String)"Plz make sure you fill the correct appVersion and appKey in tinkerpatch.gradle. Or create the correspond project in tinkerpatch.com", (Object[])new Object[0]);
    }

    @Override
    public void updatePatchConditions() {
        TinkerLog.i((String)TAG, (String)"TinkerPatchRequestCallback: updatePatchConditions", (Object[])new Object[0]);
        a a2 = a.a();
        Context context = e.a();
        a2.a("wifi", b.b(context) ? "1" : "0");
    }

    private boolean retryPendingPatch(Context context, Integer n, String string, File file) {
        g g2 = g.a();
        int n2 = g2.j() + 1;
        if (n2 < 3) {
            TinkerLog.d((String)TAG, (String)"[beforePatchRequest] have pending patch to install, version: %d, patch:%s", (Object[])new Object[]{n, file.getPath()});
            g2.c(string);
            TinkerInstaller.onReceiveUpgradePatch((Context)context, (String)file.getAbsolutePath());
            return true;
        }
        SharePatchFileUtil.safeDeleteFile((File)file);
        TinkerLog.d((String)TAG, (String)"[beforePatchRequest] retry patch install more than %d times, version: %d, patch:%s", (Object[])new Object[]{n2, n, file.getPath()});
        return false;
    }

    void rollbackPatchDirectly() {
        Context context = e.a();
        Tinker tinker = Tinker.with((Context)context);
        ShareTinkerInternals.killAllOtherProcess((Context)context);
        tinker.cleanPatch();
        Process.killProcess((int)Process.myPid());
    }

    private void handleUpgradePatch(File file, Integer n) {
        a a2 = a.a();
        Context context = e.a();
        g g2 = g.a();
        a2.a(n);
        String string = SharePatchFileUtil.getMD5((File)file);
        g2.a(n, string);
        g2.b();
        File[] fileArray = d.c(context).listFiles();
        if (fileArray != null) {
            String string2 = file.getName();
            for (File file2 : fileArray) {
                String string3 = file2.getName();
                if (string3.equals(string2) || string3.endsWith("_version.info") || string3.equals("version.lock")) continue;
                SharePatchFileUtil.safeDeleteFile((File)file2);
            }
        }
        TinkerInstaller.onReceiveUpgradePatch((Context)context, (String)file.getAbsolutePath());
    }

    private boolean increaseDownloadError(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("patch_server_config", 0);
        int n = sharedPreferences.getInt(TINKER_DOWNLOAD_FAIL_TIMES, 0);
        TinkerLog.i((String)TAG, (String)"TinkerPatchRequestCallback: increaseDownloadError, current count:%d", (Object[])new Object[]{n});
        if (n >= 3) {
            sharedPreferences.edit().putInt(TINKER_DOWNLOAD_FAIL_TIMES, 0).commit();
            return true;
        }
        sharedPreferences.edit().putInt(TINKER_DOWNLOAD_FAIL_TIMES, ++n).commit();
        return false;
    }
}

