/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader.shareutil;

import android.content.Context;
import android.util.Log;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.MessageDigest;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class SharePatchFileUtil {
    private static final String TAG = "Tinker.PatchFileUtil";

    public static File getPatchDirectory(Context context) {
        if ((context = context.getApplicationInfo()) == null) {
            return null;
        }
        return new File(context.dataDir, "tinker");
    }

    public static File getPatchTempDirectory(Context context) {
        if ((context = context.getApplicationInfo()) == null) {
            return null;
        }
        return new File(context.dataDir, "tinker_temp");
    }

    public static File getPatchLastCrashFile(Context object) {
        if ((object = SharePatchFileUtil.getPatchTempDirectory(object)) == null) {
            return null;
        }
        return new File((File)object, "tinker_last_crash");
    }

    public static File getPatchInfoFile(String string) {
        return new File(string + "/patch.info");
    }

    public static File getPatchInfoLockFile(String string) {
        return new File(string + "/info.lock");
    }

    public static String getPatchVersionDirectory(String string) {
        if (string == null || string.length() != 32) {
            return null;
        }
        return "patch-" + string.substring(0, 8);
    }

    public static String getPatchVersionFile(String string) {
        if (string == null || string.length() != 32) {
            return null;
        }
        return SharePatchFileUtil.getPatchVersionDirectory(string) + ".apk";
    }

    public static boolean checkIfMd5Valid(String string) {
        return string != null && string.length() == 32;
    }

    public static String checkTinkerLastUncaughtCrash(Context object) {
        if (!SharePatchFileUtil.isLegalFile((File)(object = SharePatchFileUtil.getPatchLastCrashFile(object)))) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream((File)object)));
            while ((object = bufferedReader.readLine()) != null) {
                stringBuffer.append((String)object);
                stringBuffer.append("\n");
            }
        }
        catch (Exception exception) {
            try {
                Log.e((String)TAG, (String)("checkTinkerLastUncaughtCrash exception: " + exception));
            }
            catch (Throwable throwable) {
                SharePatchFileUtil.closeQuietly(bufferedReader);
                throw throwable;
            }
            SharePatchFileUtil.closeQuietly(bufferedReader);
            return null;
        }
        SharePatchFileUtil.closeQuietly(bufferedReader);
        return stringBuffer.toString();
    }

    public static final boolean isLegalFile(File file) {
        return file != null && file.exists() && file.isFile() && file.length() > 0L;
    }

    public static long getFileOrDirectorySize(File fileArray) {
        if (fileArray == null || !fileArray.exists()) {
            return 0L;
        }
        if (fileArray.isFile()) {
            return fileArray.length();
        }
        long l = 0L;
        if ((fileArray = fileArray.listFiles()) != null) {
            for (File file : fileArray) {
                if (file.isDirectory()) {
                    l += SharePatchFileUtil.getFileOrDirectorySize(file);
                    continue;
                }
                l += file.length();
            }
        }
        return l;
    }

    public static final boolean safeDeleteFile(File file) {
        if (file == null) {
            return true;
        }
        Log.i((String)TAG, (String)("safeDeleteFile, try to delete path: " + file.getPath()));
        if (file.exists()) {
            boolean bl = file.delete();
            if (!bl) {
                Log.e((String)TAG, (String)("Failed to delete file, try to delete when exit. path: " + file.getPath()));
                file.deleteOnExit();
            }
            return bl;
        }
        return true;
    }

    public static final boolean deleteDir(String string) {
        if (string == null) {
            return false;
        }
        return SharePatchFileUtil.deleteDir(new File(string));
    }

    public static final boolean deleteDir(File file) {
        File[] fileArray;
        if (file == null || !file.exists()) {
            return false;
        }
        if (file.isFile()) {
            SharePatchFileUtil.safeDeleteFile(file);
        } else if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
            for (File file2 : fileArray) {
                SharePatchFileUtil.deleteDir(file2);
            }
            SharePatchFileUtil.safeDeleteFile(file);
        }
        return true;
    }

    public static boolean verifyFileMd5(File object, String string) {
        if (string == null) {
            return false;
        }
        if ((object = SharePatchFileUtil.getMD5((File)object)) == null) {
            return false;
        }
        return string.equals(object);
    }

    public static boolean isRawDexFile(String string) {
        if (string == null) {
            return false;
        }
        return string.endsWith(".dex");
    }

    /*
     * Loose catch block
     */
    public static boolean verifyDexFileMd5(File file, String string) {
        Object object;
        block19: {
            ZipFile zipFile;
            if (file == null || string == null) {
                return false;
            }
            if (SharePatchFileUtil.isRawDexFile(file.getName())) {
                object = SharePatchFileUtil.getMD5(file);
            } else {
                block17: {
                    zipFile = null;
                    zipFile = new ZipFile(file);
                    object = zipFile.getEntry("classes.dex");
                    if (object != null) break block17;
                    Log.e((String)TAG, (String)("There's no entry named: classes.dex in " + file.getAbsolutePath()));
                    try {
                        zipFile.close();
                    }
                    catch (Throwable throwable) {}
                    return false;
                }
                object = SharePatchFileUtil.getMD5(zipFile.getInputStream((ZipEntry)object));
                try {
                    zipFile.close();
                }
                catch (Throwable throwable) {}
            }
            break block19;
            catch (Throwable throwable) {
                block18: {
                    try {
                        Log.e((String)TAG, (String)("Bad dex jar file: " + file.getAbsolutePath()), (Throwable)throwable);
                        if (zipFile == null) break block18;
                    }
                    catch (Throwable throwable2) {
                        if (zipFile != null) {
                            try {
                                zipFile.close();
                            }
                            catch (Throwable throwable3) {}
                        }
                        throw throwable2;
                    }
                    try {
                        zipFile.close();
                    }
                    catch (Throwable throwable4) {}
                }
                return false;
            }
        }
        return string.equals(object);
    }

    public static void copyFileUsingStream(File object, File file) {
        if (!SharePatchFileUtil.isLegalFile((File)object) || file == null) {
            return;
        }
        if (((File)object).getAbsolutePath().equals(file.getAbsolutePath())) {
            return;
        }
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        File file2 = file.getParentFile();
        if (file2 != null && !file2.exists()) {
            file2.mkdirs();
        }
        try {
            int n;
            fileInputStream = new FileInputStream((File)object);
            fileOutputStream = new FileOutputStream(file, false);
            object = new byte[16384];
            while ((n = fileInputStream.read((byte[])object)) > 0) {
                fileOutputStream.write((byte[])object, 0, n);
            }
        }
        catch (Throwable throwable) {
            SharePatchFileUtil.closeQuietly(fileInputStream);
            SharePatchFileUtil.closeQuietly(fileOutputStream);
            throw throwable;
        }
        SharePatchFileUtil.closeQuietly(fileInputStream);
        SharePatchFileUtil.closeQuietly(fileOutputStream);
    }

    public static String loadDigestes(JarFile closeable, JarEntry object) {
        BufferedInputStream bufferedInputStream = null;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n;
            closeable = closeable.getInputStream((ZipEntry)object);
            object = new byte[16384];
            bufferedInputStream = new BufferedInputStream((InputStream)closeable);
            while ((n = ((InputStream)bufferedInputStream).read((byte[])object)) > 0) {
                stringBuilder.append(new String((byte[])object, 0, n));
            }
        }
        catch (Throwable throwable) {
            SharePatchFileUtil.closeQuietly(bufferedInputStream);
            throw throwable;
        }
        SharePatchFileUtil.closeQuietly(bufferedInputStream);
        return stringBuilder.toString();
    }

    public static final String getMD5(InputStream object) {
        if (object == null) {
            return null;
        }
        try {
            int n;
            object = new BufferedInputStream((InputStream)object);
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            StringBuilder stringBuilder = new StringBuilder(32);
            byte[] byArray = new byte[102400];
            while ((n = ((FilterInputStream)object).read(byArray)) != -1) {
                messageDigest.update(byArray, 0, n);
            }
            object = messageDigest.digest();
            for (int i = 0; i < ((Object)object).length; ++i) {
                stringBuilder.append(Integer.toString((object[i] & 0xFF) + 256, 16).substring(1));
            }
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getMD5(File object) {
        if (object == null) return null;
        if (!((File)object).exists()) {
            return null;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream((File)object);
            object = SharePatchFileUtil.getMD5(fileInputStream);
            fileInputStream.close();
        }
        catch (Exception exception) {
            try {
                if (fileInputStream == null) return null;
                fileInputStream.close();
                return null;
            }
            catch (IOException iOException) {}
            return null;
        }
        catch (Throwable throwable) {
            try {
                if (fileInputStream == null) throw throwable;
                fileInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            fileInputStream.close();
            return object;
        }
        catch (IOException iOException) {}
        return object;
    }

    public static String optimizedPathFor(File object, File file) {
        if (!((String)(object = ((File)object).getName())).endsWith(".dex")) {
            int n = ((String)object).lastIndexOf(".");
            if (n < 0) {
                object = (String)object + ".dex";
            } else {
                StringBuilder stringBuilder = new StringBuilder(n + 4);
                stringBuilder.append((CharSequence)object, 0, n);
                stringBuilder.append(".dex");
                object = stringBuilder.toString();
            }
        }
        File file2 = new File(file, (String)object);
        return file2.getPath();
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
            return;
        }
        catch (IOException iOException) {
            Log.w((String)TAG, (String)"Failed to close resource", (Throwable)iOException);
            return;
        }
    }

    public static void closeZip(ZipFile zipFile) {
        try {
            if (zipFile != null) {
                zipFile.close();
            }
            return;
        }
        catch (IOException iOException) {
            Log.w((String)TAG, (String)"Failed to close resource", (Throwable)iOException);
            return;
        }
    }

    /*
     * Loose catch block
     */
    public static boolean checkResourceArscMd5(File object, String string) {
        ZipFile zipFile;
        block10: {
            InputStream inputStream;
            block9: {
                block8: {
                    zipFile = null;
                    zipFile = new ZipFile((File)object);
                    object = zipFile.getEntry("resources.arsc");
                    if (object != null) break block8;
                    Log.i((String)TAG, (String)"checkResourceArscMd5 resources.arsc not found");
                    SharePatchFileUtil.closeZip(zipFile);
                    return false;
                }
                inputStream = null;
                inputStream = zipFile.getInputStream((ZipEntry)object);
                object = SharePatchFileUtil.getMD5(inputStream);
                if (object == null || !((String)object).equals(string)) break block9;
                SharePatchFileUtil.closeQuietly(inputStream);
                SharePatchFileUtil.closeZip(zipFile);
                return true;
            }
            try {
                SharePatchFileUtil.closeQuietly(inputStream);
                break block10;
                {
                    catch (Throwable throwable) {
                        SharePatchFileUtil.closeQuietly(inputStream);
                        throw throwable;
                    }
                }
            }
            catch (Throwable throwable) {
                try {
                    Log.i((String)TAG, (String)("checkResourceArscMd5 throwable:" + throwable.getMessage()));
                }
                catch (Throwable throwable2) {
                    SharePatchFileUtil.closeZip(zipFile);
                    throw throwable2;
                }
                SharePatchFileUtil.closeZip(zipFile);
            }
        }
        SharePatchFileUtil.closeZip(zipFile);
        return false;
    }

    public static void ensureFileDirectory(File file) {
        if (file == null) {
            return;
        }
        if (!(file = file.getParentFile()).exists()) {
            file.mkdirs();
        }
    }
}

