/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.lib.util;

import android.app.ActivityManager;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Process;
import android.util.Log;
import com.tencent.tinker.lib.service.TinkerPatchService;
import com.tencent.tinker.loader.shareutil.ShareTinkerInternals;

public class TinkerServiceInternals
extends ShareTinkerInternals {
    private static final String TAG = "Tinker.ServiceInternals";
    private static String patchServiceProcessName = null;

    public static void killTinkerPatchServiceProcess(Context object) {
        String string = TinkerServiceInternals.getTinkerPatchServiceName((Context)object);
        if (string == null) {
            return;
        }
        object = (ActivityManager)object.getSystemService("activity");
        if ((object = object.getRunningAppProcesses()) == null) {
            return;
        }
        object = object.iterator();
        while (object.hasNext()) {
            ActivityManager.RunningAppProcessInfo runningAppProcessInfo = (ActivityManager.RunningAppProcessInfo)object.next();
            String string2 = runningAppProcessInfo.processName;
            if (!string2.equals(string)) continue;
            Process.killProcess((int)runningAppProcessInfo.pid);
        }
    }

    public static boolean isTinkerPatchServiceRunning(Context object) {
        Object object2 = (ActivityManager)object.getSystemService("activity");
        if ((object = TinkerServiceInternals.getTinkerPatchServiceName(object)) == null) {
            return false;
        }
        try {
            object2 = object2.getRunningAppProcesses();
            if (object2 == null) {
                return false;
            }
            object2 = object2.iterator();
            while (object2.hasNext()) {
                Object object3 = (ActivityManager.RunningAppProcessInfo)object2.next();
                object3 = object3.processName;
                if (!object3.equals(object)) continue;
                return true;
            }
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("isTinkerPatchServiceRunning Exception: " + exception.toString()));
            return false;
        }
        catch (Error error) {
            Log.e((String)TAG, (String)("isTinkerPatchServiceRunning Error: " + error.toString()));
            return false;
        }
        return false;
    }

    public static String getTinkerPatchServiceName(Context object) {
        if (patchServiceProcessName != null) {
            return patchServiceProcessName;
        }
        if ((object = TinkerServiceInternals.getServiceProcessName(object, TinkerPatchService.class)) == null) {
            return null;
        }
        patchServiceProcessName = object;
        return patchServiceProcessName;
    }

    public static boolean isInTinkerPatchServiceProcess(Context object) {
        String string = TinkerServiceInternals.getProcessName((Context)object);
        if ((object = TinkerServiceInternals.getTinkerPatchServiceName((Context)object)) == null || ((String)object).length() == 0) {
            return false;
        }
        return string.equals(object);
    }

    private static String getServiceProcessName(Context context, Class<? extends Service> clazz) {
        PackageManager packageManager = context.getPackageManager();
        context = new ComponentName(context, clazz);
        try {
            context = packageManager.getServiceInfo((ComponentName)context, 0);
        }
        catch (Throwable throwable) {
            return null;
        }
        return context.processName;
    }
}

