/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.lib.reporter;

import android.content.Context;
import com.tencent.tinker.lib.reporter.LoadReporter;
import com.tencent.tinker.lib.tinker.Tinker;
import com.tencent.tinker.lib.tinker.TinkerLoadResult;
import com.tencent.tinker.lib.util.TinkerLog;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import com.tencent.tinker.loader.shareutil.SharePatchInfo;
import com.tencent.tinker.loader.shareutil.ShareTinkerInternals;
import java.io.File;

public class DefaultLoadReporter
implements LoadReporter {
    private static final String TAG = "Tinker.DefaultLoadReporter";
    protected final Context context;

    public DefaultLoadReporter(Context context) {
        this.context = context;
    }

    @Override
    public void onLoadPatchListenerReceiveFail(File file, int n) {
        TinkerLog.i(TAG, "patch loadReporter onLoadPatchListenerReceiveFail: patch receive fail:%s, code:%d", file.getAbsolutePath(), n);
    }

    @Override
    public void onLoadPatchVersionChanged(String fileArray, String string, File file, String string2) {
        TinkerLog.i(TAG, "patch loadReporter onLoadPatchVersionChanged: patch version change from " + (String)fileArray + " to " + string, new Object[0]);
        if (fileArray == null || string == null) {
            return;
        }
        if (fileArray.equals(string)) {
            return;
        }
        if (!Tinker.with(this.context).isMainProcess()) {
            return;
        }
        TinkerLog.i(TAG, "onLoadPatchVersionChanged, try kill all other process", new Object[0]);
        ShareTinkerInternals.killAllOtherProcess(this.context);
        fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                String string3 = file2.getName();
                if (!file2.isDirectory() || string3.equals(string2)) continue;
                SharePatchFileUtil.deleteDir(file2);
            }
        }
    }

    @Override
    public void onLoadFileNotFound(File file, int n, boolean bl) {
        TinkerLog.i(TAG, "patch loadReporter onLoadFileNotFound: patch file not found: %s, fileType:%d, isDirectory:%b", file.getAbsolutePath(), n, bl);
        this.checkAndCleanPatch();
    }

    @Override
    public void onLoadFileMd5Mismatch(File file, int n) {
        TinkerLog.i(TAG, "patch load Reporter onLoadFileMd5Mismatch: patch file md5 mismatch file: %s, fileType:%d", file.getAbsolutePath(), n);
        this.checkAndCleanPatch();
    }

    @Override
    public void onLoadPatchInfoCorrupted(String string, String string2, File file) {
        TinkerLog.i(TAG, "patch loadReporter onLoadPatchInfoCorrupted: patch info file damage: %s, from version: %s to version: %s", file.getAbsolutePath(), string, string2);
        this.checkAndCleanPatch();
    }

    @Override
    public void onLoadResult(File file, int n, long l) {
        TinkerLog.i(TAG, "patch loadReporter onLoadResult: patch load result, path:%s, code:%d, cost:%d", file.getAbsolutePath(), n, l);
    }

    @Override
    public void onLoadException(Throwable throwable, int n) {
        switch (n) {
            case -2: {
                if (throwable.getMessage().contains("checkDexInstall failed")) {
                    TinkerLog.e(TAG, "patch loadReporter onLoadException: tinker dex check fail:" + throwable.getMessage(), new Object[0]);
                } else {
                    TinkerLog.i(TAG, "patch loadReporter onLoadException: patch load dex exception: %s", throwable);
                }
                ShareTinkerInternals.setTinkerDisableWithSharedPreferences(this.context);
                TinkerLog.i(TAG, "dex exception disable tinker forever with sp", new Object[0]);
                break;
            }
            case -5: {
                TinkerLog.i(TAG, "patch load parallel dex opt exception: %s", throwable);
                break;
            }
            case -3: {
                if (throwable.getMessage().contains("checkResInstall failed")) {
                    TinkerLog.e(TAG, "patch loadReporter onLoadException: tinker res check fail:" + throwable.getMessage(), new Object[0]);
                } else {
                    TinkerLog.i(TAG, "patch loadReporter onLoadException: patch load resource exception: %s", throwable);
                }
                ShareTinkerInternals.setTinkerDisableWithSharedPreferences(this.context);
                TinkerLog.i(TAG, "res exception disable tinker forever with sp", new Object[0]);
                break;
            }
            case -4: {
                TinkerLog.i(TAG, "patch loadReporter onLoadException: patch load unCatch exception: %s", throwable);
                ShareTinkerInternals.setTinkerDisableWithSharedPreferences(this.context);
                TinkerLog.i(TAG, "unCaught exception disable tinker forever with sp", new Object[0]);
                break;
            }
            case -1: {
                TinkerLog.i(TAG, "patch loadReporter onLoadException: patch load unknown exception: %s", throwable);
            }
        }
        TinkerLog.e(TAG, "tinker load exception, welcome to submit issue to us: https://github.com/Tencent/tinker/issues", new Object[0]);
        TinkerLog.printErrStackTrace(TAG, throwable, "tinker load exception", new Object[0]);
        Tinker.with(this.context).setTinkerDisable();
        this.checkAndCleanPatch();
    }

    @Override
    public void onLoadPackageCheckFail(File file, int n) {
        TinkerLog.i(TAG, "patch loadReporter onLoadPackageCheckFail: load patch package check fail file path:%s, errorCode:%d", file.getAbsolutePath(), n);
        this.checkAndCleanPatch();
    }

    public void checkAndCleanPatch() {
        Tinker tinker = Tinker.with(this.context);
        if (tinker.isMainProcess()) {
            Object object = tinker.getTinkerLoadResultIfPresent();
            if (((TinkerLoadResult)object).versionChanged && (object = ((TinkerLoadResult)object).patchInfo) != null && !ShareTinkerInternals.isNullOrNil(((SharePatchInfo)object).oldVersion)) {
                TinkerLog.w(TAG, "checkAndCleanPatch, oldVersion %s is not null, try kill all other process", ((SharePatchInfo)object).oldVersion);
                ShareTinkerInternals.killAllOtherProcess(this.context);
            }
        }
        tinker.cleanPatch();
    }
}

