/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.lib.listener;

import android.content.Context;
import com.tencent.tinker.lib.listener.PatchListener;
import com.tencent.tinker.lib.service.TinkerPatchService;
import com.tencent.tinker.lib.tinker.Tinker;
import com.tencent.tinker.lib.util.TinkerServiceInternals;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import com.tencent.tinker.loader.shareutil.ShareTinkerInternals;
import java.io.File;

public class DefaultPatchListener
implements PatchListener {
    protected final Context context;

    public DefaultPatchListener(Context context) {
        this.context = context;
    }

    @Override
    public int onPatchReceived(String string) {
        int n = this.patchCheck(string);
        if (n == 0) {
            TinkerPatchService.runPatchService(this.context, string);
        } else {
            Tinker.with(this.context).getLoadReporter().onLoadPatchListenerReceiveFail(new File(string), n);
        }
        return n;
    }

    protected int patchCheck(String object) {
        Tinker tinker = Tinker.with(this.context);
        if (!tinker.isTinkerEnabled() || !ShareTinkerInternals.isTinkerEnableWithSharedPreferences(this.context)) {
            return -1;
        }
        if (!SharePatchFileUtil.isLegalFile((File)(object = new File((String)object)))) {
            return -2;
        }
        if (tinker.isPatchProcess()) {
            return -4;
        }
        if (TinkerServiceInternals.isTinkerPatchServiceRunning(this.context)) {
            return -3;
        }
        return 0;
    }
}

