/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.commons.dexpatcher.util;

import com.tencent.tinker.android.dex.Annotation;
import com.tencent.tinker.android.dex.AnnotationSet;
import com.tencent.tinker.android.dex.AnnotationSetRefList;
import com.tencent.tinker.android.dex.AnnotationsDirectory;
import com.tencent.tinker.android.dex.ClassData;
import com.tencent.tinker.android.dex.ClassDef;
import com.tencent.tinker.android.dex.Code;
import com.tencent.tinker.android.dex.DebugInfoItem;
import com.tencent.tinker.android.dex.DexException;
import com.tencent.tinker.android.dex.EncodedValue;
import com.tencent.tinker.android.dex.EncodedValueCodec;
import com.tencent.tinker.android.dex.EncodedValueReader;
import com.tencent.tinker.android.dex.FieldId;
import com.tencent.tinker.android.dex.Leb128;
import com.tencent.tinker.android.dex.MethodId;
import com.tencent.tinker.android.dex.ProtoId;
import com.tencent.tinker.android.dex.TypeList;
import com.tencent.tinker.android.dex.util.ByteInput;
import com.tencent.tinker.android.dex.util.ByteOutput;
import com.tencent.tinker.commons.dexpatcher.util.InstructionTransformer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

public abstract class AbstractIndexMap {
    public abstract int adjustStringIndex(int var1);

    public abstract int adjustTypeIdIndex(int var1);

    public abstract int adjustProtoIdIndex(int var1);

    public abstract int adjustFieldIdIndex(int var1);

    public abstract int adjustMethodIdIndex(int var1);

    public abstract int adjustTypeListOffset(int var1);

    public abstract int adjustAnnotationOffset(int var1);

    public abstract int adjustAnnotationSetOffset(int var1);

    public abstract int adjustAnnotationSetRefListOffset(int var1);

    public abstract int adjustAnnotationsDirectoryOffset(int var1);

    public abstract int adjustStaticValuesOffset(int var1);

    public abstract int adjustClassDataOffset(int var1);

    public abstract int adjustDebugInfoItemOffset(int var1);

    public abstract int adjustCodeOffset(int var1);

    public TypeList adjust(TypeList typeList) {
        if (typeList == TypeList.EMPTY) {
            return typeList;
        }
        short[] types = new short[typeList.types.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = (short)this.adjustTypeIdIndex(typeList.types[i]);
        }
        return new TypeList(typeList.off, types);
    }

    public MethodId adjust(MethodId methodId) {
        int adjustedDeclaringClassIndex = this.adjustTypeIdIndex(methodId.declaringClassIndex);
        int adjustedProtoIndex = this.adjustProtoIdIndex(methodId.protoIndex);
        int adjustedNameIndex = this.adjustStringIndex(methodId.nameIndex);
        return new MethodId(methodId.off, adjustedDeclaringClassIndex, adjustedProtoIndex, adjustedNameIndex);
    }

    public FieldId adjust(FieldId fieldId) {
        int adjustedDeclaringClassIndex = this.adjustTypeIdIndex(fieldId.declaringClassIndex);
        int adjustedTypeIndex = this.adjustTypeIdIndex(fieldId.typeIndex);
        int adjustedNameIndex = this.adjustStringIndex(fieldId.nameIndex);
        return new FieldId(fieldId.off, adjustedDeclaringClassIndex, adjustedTypeIndex, adjustedNameIndex);
    }

    public ProtoId adjust(ProtoId protoId) {
        int adjustedShortyIndex = this.adjustStringIndex(protoId.shortyIndex);
        int adjustedReturnTypeIndex = this.adjustTypeIdIndex(protoId.returnTypeIndex);
        int adjustedParametersOffset = this.adjustTypeListOffset(protoId.parametersOffset);
        return new ProtoId(protoId.off, adjustedShortyIndex, adjustedReturnTypeIndex, adjustedParametersOffset);
    }

    public ClassDef adjust(ClassDef classDef) {
        int adjustedTypeIndex = this.adjustTypeIdIndex(classDef.typeIndex);
        int adjustedSupertypeIndex = this.adjustTypeIdIndex(classDef.supertypeIndex);
        int adjustedInterfacesOffset = this.adjustTypeListOffset(classDef.interfacesOffset);
        int adjustedSourceFileIndex = this.adjustStringIndex(classDef.sourceFileIndex);
        int adjustedAnnotationsOffset = this.adjustAnnotationsDirectoryOffset(classDef.annotationsOffset);
        int adjustedClassDataOffset = this.adjustClassDataOffset(classDef.classDataOffset);
        int adjustedStaticValuesOffset = this.adjustStaticValuesOffset(classDef.staticValuesOffset);
        return new ClassDef(classDef.off, adjustedTypeIndex, classDef.accessFlags, adjustedSupertypeIndex, adjustedInterfacesOffset, adjustedSourceFileIndex, adjustedAnnotationsOffset, adjustedClassDataOffset, adjustedStaticValuesOffset);
    }

    public ClassData adjust(ClassData classData) {
        ClassData.Field[] adjustedStaticFields = this.adjustFields(classData.staticFields);
        ClassData.Field[] adjustedInstanceFields = this.adjustFields(classData.instanceFields);
        ClassData.Method[] adjustedDirectMethods = this.adjustMethods(classData.directMethods);
        ClassData.Method[] adjustedVirtualMethods = this.adjustMethods(classData.virtualMethods);
        return new ClassData(classData.off, adjustedStaticFields, adjustedInstanceFields, adjustedDirectMethods, adjustedVirtualMethods);
    }

    public Code adjust(Code code) {
        int adjustedDebugInfoOffset = this.adjustDebugInfoItemOffset(code.debugInfoOffset);
        short[] adjustedInstructions = this.adjustInstructions(code.instructions);
        Code.CatchHandler[] adjustedCatchHandlers = this.adjustCatchHandlers(code.catchHandlers);
        return new Code(code.off, code.registersSize, code.insSize, code.outsSize, adjustedDebugInfoOffset, adjustedInstructions, code.tries, adjustedCatchHandlers);
    }

    private short[] adjustInstructions(short[] instructions) {
        if (instructions == null || instructions.length == 0) {
            return instructions;
        }
        InstructionTransformer insTrans = new InstructionTransformer(this);
        return insTrans.transform(instructions);
    }

    private Code.CatchHandler[] adjustCatchHandlers(Code.CatchHandler[] catchHandlers) {
        if (catchHandlers == null || catchHandlers.length == 0) {
            return catchHandlers;
        }
        Code.CatchHandler[] adjustedCatchHandlers = new Code.CatchHandler[catchHandlers.length];
        for (int i = 0; i < catchHandlers.length; ++i) {
            Code.CatchHandler catchHandler = catchHandlers[i];
            int typeIndexesCount = catchHandler.typeIndexes.length;
            int[] adjustedTypeIndexes = new int[typeIndexesCount];
            for (int j = 0; j < typeIndexesCount; ++j) {
                adjustedTypeIndexes[j] = this.adjustTypeIdIndex(catchHandler.typeIndexes[j]);
            }
            adjustedCatchHandlers[i] = new Code.CatchHandler(adjustedTypeIndexes, catchHandler.addresses, catchHandler.catchAllAddress, catchHandler.offset);
        }
        return adjustedCatchHandlers;
    }

    private ClassData.Field[] adjustFields(ClassData.Field[] fields) {
        ClassData.Field[] adjustedFields = new ClassData.Field[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            ClassData.Field field = fields[i];
            int adjustedFieldIndex = this.adjustFieldIdIndex(field.fieldIndex);
            adjustedFields[i] = new ClassData.Field(adjustedFieldIndex, field.accessFlags);
        }
        return adjustedFields;
    }

    private ClassData.Method[] adjustMethods(ClassData.Method[] methods) {
        ClassData.Method[] adjustedMethods = new ClassData.Method[methods.length];
        for (int i = 0; i < methods.length; ++i) {
            ClassData.Method method = methods[i];
            int adjustedMethodIndex = this.adjustMethodIdIndex(method.methodIndex);
            int adjustedCodeOffset = this.adjustCodeOffset(method.codeOffset);
            adjustedMethods[i] = new ClassData.Method(adjustedMethodIndex, method.accessFlags, adjustedCodeOffset);
        }
        return adjustedMethods;
    }

    public DebugInfoItem adjust(DebugInfoItem debugInfoItem) {
        int[] parameterNames = this.adjustParameterNames(debugInfoItem.parameterNames);
        byte[] infoSTM = this.adjustDebugInfoItemSTM(debugInfoItem.infoSTM);
        return new DebugInfoItem(debugInfoItem.off, debugInfoItem.lineStart, parameterNames, infoSTM);
    }

    private int[] adjustParameterNames(int[] parameterNames) {
        int size = parameterNames.length;
        int[] adjustedParameterNames = new int[size];
        for (int i = 0; i < size; ++i) {
            adjustedParameterNames[i] = this.adjustStringIndex(parameterNames[i]);
        }
        return adjustedParameterNames;
    }

    /*
     * Enabled aggressive block sorting
     */
    private byte[] adjustDebugInfoItemSTM(byte[] infoSTM) {
        ByteArrayOutputStream baos;
        ByteArrayInputStream bais;
        final ByteArrayInputStream baisRef = bais = new ByteArrayInputStream(infoSTM);
        ByteInput inAdapter = new ByteInput(){

            public byte readByte() {
                return (byte)(baisRef.read() & 0xFF);
            }
        };
        final ByteArrayOutputStream baosRef = baos = new ByteArrayOutputStream(infoSTM.length + 512);
        ByteOutput outAdapter = new ByteOutput(){

            public void writeByte(int i) {
                baosRef.write(i);
            }
        };
        while (true) {
            int opcode = bais.read() & 0xFF;
            baos.write(opcode);
            switch (opcode) {
                case 0: {
                    return baos.toByteArray();
                }
                case 1: {
                    int addrDiff = Leb128.readUnsignedLeb128((ByteInput)inAdapter);
                    Leb128.writeUnsignedLeb128((ByteOutput)outAdapter, (int)addrDiff);
                    break;
                }
                case 2: {
                    int lineDiff = Leb128.readSignedLeb128((ByteInput)inAdapter);
                    Leb128.writeSignedLeb128((ByteOutput)outAdapter, (int)lineDiff);
                    break;
                }
                case 3: 
                case 4: {
                    int registerNum = Leb128.readUnsignedLeb128((ByteInput)inAdapter);
                    Leb128.writeUnsignedLeb128((ByteOutput)outAdapter, (int)registerNum);
                    int nameIndex = this.adjustStringIndex(Leb128.readUnsignedLeb128p1((ByteInput)inAdapter));
                    Leb128.writeUnsignedLeb128p1((ByteOutput)outAdapter, (int)nameIndex);
                    int typeIndex = this.adjustTypeIdIndex(Leb128.readUnsignedLeb128p1((ByteInput)inAdapter));
                    Leb128.writeUnsignedLeb128p1((ByteOutput)outAdapter, (int)typeIndex);
                    if (opcode != 4) break;
                    int sigIndex = this.adjustStringIndex(Leb128.readUnsignedLeb128p1((ByteInput)inAdapter));
                    Leb128.writeUnsignedLeb128p1((ByteOutput)outAdapter, (int)sigIndex);
                    break;
                }
                case 5: 
                case 6: {
                    int registerNum = Leb128.readUnsignedLeb128((ByteInput)inAdapter);
                    Leb128.writeUnsignedLeb128((ByteOutput)outAdapter, (int)registerNum);
                    break;
                }
                case 9: {
                    int nameIndex = this.adjustStringIndex(Leb128.readUnsignedLeb128p1((ByteInput)inAdapter));
                    Leb128.writeUnsignedLeb128p1((ByteOutput)outAdapter, (int)nameIndex);
                }
            }
        }
    }

    public EncodedValue adjust(EncodedValue encodedArray) {
        final ByteArrayOutputStream baos = new ByteArrayOutputStream(encodedArray.data.length);
        new EncodedValueTransformer(new ByteOutput(){

            public void writeByte(int i) {
                baos.write(i);
            }
        }).transformArray(new EncodedValueReader(encodedArray, 28));
        return new EncodedValue(encodedArray.off, baos.toByteArray());
    }

    public Annotation adjust(Annotation annotation) {
        final ByteArrayOutputStream baos = new ByteArrayOutputStream(annotation.encodedAnnotation.data.length);
        new EncodedValueTransformer(new ByteOutput(){

            public void writeByte(int i) {
                baos.write(i);
            }
        }).transformAnnotation(annotation.getReader());
        return new Annotation(annotation.off, annotation.visibility, new EncodedValue(annotation.encodedAnnotation.off, baos.toByteArray()));
    }

    public AnnotationSet adjust(AnnotationSet annotationSet) {
        int size = annotationSet.annotationOffsets.length;
        int[] adjustedAnnotationOffsets = new int[size];
        for (int i = 0; i < size; ++i) {
            adjustedAnnotationOffsets[i] = this.adjustAnnotationOffset(annotationSet.annotationOffsets[i]);
        }
        return new AnnotationSet(annotationSet.off, adjustedAnnotationOffsets);
    }

    public AnnotationSetRefList adjust(AnnotationSetRefList annotationSetRefList) {
        int size = annotationSetRefList.annotationSetRefItems.length;
        int[] adjustedAnnotationSetRefItems = new int[size];
        for (int i = 0; i < size; ++i) {
            adjustedAnnotationSetRefItems[i] = this.adjustAnnotationSetOffset(annotationSetRefList.annotationSetRefItems[i]);
        }
        return new AnnotationSetRefList(annotationSetRefList.off, adjustedAnnotationSetRefItems);
    }

    public AnnotationsDirectory adjust(AnnotationsDirectory annotationsDirectory) {
        int adjustedClassAnnotationsOffset = this.adjustAnnotationSetOffset(annotationsDirectory.classAnnotationsOffset);
        int[][] adjustedFieldAnnotations = new int[annotationsDirectory.fieldAnnotations.length][2];
        for (int i = 0; i < adjustedFieldAnnotations.length; ++i) {
            adjustedFieldAnnotations[i][0] = this.adjustFieldIdIndex(annotationsDirectory.fieldAnnotations[i][0]);
            adjustedFieldAnnotations[i][1] = this.adjustAnnotationSetOffset(annotationsDirectory.fieldAnnotations[i][1]);
        }
        int[][] adjustedMethodAnnotations = new int[annotationsDirectory.methodAnnotations.length][2];
        for (int i = 0; i < adjustedMethodAnnotations.length; ++i) {
            adjustedMethodAnnotations[i][0] = this.adjustMethodIdIndex(annotationsDirectory.methodAnnotations[i][0]);
            adjustedMethodAnnotations[i][1] = this.adjustAnnotationSetOffset(annotationsDirectory.methodAnnotations[i][1]);
        }
        int[][] adjustedParameterAnnotations = new int[annotationsDirectory.parameterAnnotations.length][2];
        for (int i = 0; i < adjustedParameterAnnotations.length; ++i) {
            adjustedParameterAnnotations[i][0] = this.adjustMethodIdIndex(annotationsDirectory.parameterAnnotations[i][0]);
            adjustedParameterAnnotations[i][1] = this.adjustAnnotationSetRefListOffset(annotationsDirectory.parameterAnnotations[i][1]);
        }
        return new AnnotationsDirectory(annotationsDirectory.off, adjustedClassAnnotationsOffset, adjustedFieldAnnotations, adjustedMethodAnnotations, adjustedParameterAnnotations);
    }

    private final class EncodedValueTransformer {
        private final ByteOutput out;

        EncodedValueTransformer(ByteOutput out) {
            this.out = out;
        }

        public void transform(EncodedValueReader reader) {
            switch (reader.peek()) {
                case 0: {
                    EncodedValueCodec.writeSignedIntegralValue((ByteOutput)this.out, (int)0, (long)reader.readByte());
                    break;
                }
                case 2: {
                    EncodedValueCodec.writeSignedIntegralValue((ByteOutput)this.out, (int)2, (long)reader.readShort());
                    break;
                }
                case 4: {
                    EncodedValueCodec.writeSignedIntegralValue((ByteOutput)this.out, (int)4, (long)reader.readInt());
                    break;
                }
                case 6: {
                    EncodedValueCodec.writeSignedIntegralValue((ByteOutput)this.out, (int)6, (long)reader.readLong());
                    break;
                }
                case 3: {
                    EncodedValueCodec.writeUnsignedIntegralValue((ByteOutput)this.out, (int)3, (long)reader.readChar());
                    break;
                }
                case 16: {
                    long longBits = (long)Float.floatToIntBits(reader.readFloat()) << 32;
                    EncodedValueCodec.writeRightZeroExtendedValue((ByteOutput)this.out, (int)16, (long)longBits);
                    break;
                }
                case 17: {
                    EncodedValueCodec.writeRightZeroExtendedValue((ByteOutput)this.out, (int)17, (long)Double.doubleToLongBits(reader.readDouble()));
                    break;
                }
                case 23: {
                    EncodedValueCodec.writeUnsignedIntegralValue((ByteOutput)this.out, (int)23, (long)AbstractIndexMap.this.adjustStringIndex(reader.readString()));
                    break;
                }
                case 24: {
                    EncodedValueCodec.writeUnsignedIntegralValue((ByteOutput)this.out, (int)24, (long)AbstractIndexMap.this.adjustTypeIdIndex(reader.readType()));
                    break;
                }
                case 25: {
                    EncodedValueCodec.writeUnsignedIntegralValue((ByteOutput)this.out, (int)25, (long)AbstractIndexMap.this.adjustFieldIdIndex(reader.readField()));
                    break;
                }
                case 27: {
                    EncodedValueCodec.writeUnsignedIntegralValue((ByteOutput)this.out, (int)27, (long)AbstractIndexMap.this.adjustFieldIdIndex(reader.readEnum()));
                    break;
                }
                case 26: {
                    EncodedValueCodec.writeUnsignedIntegralValue((ByteOutput)this.out, (int)26, (long)AbstractIndexMap.this.adjustMethodIdIndex(reader.readMethod()));
                    break;
                }
                case 28: {
                    this.writeTypeAndArg(28, 0);
                    this.transformArray(reader);
                    break;
                }
                case 29: {
                    this.writeTypeAndArg(29, 0);
                    this.transformAnnotation(reader);
                    break;
                }
                case 30: {
                    reader.readNull();
                    this.writeTypeAndArg(30, 0);
                    break;
                }
                case 31: {
                    boolean value = reader.readBoolean();
                    this.writeTypeAndArg(31, value ? 1 : 0);
                    break;
                }
                default: {
                    throw new DexException("Unexpected type: " + Integer.toHexString(reader.peek()));
                }
            }
        }

        private void transformAnnotation(EncodedValueReader reader) {
            int fieldCount = reader.readAnnotation();
            Leb128.writeUnsignedLeb128((ByteOutput)this.out, (int)AbstractIndexMap.this.adjustTypeIdIndex(reader.getAnnotationType()));
            Leb128.writeUnsignedLeb128((ByteOutput)this.out, (int)fieldCount);
            for (int i = 0; i < fieldCount; ++i) {
                Leb128.writeUnsignedLeb128((ByteOutput)this.out, (int)AbstractIndexMap.this.adjustStringIndex(reader.readAnnotationName()));
                this.transform(reader);
            }
        }

        private void transformArray(EncodedValueReader reader) {
            int size = reader.readArray();
            Leb128.writeUnsignedLeb128((ByteOutput)this.out, (int)size);
            for (int i = 0; i < size; ++i) {
                this.transform(reader);
            }
        }

        private void writeTypeAndArg(int type, int arg) {
            this.out.writeByte(arg << 5 | type);
        }
    }
}

