/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.os.Build;
import android.util.ArrayMap;
import android.util.Log;
import com.tencent.tinker.loader.TinkerRuntimeException;
import com.tencent.tinker.loader.shareutil.ShareReflectUtil;
import java.lang.ref.WeakReference;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

class TinkerResourcePatcher {
    private static final String TAG = "Tinker.ResourcePatcher";
    private static final String TEST_ASSETS_VALUE = "only_use_to_test_tinker_resource.txt";
    private static Collection<WeakReference<Resources>> references;
    private static AssetManager newAssetManager;
    private static Method addAssetPathMethod;
    private static Method ensureStringBlocksMethod;
    private static Field assetsFiled;
    private static Field resourcesImplFiled;
    private static Field resDir;
    private static Field packagesFiled;
    private static Field resourcePackagesFiled;

    TinkerResourcePatcher() {
    }

    public static void isResourceCanPatch(Context object) {
        Object object2;
        AnnotatedElement annotatedElement = Class.forName("android.app.ActivityThread");
        try {
            object2 = Class.forName("android.app.LoadedApk");
        }
        catch (ClassNotFoundException classNotFoundException) {
            object2 = Class.forName("android.app.ActivityThread$PackageInfo");
        }
        Field field = ((Class)object2).getDeclaredField("mApplication");
        field.setAccessible(true);
        resDir = ((Class)object2).getDeclaredField("mResDir");
        resDir.setAccessible(true);
        packagesFiled = ((Class)annotatedElement).getDeclaredField("mPackages");
        packagesFiled.setAccessible(true);
        resourcePackagesFiled = ((Class)annotatedElement).getDeclaredField("mResourcePackages");
        resourcePackagesFiled.setAccessible(true);
        object2 = object.getAssets();
        if (object2.getClass().getName().equals("android.content.res.BaiduAssetManager")) {
            object2 = Class.forName("android.content.res.BaiduAssetManager");
            newAssetManager = (AssetManager)((Class)object2).getConstructor(new Class[0]).newInstance(new Object[0]);
        } else {
            newAssetManager = (AssetManager)AssetManager.class.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        addAssetPathMethod = AssetManager.class.getDeclaredMethod("addAssetPath", String.class);
        addAssetPathMethod.setAccessible(true);
        ensureStringBlocksMethod = AssetManager.class.getDeclaredMethod("ensureStringBlocks", new Class[0]);
        ensureStringBlocksMethod.setAccessible(true);
        if (Build.VERSION.SDK_INT >= 19) {
            object2 = Class.forName("android.app.ResourcesManager");
            object = ((Class)object2).getDeclaredMethod("getInstance", new Class[0]);
            ((Method)object).setAccessible(true);
            object = ((Method)object).invoke(null, new Object[0]);
            try {
                annotatedElement = ((Class)object2).getDeclaredField("mActiveResources");
                ((Field)annotatedElement).setAccessible(true);
                annotatedElement = (ArrayMap)((Field)annotatedElement).get(object);
                references = annotatedElement.values();
            }
            catch (NoSuchFieldException noSuchFieldException) {
                annotatedElement = ((Class)object2).getDeclaredField("mResourceReferences");
                ((Field)annotatedElement).setAccessible(true);
                references = (Collection)((Field)annotatedElement).get(object);
            }
        } else {
            object2 = ((Class)annotatedElement).getDeclaredField("mActiveResources");
            ((Field)object2).setAccessible(true);
            object = ShareReflectUtil.getActivityThread((Context)object, annotatedElement);
            object = (HashMap)((Field)object2).get(object);
            references = ((HashMap)object).values();
        }
        if (references == null || references.isEmpty()) {
            throw new IllegalStateException("resource references is null or empty");
        }
        try {
            assetsFiled = Resources.class.getDeclaredField("mAssets");
            assetsFiled.setAccessible(true);
            return;
        }
        catch (Throwable throwable) {
            resourcesImplFiled = Resources.class.getDeclaredField("mResourcesImpl");
            resourcesImplFiled.setAccessible(true);
            return;
        }
    }

    public static void monkeyPatchExistingResources(Context context, String object4) {
        if (object4 == null) {
            return;
        }
        Object object = Class.forName("android.app.ActivityThread");
        object = ShareReflectUtil.getActivityThread(context, object);
        Field[] fieldArray = new Field[]{packagesFiled, resourcePackagesFiled};
        for (int i = 0; i < 2; ++i) {
            Field field = fieldArray[i];
            Object object2 = field.get(object);
            for (Map.Entry entry : ((Map)object2).entrySet()) {
                Object t = ((WeakReference)entry.getValue()).get();
                if (t == null || object4 == null) continue;
                resDir.set(t, object4);
            }
        }
        if ((Integer)addAssetPathMethod.invoke((Object)newAssetManager, object4) == 0) {
            throw new IllegalStateException("Could not create new AssetManager");
        }
        ensureStringBlocksMethod.invoke((Object)newAssetManager, new Object[0]);
        for (WeakReference weakReference : references) {
            Resources resources = (Resources)weakReference.get();
            if (resources == null) continue;
            try {
                assetsFiled.set(resources, newAssetManager);
            }
            catch (Throwable throwable) {
                Object object3 = resourcesImplFiled.get(resources);
                Field field = ShareReflectUtil.findField(object3, "mAssets");
                field.setAccessible(true);
                field.set(object3, newAssetManager);
            }
            resources.updateConfiguration(resources.getConfiguration(), resources.getDisplayMetrics());
        }
        if (!TinkerResourcePatcher.checkResUpdate(context)) {
            throw new TinkerRuntimeException("checkResInstall failed");
        }
    }

    private static boolean checkResUpdate(Context context) {
        try {
            Log.e((String)TAG, (String)"checkResUpdate success, found test resource assets file only_use_to_test_tinker_resource.txt");
            context.getAssets().open(TEST_ASSETS_VALUE);
        }
        catch (Throwable throwable) {
            Log.e((String)TAG, (String)("checkResUpdate failed, can't find test resource assets file only_use_to_test_tinker_resource.txt e:" + throwable.getMessage()));
            return false;
        }
        return true;
    }

    static {
        newAssetManager = null;
        addAssetPathMethod = null;
        ensureStringBlocksMethod = null;
        assetsFiled = null;
        resourcesImplFiled = null;
        resDir = null;
        packagesFiled = null;
        resourcePackagesFiled = null;
    }
}

