/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader;

import android.annotation.TargetApi;
import android.app.Application;
import android.content.Intent;
import android.util.Log;
import com.tencent.tinker.loader.SystemClassLoaderAdder;
import com.tencent.tinker.loader.TinkerParallelDexOptimizer;
import com.tencent.tinker.loader.shareutil.ShareDexDiffPatchInfo;
import com.tencent.tinker.loader.shareutil.ShareIntentUtil;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import com.tencent.tinker.loader.shareutil.ShareSecurityCheck;
import com.tencent.tinker.loader.shareutil.ShareTinkerInternals;
import dalvik.system.PathClassLoader;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;

public class TinkerDexLoader {
    private static final String TAG = "Tinker.TinkerDexLoader";
    private static final String DEX_MEAT_FILE = "assets/dex_meta.txt";
    private static final String DEX_PATH = "dex";
    private static final String DEX_OPTIMIZE_PATH = "odex";
    private static final ArrayList<ShareDexDiffPatchInfo> dexList = new ArrayList();
    private static boolean parallelOTAResult;
    private static Throwable parallelOTAThrowable;

    private TinkerDexLoader() {
    }

    @TargetApi(value=14)
    public static boolean loadTinkerJars(Application application, boolean bl, String object, Intent intent, boolean bl2) {
        if (dexList.isEmpty()) {
            Log.w((String)TAG, (String)"there is no dex to load");
            return true;
        }
        PathClassLoader pathClassLoader = (PathClassLoader)TinkerDexLoader.class.getClassLoader();
        if (pathClassLoader == null) {
            Log.e((String)TAG, (String)"classloader is null");
            ShareIntentUtil.setIntentReturnCode(intent, -12);
            return false;
        }
        Log.i((String)TAG, (String)("classloader: " + pathClassLoader.toString()));
        String string = (String)object + "/dex" + "/";
        object = new File((String)object + "/odex");
        ArrayList<File> arrayList = new ArrayList<File>();
        boolean bl3 = ShareTinkerInternals.isVmArt();
        for (ShareDexDiffPatchInfo shareDexDiffPatchInfo : dexList) {
            if (TinkerDexLoader.isJustArtSupportDex(shareDexDiffPatchInfo)) continue;
            Object object2 = string + shareDexDiffPatchInfo.realName;
            object2 = new File((String)object2);
            if (bl) {
                String string2;
                long l = System.currentTimeMillis();
                String string3 = string2 = bl3 ? shareDexDiffPatchInfo.destMd5InArt : shareDexDiffPatchInfo.destMd5InDvm;
                if (!SharePatchFileUtil.verifyDexFileMd5((File)object2, string2)) {
                    ShareIntentUtil.setIntentReturnCode(intent, -13);
                    intent.putExtra("intent_patch_mismatch_dex_path", ((File)object2).getAbsolutePath());
                    return false;
                }
                Log.i((String)TAG, (String)("verify dex file:" + ((File)object2).getPath() + " md5, use time: " + (System.currentTimeMillis() - l)));
            }
            arrayList.add((File)object2);
        }
        if (bl2) {
            parallelOTAResult = true;
            parallelOTAThrowable = null;
            Log.w((String)TAG, (String)"systemOTA, try parallel oat dexes!!!!!");
            TinkerParallelDexOptimizer.optimizeAll(arrayList, (File)object, new TinkerParallelDexOptimizer.ResultCallback(){
                long start;

                @Override
                public final void onStart(File file, File file2) {
                    this.start = System.currentTimeMillis();
                    Log.i((String)TinkerDexLoader.TAG, (String)("start to optimize dex:" + file.getPath()));
                }

                @Override
                public final void onSuccess(File file, File file2) {
                    Log.i((String)TinkerDexLoader.TAG, (String)("success to optimize dex " + file.getPath() + "use time " + (System.currentTimeMillis() - this.start)));
                }

                @Override
                public final void onFailed(File file, File file2, Throwable throwable) {
                    parallelOTAResult = false;
                    parallelOTAThrowable = throwable;
                    Log.i((String)TinkerDexLoader.TAG, (String)("fail to optimize dex " + file.getPath() + "use time " + (System.currentTimeMillis() - this.start)));
                }
            });
            if (!parallelOTAResult) {
                Log.e((String)TAG, (String)"parallel oat dexes failed");
                intent.putExtra("intent_patch_exception", (Serializable)parallelOTAThrowable);
                ShareIntentUtil.setIntentReturnCode(intent, -15);
                return false;
            }
        }
        try {
            SystemClassLoaderAdder.installDexes(application, pathClassLoader, (File)object, arrayList);
        }
        catch (Throwable throwable) {
            Log.e((String)TAG, (String)"install dexes failed");
            intent.putExtra("intent_patch_exception", (Serializable)throwable);
            ShareIntentUtil.setIntentReturnCode(intent, -14);
            return false;
        }
        return true;
    }

    public static boolean checkComplete(String object, ShareSecurityCheck hashMap, Intent intent) {
        if ((hashMap = ((ShareSecurityCheck)((Object)hashMap)).getMetaContentMap().get(DEX_MEAT_FILE)) == null) {
            return true;
        }
        dexList.clear();
        ShareDexDiffPatchInfo.parseDexDiffPatchInfo((String)((Object)hashMap), dexList);
        if (dexList.isEmpty()) {
            return true;
        }
        hashMap = new HashMap<String, String>();
        for (ShareDexDiffPatchInfo object22 : dexList) {
            if (TinkerDexLoader.isJustArtSupportDex(object22)) continue;
            if (!ShareDexDiffPatchInfo.checkDexDiffPatchInfo(object22)) {
                intent.putExtra("intent_patch_package_patch_check", -3);
                ShareIntentUtil.setIntentReturnCode(intent, -8);
                return false;
            }
            hashMap.put(object22.realName, object22.destMd5InDvm);
        }
        String string = (String)object + "/dex" + "/";
        File file = new File(string);
        if (!file.exists() || !file.isDirectory()) {
            ShareIntentUtil.setIntentReturnCode(intent, -9);
            return false;
        }
        object = (String)object + "/odex" + "/";
        object = new File((String)object);
        for (Object object2 : hashMap.keySet()) {
            object2 = new File((String)string + (String)object2);
            if (!((File)object2).exists()) {
                intent.putExtra("intent_patch_missing_dex_path", ((File)object2).getAbsolutePath());
                ShareIntentUtil.setIntentReturnCode(intent, -10);
                return false;
            }
            if (((File)(object2 = new File(SharePatchFileUtil.optimizedPathFor((File)object2, (File)object)))).exists()) continue;
            intent.putExtra("intent_patch_missing_dex_path", ((File)object2).getAbsolutePath());
            ShareIntentUtil.setIntentReturnCode(intent, -11);
            return false;
        }
        intent.putExtra("intent_patch_dexes_path", hashMap);
        return true;
    }

    private static boolean isJustArtSupportDex(ShareDexDiffPatchInfo object) {
        if (ShareTinkerInternals.isVmArt()) {
            return false;
        }
        object = ((ShareDexDiffPatchInfo)object).destMd5InDvm;
        return ((String)object).equals("0");
    }
}

