/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.lib.service;

import android.app.IntentService;
import android.app.Notification;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.IBinder;
import android.os.SystemClock;
import com.tencent.tinker.lib.patch.AbstractPatch;
import com.tencent.tinker.lib.service.AbstractResultService;
import com.tencent.tinker.lib.service.PatchResult;
import com.tencent.tinker.lib.tinker.Tinker;
import com.tencent.tinker.lib.util.TinkerLog;
import com.tencent.tinker.loader.TinkerRuntimeException;
import com.tencent.tinker.loader.shareutil.ShareIntentUtil;
import java.io.File;

public class TinkerPatchService
extends IntentService {
    private static final String TAG = "Tinker.TinkerPatchService";
    private static final String PATCH_PATH_EXTRA = "patch_path_extra";
    private static final String RESULT_CLASS_EXTRA = "patch_result_class";
    private static AbstractPatch upgradePatchProcessor = null;
    private static int notificationId = -1119860829;
    private static Class<? extends AbstractResultService> resultServiceClass = null;

    public TinkerPatchService() {
        super(TinkerPatchService.class.getSimpleName());
    }

    public static void runPatchService(Context context, String string) {
        try {
            Intent intent = new Intent(context, TinkerPatchService.class);
            intent.putExtra(PATCH_PATH_EXTRA, string);
            intent.putExtra(RESULT_CLASS_EXTRA, resultServiceClass.getName());
            context.startService(intent);
            return;
        }
        catch (Throwable throwable) {
            TinkerLog.e(TAG, "start patch service fail, exception:" + throwable, new Object[0]);
            return;
        }
    }

    public static void setPatchProcessor(AbstractPatch abstractPatch, Class<? extends AbstractResultService> clazz) {
        upgradePatchProcessor = abstractPatch;
        resultServiceClass = clazz;
        try {
            Class.forName(clazz.getName());
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return;
        }
    }

    public static String getPatchPathExtra(Intent intent) {
        if (intent == null) {
            throw new TinkerRuntimeException("getPatchPathExtra, but intent is null");
        }
        return ShareIntentUtil.getStringExtra(intent, PATCH_PATH_EXTRA);
    }

    public static String getPatchResultExtra(Intent intent) {
        if (intent == null) {
            throw new TinkerRuntimeException("getPatchResultExtra, but intent is null");
        }
        return ShareIntentUtil.getStringExtra(intent, RESULT_CLASS_EXTRA);
    }

    public static void setTinkerNotificationId(int n) {
        notificationId = n;
    }

    protected void onHandleIntent(Intent intent) {
        boolean bl;
        Context context = this.getApplicationContext();
        Tinker tinker = Tinker.with(context);
        tinker.getPatchReporter().onPatchServiceStart(intent);
        if (intent == null) {
            TinkerLog.e(TAG, "TinkerPatchService received a null intent, ignoring.", new Object[0]);
            return;
        }
        String string = TinkerPatchService.getPatchPathExtra(intent);
        if (string == null) {
            TinkerLog.e(TAG, "TinkerPatchService can't get the path extra, ignoring.", new Object[0]);
            return;
        }
        File file = new File(string);
        long l = SystemClock.elapsedRealtime();
        Throwable throwable = null;
        this.increasingPriority();
        PatchResult patchResult = new PatchResult();
        try {
            if (upgradePatchProcessor == null) {
                throw new TinkerRuntimeException("upgradePatchProcessor is null.");
            }
            bl = upgradePatchProcessor.tryPatch(context, string, patchResult);
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throwable = throwable2;
            bl = false;
            tinker.getPatchReporter().onPatchException(file, throwable);
        }
        long l2 = SystemClock.elapsedRealtime() - l;
        tinker.getPatchReporter().onPatchResult(file, bl, l2);
        patchResult.isSuccess = bl;
        patchResult.rawPatchFilePath = string;
        patchResult.costTime = l2;
        patchResult.e = throwable;
        AbstractResultService.runResultService(context, patchResult, TinkerPatchService.getPatchResultExtra(intent));
    }

    private void increasingPriority() {
        TinkerLog.i(TAG, "try to increase patch process priority", new Object[0]);
        try {
            Notification notification = new Notification();
            if (Build.VERSION.SDK_INT >= 18) {
                this.startForeground(notificationId, notification);
                this.startService(new Intent((Context)this, InnerService.class));
                return;
            }
            this.startForeground(notificationId, notification);
        }
        catch (Throwable throwable) {
            TinkerLog.i(TAG, "try to increase patch process priority error:" + throwable, new Object[0]);
        }
    }

    public static class InnerService
    extends Service {
        public void onCreate() {
            super.onCreate();
            try {
                this.startForeground(notificationId, new Notification());
            }
            catch (Throwable throwable) {
                TinkerLog.e(TinkerPatchService.TAG, "InnerService set service for push exception:%s.", throwable);
            }
            this.stopSelf();
        }

        public void onDestroy() {
            this.stopForeground(true);
            super.onDestroy();
        }

        public IBinder onBind(Intent intent) {
            return null;
        }
    }
}

