/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.lib.service;

import android.os.Process;
import com.tencent.tinker.lib.service.AbstractResultService;
import com.tencent.tinker.lib.service.PatchResult;
import com.tencent.tinker.lib.tinker.Tinker;
import com.tencent.tinker.lib.tinker.TinkerLoadResult;
import com.tencent.tinker.lib.util.TinkerLog;
import com.tencent.tinker.lib.util.TinkerServiceInternals;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import java.io.File;

public class DefaultTinkerResultService
extends AbstractResultService {
    private static final String TAG = "Tinker.DefaultTinkerResultService";

    @Override
    public void onPatchResult(PatchResult patchResult) {
        if (patchResult == null) {
            TinkerLog.e(TAG, "DefaultTinkerResultService received null result!!!!", new Object[0]);
            return;
        }
        TinkerLog.i(TAG, "DefaultTinkerResultService received a result:%s ", patchResult.toString());
        TinkerServiceInternals.killTinkerPatchServiceProcess(this.getApplicationContext());
        if (patchResult.isSuccess) {
            File file = new File(patchResult.rawPatchFilePath);
            if (file.exists()) {
                TinkerLog.i(TAG, "save delete raw patch file", new Object[0]);
                SharePatchFileUtil.safeDeleteFile(file);
            }
            if (this.checkIfNeedKill(patchResult)) {
                Process.killProcess((int)Process.myPid());
                return;
            }
            TinkerLog.i(TAG, "I have already install the newly patch version!", new Object[0]);
        }
    }

    public boolean checkIfNeedKill(PatchResult patchResult) {
        Object object = Tinker.with(this.getApplicationContext());
        if (((Tinker)object).isTinkerLoaded() && (object = ((Tinker)object).getTinkerLoadResultIfPresent()) != null) {
            object = ((TinkerLoadResult)object).currentVersion;
            if (patchResult.patchVersion != null && patchResult.patchVersion.equals(object)) {
                return false;
            }
        }
        return true;
    }
}

