/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.lib.patch;

import android.content.Context;
import android.os.Build;
import com.tencent.tinker.lib.patch.AbstractPatch;
import com.tencent.tinker.lib.patch.BsDiffPatchInternal;
import com.tencent.tinker.lib.patch.DexDiffPatchInternal;
import com.tencent.tinker.lib.patch.ResDiffPatchInternal;
import com.tencent.tinker.lib.service.PatchResult;
import com.tencent.tinker.lib.tinker.Tinker;
import com.tencent.tinker.lib.util.TinkerLog;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import com.tencent.tinker.loader.shareutil.SharePatchInfo;
import com.tencent.tinker.loader.shareutil.ShareSecurityCheck;
import com.tencent.tinker.loader.shareutil.ShareTinkerInternals;
import java.io.File;
import java.io.IOException;

public class UpgradePatch
extends AbstractPatch {
    private static final String TAG = "Tinker.UpgradePatch";

    @Override
    public boolean tryPatch(Context object, String object2, PatchResult object3) {
        Tinker tinker = Tinker.with(object);
        object2 = new File((String)object2);
        if (!tinker.isTinkerEnabled() || !ShareTinkerInternals.isTinkerEnableWithSharedPreferences(object)) {
            TinkerLog.e(TAG, "UpgradePatch tryPatch:patch is disabled, just return", new Object[0]);
            return false;
        }
        if (!((File)object2).isFile() || !((File)object2).exists()) {
            TinkerLog.e(TAG, "UpgradePatch tryPatch:patch file is not found, just return", new Object[0]);
            return false;
        }
        ShareSecurityCheck shareSecurityCheck = new ShareSecurityCheck((Context)object);
        int n = ShareTinkerInternals.checkTinkerPackage(object, tinker.getTinkerFlags(), (File)object2, shareSecurityCheck);
        if (n != 0) {
            TinkerLog.e(TAG, "UpgradePatch tryPatch:onPatchPackageCheckFail", new Object[0]);
            tinker.getPatchReporter().onPatchPackageCheckFail((File)object2, n);
            return false;
        }
        Object object4 = tinker.getTinkerLoadResultIfPresent().patchInfo;
        Object object5 = SharePatchFileUtil.getMD5((File)object2);
        if (object5 == null) {
            TinkerLog.e(TAG, "UpgradePatch tryPatch:patch md5 is null, just return", new Object[0]);
            return false;
        }
        ((PatchResult)object3).patchVersion = object5;
        if (object4 != null) {
            if (((SharePatchInfo)object4).oldVersion == null || ((SharePatchInfo)object4).newVersion == null) {
                TinkerLog.e(TAG, "UpgradePatch tryPatch:onPatchInfoCorrupted", new Object[0]);
                tinker.getPatchReporter().onPatchInfoCorrupted((File)object2, ((SharePatchInfo)object4).oldVersion, ((SharePatchInfo)object4).newVersion);
                return false;
            }
            if (((SharePatchInfo)object4).oldVersion.equals(object5) || ((SharePatchInfo)object4).newVersion.equals(object5)) {
                TinkerLog.e(TAG, "UpgradePatch tryPatch:onPatchVersionCheckFail", new Object[0]);
                tinker.getPatchReporter().onPatchVersionCheckFail((File)object2, (SharePatchInfo)object4, (String)object5);
                return false;
            }
            object3 = new SharePatchInfo(((SharePatchInfo)object4).oldVersion, (String)object5, Build.FINGERPRINT);
        } else {
            object3 = new SharePatchInfo("", (String)object5, Build.FINGERPRINT);
        }
        object4 = tinker.getPatchDirectory().getAbsolutePath();
        TinkerLog.i(TAG, "UpgradePatch tryPatch:patchMd5:%s", object5);
        String string = SharePatchFileUtil.getPatchVersionDirectory((String)object5);
        string = (String)object4 + "/" + string;
        TinkerLog.i(TAG, "UpgradePatch tryPatch:patchVersionDirectory:%s", string);
        object5 = new File(string + "/" + SharePatchFileUtil.getPatchVersionFile((String)object5));
        try {
            SharePatchFileUtil.copyFileUsingStream((File)object2, (File)object5);
            TinkerLog.w(TAG, "UpgradePatch after %s size:%d, %s size:%d", ((File)object2).getAbsolutePath(), ((File)object2).length(), ((File)object5).getAbsolutePath(), ((File)object5).length());
        }
        catch (IOException iOException) {
            TinkerLog.e(TAG, "UpgradePatch tryPatch:copy patch file fail from %s to %s", ((File)object2).getPath(), ((File)object5).getPath());
            tinker.getPatchReporter().onPatchTypeExtractFail((File)object2, (File)object5, ((File)object2).getName(), 1);
            return false;
        }
        if (!DexDiffPatchInternal.tryRecoverDexFiles(tinker, shareSecurityCheck, object, string, (File)object5)) {
            TinkerLog.e(TAG, "UpgradePatch tryPatch:new patch recover, try patch dex failed", new Object[0]);
            return false;
        }
        if (!BsDiffPatchInternal.tryRecoverLibraryFiles(tinker, shareSecurityCheck, object, string, (File)object5)) {
            TinkerLog.e(TAG, "UpgradePatch tryPatch:new patch recover, try patch library failed", new Object[0]);
            return false;
        }
        if (!ResDiffPatchInternal.tryRecoverResourceFiles(tinker, shareSecurityCheck, object, string, (File)object5)) {
            TinkerLog.e(TAG, "UpgradePatch tryPatch:new patch recover, try patch resource failed", new Object[0]);
            return false;
        }
        object = tinker.getPatchInfoFile();
        if (!SharePatchInfo.rewritePatchInfoFileWithLock((File)object, (SharePatchInfo)object3, SharePatchFileUtil.getPatchInfoLockFile((String)object4))) {
            TinkerLog.e(TAG, "UpgradePatch tryPatch:new patch recover, rewrite patch info failed", new Object[0]);
            tinker.getPatchReporter().onPatchInfoCorrupted((File)object2, ((SharePatchInfo)object3).oldVersion, ((SharePatchInfo)object3).newVersion);
            return false;
        }
        TinkerLog.w(TAG, "UpgradePatch tryPatch: done, it is ok", new Object[0]);
        return true;
    }
}

