/*
 * Decompiled with CFR 0.152.
 */
package com.tinfoilsecurity.plugins.tinfoilscan;

import com.tinfoilsecurity.api.Client;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import java.io.IOException;
import javax.servlet.ServletException;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class TinfoilScanRecorder
extends Recorder {
    private String apiAccessKey;
    private String apiSecretKey;
    private String apiHost;
    private String siteID;
    private String proxyHost;
    private Integer proxyPort;
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public TinfoilScanRecorder(String accessKey, String secretKey, String apiHost, String siteID, String proxyHost, Integer proxyPort) {
        this.apiAccessKey = accessKey;
        this.apiSecretKey = secretKey;
        this.apiHost = apiHost;
        this.siteID = siteID;
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
    }

    public String getAPIAccessKey() {
        return this.apiAccessKey;
    }

    public String getAPISecretKey() {
        return this.apiSecretKey;
    }

    public String getAPIHost() {
        return this.apiHost;
    }

    public String getSiteID() {
        return this.siteID;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.STEP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        try {
            EnvVars environment = build.getEnvironment((TaskListener)listener);
            this.apiAccessKey = environment.expand(this.getAPIAccessKey());
            this.apiSecretKey = environment.expand(this.getAPISecretKey());
            try (Client tinfoilAPI = this.getDescriptor().buildClient(environment, this.apiAccessKey, this.apiSecretKey, this.getAPIHost(), this.getProxyHost(), this.getProxyPort());){
                tinfoilAPI.startScan(this.siteID);
                String host = StringUtils.isNotBlank((String)this.getAPIHost()) ? this.getAPIHost() : this.getDescriptor().getAPIHost();
                listener.getLogger().println("Tinfoil Security scan started! Log in to " + host + "/sites to view its progress.");
            }
            build.setResult(Result.SUCCESS);
        }
        catch (InterruptedException e) {
            listener.getLogger().println("Your Tinfoil Security scan could not be started. " + e.getMessage());
        }
        catch (IOException e) {
            listener.getLogger().println("Your Tinfoil Security scan could not be started. " + e.getMessage());
        }
        return true;
    }

    public DescriptorImpl getDescriptor() {
        return DESCRIPTOR;
    }

    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private String apiHost;
        private String apiAccessKey;
        private String apiSecretKey;
        private String proxyHost;
        private Integer proxyPort;

        public DescriptorImpl() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Tinfoil Security";
        }

        public String getDefaultAPIHost() {
            return "https://www.tinfoilsecurity.com";
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            this.apiHost = json.getString("apiHost");
            if (StringUtils.isBlank((String)this.apiHost)) {
                this.apiHost = this.getDefaultAPIHost();
            }
            this.apiAccessKey = json.getString("accessKey");
            this.apiSecretKey = json.getString("secretKey");
            this.proxyHost = json.getString("proxyHost");
            try {
                this.proxyPort = StringUtils.isBlank((String)this.proxyHost) ? null : Integer.valueOf(json.getInt("proxyPort"));
            }
            catch (JSONException e) {
                this.proxyPort = null;
            }
            this.save();
            return super.configure(req, json);
        }

        public String getAPIHost() {
            return this.apiHost;
        }

        public String getAPIAccessKey() {
            return this.apiAccessKey;
        }

        public String getAPISecretKey() {
            return this.apiSecretKey;
        }

        public String getProxyHost() {
            return this.proxyHost;
        }

        public Integer getProxyPort() {
            return this.proxyPort;
        }

        public FormValidation doCheckProxyPort(@QueryParameter String value, @QueryParameter String proxyHost) throws IOException, ServletException {
            if (StringUtils.isBlank((String)proxyHost)) {
                return FormValidation.ok();
            }
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.error((String)"Proxy Port is required when Proxy Host is specified");
            }
            try {
                Integer.parseInt(value);
                return FormValidation.ok();
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)"Proxy Port must be a number");
            }
        }

        public Client buildClient(EnvVars environment, String apiAccessKey, String apiSecretKey, String apiHost, String proxyHost, Integer proxyPort) throws IOException, InterruptedException {
            if (StringUtils.isBlank((String)apiAccessKey)) {
                if (environment == null) {
                    apiAccessKey = this.getAPIAccessKey();
                } else {
                    environment.expand(this.getAPIAccessKey());
                }
            }
            if (StringUtils.isBlank((String)apiSecretKey)) {
                if (environment == null) {
                    apiSecretKey = this.getAPISecretKey();
                } else {
                    environment.expand(this.getAPISecretKey());
                }
            }
            Client client = new Client(apiAccessKey, apiSecretKey);
            if (StringUtils.isBlank((String)apiHost)) {
                apiHost = this.getAPIHost();
            }
            if (this.getDefaultAPIHost() != apiHost) {
                client.setAPIHost(apiHost);
            }
            if (!StringUtils.isBlank((String)proxyHost)) {
                client.setProxyConfig(proxyHost, proxyPort);
            }
            return client;
        }
    }
}

