/*
 * Decompiled with CFR 0.152.
 */
package com.timshadel.simplesecrets;

import com.timshadel.simplesecrets.Primitives;
import com.timshadel.simplesecrets.Utilities;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.msgpack.template.Template;

public class Packet {
    private final byte[] master_key;
    private final byte[] identity;

    public Packet(String master_key) throws GeneralSecurityException {
        if (master_key == null) {
            throw new IllegalArgumentException("Master key is required.");
        }
        try {
            this.master_key = Hex.decodeHex((char[])master_key.toCharArray());
        }
        catch (DecoderException e) {
            throw new IllegalArgumentException("Invalid hexidecimal key.", e);
        }
        Utilities.assertBinarySize(this.master_key, 32);
        this.identity = Primitives.identify(this.master_key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pack(Object data) throws GeneralSecurityException, IOException {
        String string;
        byte[] body = null;
        byte[] encrypted = null;
        byte[] packet = null;
        try {
            body = Packet.build_body(data);
            encrypted = Packet.encrypt_body(body, this.master_key);
            packet = Packet.authenticate(encrypted, this.master_key, this.identity);
            string = Primitives.stringify(packet);
        }
        catch (Throwable throwable) {
            Primitives.zero(body, encrypted, packet);
            throw throwable;
        }
        Primitives.zero(body, encrypted, packet);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T unpack(String packed_data, Class<T> klass) throws GeneralSecurityException, IOException {
        T t;
        byte[] body = null;
        try {
            body = this.body_for_unpack(packed_data);
            t = Packet.body_to_data(body, klass);
        }
        catch (Throwable throwable) {
            Primitives.zero(new byte[][]{body});
            throw throwable;
        }
        Primitives.zero(new byte[][]{body});
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T unpack(String packed_data, Template<T> template) throws GeneralSecurityException, IOException {
        T t;
        byte[] body = null;
        try {
            body = this.body_for_unpack(packed_data);
            t = Packet.body_to_data(body, template);
        }
        catch (Throwable throwable) {
            Primitives.zero(new byte[][]{body});
            throw throwable;
        }
        Primitives.zero(new byte[][]{body});
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] build_body(Object data) throws IOException {
        byte[] byArray;
        byte[] nonce = null;
        byte[] binary = null;
        try {
            nonce = Primitives.nonce();
            binary = Primitives.serialize(data);
            byArray = Utilities.joinByteArrays(nonce, binary);
        }
        catch (Throwable throwable) {
            Primitives.zero(nonce, binary);
            throw throwable;
        }
        Primitives.zero(nonce, binary);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T body_to_data(byte[] body, Class<T> klass) throws GeneralSecurityException, IOException {
        T t;
        byte[] payload = null;
        try {
            payload = Packet.payload_for_body_to_data(body);
            t = Primitives.deserialize(payload, klass);
        }
        catch (Throwable throwable) {
            Primitives.zero(new byte[][]{payload});
            throw throwable;
        }
        Primitives.zero(new byte[][]{payload});
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T body_to_data(byte[] body, Template<T> template) throws GeneralSecurityException, IOException {
        T t;
        byte[] payload = null;
        try {
            payload = Packet.payload_for_body_to_data(body);
            t = Primitives.deserialize(payload, template);
        }
        catch (Throwable throwable) {
            Primitives.zero(new byte[][]{payload});
            throw throwable;
        }
        Primitives.zero(new byte[][]{payload});
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] encrypt_body(byte[] body, byte[] master_key) throws GeneralSecurityException {
        byte[] byArray;
        byte[] key = null;
        try {
            key = Primitives.derive_sender_key(master_key);
            byArray = Primitives.encrypt(body, key);
        }
        catch (Throwable throwable) {
            Primitives.zero(new byte[][]{key});
            throw throwable;
        }
        Primitives.zero(new byte[][]{key});
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] decrypt_body(byte[] cipher_data, byte[] master_key) throws GeneralSecurityException {
        byte[] byArray;
        if (cipher_data.length < 16) {
            throw new GeneralSecurityException("Invalid encrypted payload.");
        }
        byte[] iv = null;
        byte[] encrypted = null;
        byte[] key = null;
        try {
            iv = Arrays.copyOfRange(cipher_data, 0, 16);
            encrypted = Arrays.copyOfRange(cipher_data, 16, cipher_data.length);
            key = Primitives.derive_sender_key(master_key);
            byArray = Primitives.decrypt(encrypted, key, iv);
        }
        catch (Throwable throwable) {
            Primitives.zero(key, iv, encrypted);
            throw throwable;
        }
        Primitives.zero(key, iv, encrypted);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] authenticate(byte[] data, byte[] master_key, byte[] identity) throws GeneralSecurityException {
        byte[] byArray;
        byte[] hmac_key = null;
        byte[] mac = null;
        try {
            hmac_key = Primitives.derive_sender_hmac(master_key);
            byte[] auth = Utilities.joinByteArrays(identity, data);
            mac = Primitives.mac(auth, hmac_key);
            byArray = Utilities.joinByteArrays(auth, mac);
        }
        catch (Throwable throwable) {
            Primitives.zero(hmac_key, mac);
            throw throwable;
        }
        Primitives.zero(hmac_key, mac);
        return byArray;
    }

    public static byte[] verify(byte[] packet, byte[] master_key, byte[] identity) throws GeneralSecurityException {
        byte[] hmac_key;
        byte[] mac;
        if (packet.length < 6) {
            throw new GeneralSecurityException("Missing packet identity.");
        }
        byte[] packet_id = Arrays.copyOfRange(packet, 0, 6);
        if (!Primitives.compare(packet_id, identity)) {
            throw new GeneralSecurityException("Invalid packet identity.");
        }
        if (packet.length < 38) {
            throw new GeneralSecurityException("Missing packet MAC.");
        }
        byte[] data = Arrays.copyOfRange(packet, 0, packet.length - 32);
        byte[] packet_mac = Arrays.copyOfRange(packet, packet.length - 32, packet.length);
        if (!Primitives.compare(packet_mac, mac = Primitives.mac(data, hmac_key = Primitives.derive_sender_hmac(master_key)))) {
            throw new GeneralSecurityException("Invalid packet MAC.");
        }
        Primitives.zero(hmac_key, mac);
        return Arrays.copyOfRange(packet, 6, packet.length - 32);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] body_for_unpack(String packed_data) throws GeneralSecurityException, IOException {
        byte[] byArray;
        byte[] packet = null;
        byte[] cipher_data = null;
        try {
            packet = Primitives.binify(packed_data);
            cipher_data = Packet.verify(packet, this.master_key, this.identity);
            byArray = Packet.decrypt_body(cipher_data, this.master_key);
        }
        catch (Throwable throwable) {
            Primitives.zero(packet, cipher_data);
            throw throwable;
        }
        Primitives.zero(packet, cipher_data);
        return byArray;
    }

    private static byte[] payload_for_body_to_data(byte[] body) throws GeneralSecurityException {
        if (body.length < 16) {
            throw new GeneralSecurityException("Invalid serialized payload.");
        }
        return Arrays.copyOfRange(body, 16, body.length);
    }
}

