/*
 * Decompiled with CFR 0.152.
 */
package com.timshadel.simplesecrets;

public class Utilities {
    public static void assertBinary(byte[] binary) {
        if (binary == null) {
            throw new IllegalArgumentException("Byte array required.");
        }
    }

    public static void assertBinarySize(byte[] binary, int bytes) {
        if (binary == null || binary.length != bytes) {
            throw new IllegalArgumentException(bytes * 8 + "-bit byte array required.");
        }
    }

    public static byte[] joinByteArrays(byte[] ... binaries) {
        int size = 0;
        if (binaries[0] == null) {
            return new byte[0];
        }
        for (byte[] binary : binaries) {
            size += binary.length;
        }
        int index = 0;
        byte[] result = new byte[size];
        for (byte[] binary : binaries) {
            System.arraycopy(binary, 0, result, index, binary.length);
            index += binary.length;
        }
        return result;
    }
}

