/*
 * Decompiled with CFR 0.152.
 */
package com.timehop.stickyheadersrecyclerview.rendering;

import android.graphics.Canvas;
import android.graphics.Rect;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.timehop.stickyheadersrecyclerview.calculation.DimensionCalculator;
import com.timehop.stickyheadersrecyclerview.util.OrientationProvider;

public class HeaderRenderer {
    private final DimensionCalculator mDimensionCalculator;
    private final OrientationProvider mOrientationProvider;
    private final Rect mTempRect = new Rect();

    public HeaderRenderer(OrientationProvider orientationProvider) {
        this(orientationProvider, new DimensionCalculator());
    }

    private HeaderRenderer(OrientationProvider orientationProvider, DimensionCalculator dimensionCalculator) {
        this.mOrientationProvider = orientationProvider;
        this.mDimensionCalculator = dimensionCalculator;
    }

    public void drawHeader(RecyclerView recyclerView, Canvas canvas, View header, Rect offset) {
        canvas.save();
        if (recyclerView.getLayoutManager().getClipToPadding()) {
            this.initClipRectForHeader(this.mTempRect, recyclerView, header);
            canvas.clipRect(this.mTempRect);
        }
        canvas.translate((float)offset.left, (float)offset.top);
        header.draw(canvas);
        canvas.restore();
    }

    private void initClipRectForHeader(Rect clipRect, RecyclerView recyclerView, View header) {
        this.mDimensionCalculator.initMargins(clipRect, header);
        if (this.mOrientationProvider.getOrientation(recyclerView) == 1) {
            clipRect.set(recyclerView.getPaddingLeft(), recyclerView.getPaddingTop(), recyclerView.getWidth() - recyclerView.getPaddingRight() - clipRect.right, recyclerView.getHeight() - recyclerView.getPaddingBottom());
        } else {
            clipRect.set(recyclerView.getPaddingLeft(), recyclerView.getPaddingTop(), recyclerView.getWidth() - recyclerView.getPaddingRight(), recyclerView.getHeight() - recyclerView.getPaddingBottom() - clipRect.bottom);
        }
    }
}

