/*
 * Decompiled with CFR 0.152.
 */
package com.timehop.stickyheadersrecyclerview;

import android.graphics.Canvas;
import android.graphics.Rect;
import android.support.v7.widget.RecyclerView;
import android.util.SparseArray;
import android.view.View;
import com.timehop.stickyheadersrecyclerview.HeaderPositionCalculator;
import com.timehop.stickyheadersrecyclerview.StickyRecyclerHeadersAdapter;
import com.timehop.stickyheadersrecyclerview.caching.HeaderProvider;
import com.timehop.stickyheadersrecyclerview.caching.HeaderViewCache;
import com.timehop.stickyheadersrecyclerview.calculation.DimensionCalculator;
import com.timehop.stickyheadersrecyclerview.rendering.HeaderRenderer;
import com.timehop.stickyheadersrecyclerview.util.LinearLayoutOrientationProvider;
import com.timehop.stickyheadersrecyclerview.util.OrientationProvider;

public class StickyRecyclerHeadersDecoration
extends RecyclerView.ItemDecoration {
    private final StickyRecyclerHeadersAdapter mAdapter;
    private final SparseArray<Rect> mHeaderRects = new SparseArray();
    private final HeaderProvider mHeaderProvider;
    private final OrientationProvider mOrientationProvider;
    private final HeaderPositionCalculator mHeaderPositionCalculator;
    private final HeaderRenderer mRenderer;
    private final DimensionCalculator mDimensionCalculator;
    private final Rect mTempRect = new Rect();

    public StickyRecyclerHeadersDecoration(StickyRecyclerHeadersAdapter adapter) {
        this(adapter, new LinearLayoutOrientationProvider(), new DimensionCalculator());
    }

    private StickyRecyclerHeadersDecoration(StickyRecyclerHeadersAdapter adapter, OrientationProvider orientationProvider, DimensionCalculator dimensionCalculator) {
        this(adapter, orientationProvider, dimensionCalculator, new HeaderRenderer(orientationProvider), new HeaderViewCache(adapter, orientationProvider));
    }

    private StickyRecyclerHeadersDecoration(StickyRecyclerHeadersAdapter adapter, OrientationProvider orientationProvider, DimensionCalculator dimensionCalculator, HeaderRenderer headerRenderer, HeaderProvider headerProvider) {
        this(adapter, headerRenderer, orientationProvider, dimensionCalculator, headerProvider, new HeaderPositionCalculator(adapter, headerProvider, orientationProvider, dimensionCalculator));
    }

    private StickyRecyclerHeadersDecoration(StickyRecyclerHeadersAdapter adapter, HeaderRenderer headerRenderer, OrientationProvider orientationProvider, DimensionCalculator dimensionCalculator, HeaderProvider headerProvider, HeaderPositionCalculator headerPositionCalculator) {
        this.mAdapter = adapter;
        this.mHeaderProvider = headerProvider;
        this.mOrientationProvider = orientationProvider;
        this.mRenderer = headerRenderer;
        this.mDimensionCalculator = dimensionCalculator;
        this.mHeaderPositionCalculator = headerPositionCalculator;
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        super.getItemOffsets(outRect, view, parent, state);
        int itemPosition = parent.getChildAdapterPosition(view);
        if (itemPosition == -1) {
            return;
        }
        if (this.mHeaderPositionCalculator.hasNewHeader(itemPosition, this.mOrientationProvider.isReverseLayout(parent))) {
            View header = this.getHeaderView(parent, itemPosition);
            this.setItemOffsetsForHeader(outRect, header, this.mOrientationProvider.getOrientation(parent));
        }
    }

    private void setItemOffsetsForHeader(Rect itemOffsets, View header, int orientation) {
        this.mDimensionCalculator.initMargins(this.mTempRect, header);
        if (orientation == 1) {
            itemOffsets.top = header.getHeight() + this.mTempRect.top + this.mTempRect.bottom;
        } else {
            itemOffsets.left = header.getWidth() + this.mTempRect.left + this.mTempRect.right;
        }
    }

    public void onDrawOver(Canvas canvas, RecyclerView parent, RecyclerView.State state) {
        super.onDrawOver(canvas, parent, state);
        int childCount = parent.getChildCount();
        if (childCount <= 0 || this.mAdapter.getItemCount() <= 0) {
            return;
        }
        for (int i = 0; i < childCount; ++i) {
            boolean hasStickyHeader;
            View itemView = parent.getChildAt(i);
            int position = parent.getChildAdapterPosition(itemView);
            if (position == -1 || !(hasStickyHeader = this.mHeaderPositionCalculator.hasStickyHeader(itemView, this.mOrientationProvider.getOrientation(parent), position)) && !this.mHeaderPositionCalculator.hasNewHeader(position, this.mOrientationProvider.isReverseLayout(parent))) continue;
            View header = this.mHeaderProvider.getHeader(parent, position);
            Rect headerOffset = (Rect)this.mHeaderRects.get(position);
            if (headerOffset == null) {
                headerOffset = new Rect();
                this.mHeaderRects.put(position, (Object)headerOffset);
            }
            this.mHeaderPositionCalculator.initHeaderBounds(headerOffset, parent, header, itemView, hasStickyHeader);
            this.mRenderer.drawHeader(parent, canvas, header, headerOffset);
        }
    }

    public int findHeaderPositionUnder(int x, int y) {
        for (int i = 0; i < this.mHeaderRects.size(); ++i) {
            Rect rect = (Rect)this.mHeaderRects.get(this.mHeaderRects.keyAt(i));
            if (!rect.contains(x, y)) continue;
            return this.mHeaderRects.keyAt(i);
        }
        return -1;
    }

    public View getHeaderView(RecyclerView parent, int position) {
        return this.mHeaderProvider.getHeader(parent, position);
    }

    public void invalidateHeaders() {
        this.mHeaderProvider.invalidate();
        this.mHeaderRects.clear();
    }
}

