/*
 * Decompiled with CFR 0.152.
 */
package com.timehop.stickyheadersrecyclerview;

import android.graphics.Rect;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import com.timehop.stickyheadersrecyclerview.StickyRecyclerHeadersAdapter;
import com.timehop.stickyheadersrecyclerview.caching.HeaderProvider;
import com.timehop.stickyheadersrecyclerview.calculation.DimensionCalculator;
import com.timehop.stickyheadersrecyclerview.util.OrientationProvider;

public class HeaderPositionCalculator {
    private final StickyRecyclerHeadersAdapter mAdapter;
    private final OrientationProvider mOrientationProvider;
    private final HeaderProvider mHeaderProvider;
    private final DimensionCalculator mDimensionCalculator;
    private final Rect mTempRect1 = new Rect();
    private final Rect mTempRect2 = new Rect();

    public HeaderPositionCalculator(StickyRecyclerHeadersAdapter adapter, HeaderProvider headerProvider, OrientationProvider orientationProvider, DimensionCalculator dimensionCalculator) {
        this.mAdapter = adapter;
        this.mHeaderProvider = headerProvider;
        this.mOrientationProvider = orientationProvider;
        this.mDimensionCalculator = dimensionCalculator;
    }

    public boolean hasStickyHeader(View itemView, int orientation, int position) {
        int margin;
        int offset;
        this.mDimensionCalculator.initMargins(this.mTempRect1, itemView);
        if (orientation == 1) {
            offset = itemView.getTop();
            margin = this.mTempRect1.top;
        } else {
            offset = itemView.getLeft();
            margin = this.mTempRect1.left;
        }
        return offset <= margin && this.mAdapter.getHeaderId(position) >= 0L;
    }

    public boolean hasNewHeader(int position, boolean isReverseLayout) {
        if (this.indexOutOfBounds(position)) {
            return false;
        }
        long headerId = this.mAdapter.getHeaderId(position);
        if (headerId < 0L) {
            return false;
        }
        long nextItemHeaderId = -1L;
        int nextItemPosition = position + (isReverseLayout ? 1 : -1);
        if (!this.indexOutOfBounds(nextItemPosition)) {
            nextItemHeaderId = this.mAdapter.getHeaderId(nextItemPosition);
        }
        int firstItemPosition = isReverseLayout ? this.mAdapter.getItemCount() - 1 : 0;
        return position == firstItemPosition || headerId != nextItemHeaderId;
    }

    private boolean indexOutOfBounds(int position) {
        return position < 0 || position >= this.mAdapter.getItemCount();
    }

    public void initHeaderBounds(Rect bounds, RecyclerView recyclerView, View header, View firstView, boolean firstHeader) {
        int orientation = this.mOrientationProvider.getOrientation(recyclerView);
        this.initDefaultHeaderOffset(bounds, recyclerView, header, firstView, orientation);
        if (firstHeader && this.isStickyHeaderBeingPushedOffscreen(recyclerView, header)) {
            View viewAfterNextHeader = this.getFirstViewUnobscuredByHeader(recyclerView, header);
            int firstViewUnderHeaderPosition = recyclerView.getChildAdapterPosition(viewAfterNextHeader);
            View secondHeader = this.mHeaderProvider.getHeader(recyclerView, firstViewUnderHeaderPosition);
            this.translateHeaderWithNextHeader(recyclerView, this.mOrientationProvider.getOrientation(recyclerView), bounds, header, viewAfterNextHeader, secondHeader);
        }
    }

    private void initDefaultHeaderOffset(Rect headerMargins, RecyclerView recyclerView, View header, View firstView, int orientation) {
        int translationY;
        int translationX;
        this.mDimensionCalculator.initMargins(this.mTempRect1, header);
        ViewGroup.LayoutParams layoutParams = firstView.getLayoutParams();
        int leftMargin = 0;
        int topMargin = 0;
        if (layoutParams instanceof ViewGroup.MarginLayoutParams) {
            ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)layoutParams;
            leftMargin = marginLayoutParams.leftMargin;
            topMargin = marginLayoutParams.topMargin;
        }
        if (orientation == 1) {
            translationX = firstView.getLeft() - leftMargin + this.mTempRect1.left;
            translationY = Math.max(firstView.getTop() - topMargin - header.getHeight() - this.mTempRect1.bottom, this.getListTop(recyclerView) + this.mTempRect1.top);
        } else {
            translationY = firstView.getTop() - topMargin + this.mTempRect1.top;
            translationX = Math.max(firstView.getLeft() - leftMargin - header.getWidth() - this.mTempRect1.right, this.getListLeft(recyclerView) + this.mTempRect1.left);
        }
        headerMargins.set(translationX, translationY, translationX + header.getWidth(), translationY + header.getHeight());
    }

    private boolean isStickyHeaderBeingPushedOffscreen(RecyclerView recyclerView, View stickyHeader) {
        View viewAfterHeader = this.getFirstViewUnobscuredByHeader(recyclerView, stickyHeader);
        int firstViewUnderHeaderPosition = recyclerView.getChildAdapterPosition(viewAfterHeader);
        if (firstViewUnderHeaderPosition == -1) {
            return false;
        }
        boolean isReverseLayout = this.mOrientationProvider.isReverseLayout(recyclerView);
        if (firstViewUnderHeaderPosition > 0 && this.hasNewHeader(firstViewUnderHeaderPosition, isReverseLayout)) {
            int rightOfThisHeader;
            int leftOfNextHeader;
            int bottomOfThisHeader;
            int topOfNextHeader;
            View nextHeader = this.mHeaderProvider.getHeader(recyclerView, firstViewUnderHeaderPosition);
            this.mDimensionCalculator.initMargins(this.mTempRect1, nextHeader);
            this.mDimensionCalculator.initMargins(this.mTempRect2, stickyHeader);
            if (this.mOrientationProvider.getOrientation(recyclerView) == 1 ? (topOfNextHeader = viewAfterHeader.getTop() - this.mTempRect1.bottom - nextHeader.getHeight() - this.mTempRect1.top) < (bottomOfThisHeader = recyclerView.getPaddingTop() + stickyHeader.getBottom() + this.mTempRect2.top + this.mTempRect2.bottom) : (leftOfNextHeader = viewAfterHeader.getLeft() - this.mTempRect1.right - nextHeader.getWidth() - this.mTempRect1.left) < (rightOfThisHeader = recyclerView.getPaddingLeft() + stickyHeader.getRight() + this.mTempRect2.left + this.mTempRect2.right)) {
                return true;
            }
        }
        return false;
    }

    private void translateHeaderWithNextHeader(RecyclerView recyclerView, int orientation, Rect translation, View currentHeader, View viewAfterNextHeader, View nextHeader) {
        this.mDimensionCalculator.initMargins(this.mTempRect1, nextHeader);
        this.mDimensionCalculator.initMargins(this.mTempRect2, currentHeader);
        if (orientation == 1) {
            int topOfStickyHeader = this.getListTop(recyclerView) + this.mTempRect2.top + this.mTempRect2.bottom;
            int shiftFromNextHeader = viewAfterNextHeader.getTop() - nextHeader.getHeight() - this.mTempRect1.bottom - this.mTempRect1.top - currentHeader.getHeight() - topOfStickyHeader;
            if (shiftFromNextHeader < topOfStickyHeader) {
                translation.top += shiftFromNextHeader;
            }
        } else {
            int leftOfStickyHeader = this.getListLeft(recyclerView) + this.mTempRect2.left + this.mTempRect2.right;
            int shiftFromNextHeader = viewAfterNextHeader.getLeft() - nextHeader.getWidth() - this.mTempRect1.right - this.mTempRect1.left - currentHeader.getWidth() - leftOfStickyHeader;
            if (shiftFromNextHeader < leftOfStickyHeader) {
                translation.left += shiftFromNextHeader;
            }
        }
    }

    private View getFirstViewUnobscuredByHeader(RecyclerView parent, View firstHeader) {
        int from;
        boolean isReverseLayout = this.mOrientationProvider.isReverseLayout(parent);
        int step = isReverseLayout ? -1 : 1;
        for (int i = from = isReverseLayout ? parent.getChildCount() - 1 : 0; i >= 0 && i <= parent.getChildCount() - 1; i += step) {
            View child = parent.getChildAt(i);
            if (this.itemIsObscuredByHeader(parent, child, firstHeader, this.mOrientationProvider.getOrientation(parent))) continue;
            return child;
        }
        return null;
    }

    private boolean itemIsObscuredByHeader(RecyclerView parent, View item, View header, int orientation) {
        int headerRight;
        int itemLeft;
        int headerBottom;
        int itemTop;
        RecyclerView.LayoutParams layoutParams = (RecyclerView.LayoutParams)item.getLayoutParams();
        this.mDimensionCalculator.initMargins(this.mTempRect1, header);
        int adapterPosition = parent.getChildAdapterPosition(item);
        if (adapterPosition == -1 || this.mHeaderProvider.getHeader(parent, adapterPosition) != header) {
            return false;
        }
        return !(orientation == 1 ? (itemTop = item.getTop() - layoutParams.topMargin) > (headerBottom = header.getBottom() + this.mTempRect1.bottom + this.mTempRect1.top) : (itemLeft = item.getLeft() - layoutParams.leftMargin) > (headerRight = header.getRight() + this.mTempRect1.right + this.mTempRect1.left));
    }

    private int getListTop(RecyclerView view) {
        if (view.getLayoutManager().getClipToPadding()) {
            return view.getPaddingTop();
        }
        return 0;
    }

    private int getListLeft(RecyclerView view) {
        if (view.getLayoutManager().getClipToPadding()) {
            return view.getPaddingLeft();
        }
        return 0;
    }
}

