/*
 * Decompiled with CFR 0.152.
 */
package com.timehop.stickyheadersrecyclerview;

import android.graphics.Rect;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.timehop.stickyheadersrecyclerview.StickyRecyclerHeadersAdapter;
import com.timehop.stickyheadersrecyclerview.caching.HeaderProvider;
import com.timehop.stickyheadersrecyclerview.calculation.DimensionCalculator;
import com.timehop.stickyheadersrecyclerview.util.OrientationProvider;

public class HeaderPositionCalculator {
    private final StickyRecyclerHeadersAdapter mAdapter;
    private final OrientationProvider mOrientationProvider;
    private final HeaderProvider mHeaderProvider;
    private final DimensionCalculator mDimensionCalculator;

    public HeaderPositionCalculator(StickyRecyclerHeadersAdapter adapter, HeaderProvider headerProvider, OrientationProvider orientationProvider, DimensionCalculator dimensionCalculator) {
        this.mAdapter = adapter;
        this.mHeaderProvider = headerProvider;
        this.mOrientationProvider = orientationProvider;
        this.mDimensionCalculator = dimensionCalculator;
    }

    public boolean hasStickyHeader(View itemView, int orientation, int position) {
        int margin;
        int offset;
        if (orientation == 1) {
            offset = itemView.getTop();
            margin = this.mDimensionCalculator.getMargins((View)itemView).top;
        } else {
            offset = itemView.getLeft();
            margin = this.mDimensionCalculator.getMargins((View)itemView).left;
        }
        return offset <= margin && this.mAdapter.getHeaderId(position) >= 0L;
    }

    public boolean hasNewHeader(int position, boolean isReverseLayout) {
        if (this.indexOutOfBounds(position)) {
            return false;
        }
        long headerId = this.mAdapter.getHeaderId(position);
        if (headerId < 0L) {
            return false;
        }
        long nextItemHeaderId = -1L;
        int nextItemPosition = position + (isReverseLayout ? 1 : -1);
        if (!this.indexOutOfBounds(nextItemPosition)) {
            nextItemHeaderId = this.mAdapter.getHeaderId(nextItemPosition);
        }
        int firstItemPosition = isReverseLayout ? this.mAdapter.getItemCount() - 1 : 0;
        return position == firstItemPosition || headerId != nextItemHeaderId;
    }

    private boolean indexOutOfBounds(int position) {
        return position < 0 || position >= this.mAdapter.getItemCount();
    }

    public Rect getHeaderBounds(RecyclerView recyclerView, View header, View firstView, boolean firstHeader) {
        int orientation = this.mOrientationProvider.getOrientation(recyclerView);
        Rect bounds = this.getDefaultHeaderOffset(recyclerView, header, firstView, orientation);
        if (firstHeader && this.isStickyHeaderBeingPushedOffscreen(recyclerView, header)) {
            View viewAfterNextHeader = this.getFirstViewUnobscuredByHeader(recyclerView, header);
            int firstViewUnderHeaderPosition = recyclerView.getChildAdapterPosition(viewAfterNextHeader);
            View secondHeader = this.mHeaderProvider.getHeader(recyclerView, firstViewUnderHeaderPosition);
            this.translateHeaderWithNextHeader(recyclerView, this.mOrientationProvider.getOrientation(recyclerView), bounds, header, viewAfterNextHeader, secondHeader);
        }
        return bounds;
    }

    private Rect getDefaultHeaderOffset(RecyclerView recyclerView, View header, View firstView, int orientation) {
        int translationY;
        int translationX;
        Rect headerMargins = this.mDimensionCalculator.getMargins(header);
        if (orientation == 1) {
            translationX = firstView.getLeft() + headerMargins.left;
            translationY = Math.max(firstView.getTop() - header.getHeight() - headerMargins.bottom, this.getListTop(recyclerView) + headerMargins.top);
        } else {
            translationY = firstView.getTop() + headerMargins.top;
            translationX = Math.max(firstView.getLeft() - header.getWidth() - headerMargins.right, this.getListLeft(recyclerView) + headerMargins.left);
        }
        return new Rect(translationX, translationY, translationX + header.getWidth(), translationY + header.getHeight());
    }

    private boolean isStickyHeaderBeingPushedOffscreen(RecyclerView recyclerView, View stickyHeader) {
        View viewAfterHeader = this.getFirstViewUnobscuredByHeader(recyclerView, stickyHeader);
        int firstViewUnderHeaderPosition = recyclerView.getChildAdapterPosition(viewAfterHeader);
        if (firstViewUnderHeaderPosition == -1) {
            return false;
        }
        boolean isReverseLayout = this.mOrientationProvider.isReverseLayout(recyclerView);
        if (firstViewUnderHeaderPosition > 0 && this.hasNewHeader(firstViewUnderHeaderPosition, isReverseLayout)) {
            int rightOfThisHeader;
            int leftOfNextHeader;
            int bottomOfThisHeader;
            int topOfNextHeader;
            View nextHeader = this.mHeaderProvider.getHeader(recyclerView, firstViewUnderHeaderPosition);
            Rect nextHeaderMargins = this.mDimensionCalculator.getMargins(nextHeader);
            Rect headerMargins = this.mDimensionCalculator.getMargins(stickyHeader);
            if (this.mOrientationProvider.getOrientation(recyclerView) == 1 ? (topOfNextHeader = viewAfterHeader.getTop() - nextHeaderMargins.bottom - nextHeader.getHeight() - nextHeaderMargins.top) < (bottomOfThisHeader = recyclerView.getPaddingTop() + stickyHeader.getBottom() + headerMargins.top + headerMargins.bottom) : (leftOfNextHeader = viewAfterHeader.getLeft() - nextHeaderMargins.right - nextHeader.getWidth() - nextHeaderMargins.left) < (rightOfThisHeader = recyclerView.getPaddingLeft() + stickyHeader.getRight() + headerMargins.left + headerMargins.right)) {
                return true;
            }
        }
        return false;
    }

    private void translateHeaderWithNextHeader(RecyclerView recyclerView, int orientation, Rect translation, View currentHeader, View viewAfterNextHeader, View nextHeader) {
        Rect nextHeaderMargins = this.mDimensionCalculator.getMargins(nextHeader);
        Rect stickyHeaderMargins = this.mDimensionCalculator.getMargins(currentHeader);
        if (orientation == 1) {
            int topOfStickyHeader = this.getListTop(recyclerView) + stickyHeaderMargins.top + stickyHeaderMargins.bottom;
            int shiftFromNextHeader = viewAfterNextHeader.getTop() - nextHeader.getHeight() - nextHeaderMargins.bottom - nextHeaderMargins.top - currentHeader.getHeight() - topOfStickyHeader;
            if (shiftFromNextHeader < topOfStickyHeader) {
                translation.top += shiftFromNextHeader;
            }
        } else {
            int leftOfStickyHeader = this.getListLeft(recyclerView) + stickyHeaderMargins.left + stickyHeaderMargins.right;
            int shiftFromNextHeader = viewAfterNextHeader.getLeft() - nextHeader.getWidth() - nextHeaderMargins.right - nextHeaderMargins.left - currentHeader.getWidth() - leftOfStickyHeader;
            if (shiftFromNextHeader < leftOfStickyHeader) {
                translation.left += shiftFromNextHeader;
            }
        }
    }

    private View getFirstViewUnobscuredByHeader(RecyclerView parent, View firstHeader) {
        int from;
        boolean isReverseLayout = this.mOrientationProvider.isReverseLayout(parent);
        int step = isReverseLayout ? -1 : 1;
        for (int i = from = isReverseLayout ? parent.getChildCount() - 1 : 0; i >= 0 && i <= parent.getChildCount() - 1; i += step) {
            View child = parent.getChildAt(i);
            if (this.itemIsObscuredByHeader(parent, child, firstHeader, this.mOrientationProvider.getOrientation(parent))) continue;
            return child;
        }
        return null;
    }

    private boolean itemIsObscuredByHeader(RecyclerView parent, View item, View header, int orientation) {
        int headerRight;
        int itemLeft;
        int headerBottom;
        int itemTop;
        RecyclerView.LayoutParams layoutParams = (RecyclerView.LayoutParams)item.getLayoutParams();
        Rect headerMargins = this.mDimensionCalculator.getMargins(header);
        int adapterPosition = parent.getChildAdapterPosition(item);
        if (adapterPosition == -1 || this.mHeaderProvider.getHeader(parent, adapterPosition) != header) {
            return false;
        }
        return !(orientation == 1 ? (itemTop = item.getTop() - layoutParams.topMargin) > (headerBottom = header.getBottom() + headerMargins.bottom + headerMargins.top) : (itemLeft = item.getLeft() - layoutParams.leftMargin) > (headerRight = header.getRight() + headerMargins.right + headerMargins.left));
    }

    private int getListTop(RecyclerView view) {
        if (view.getLayoutManager().getClipToPadding()) {
            return view.getPaddingTop();
        }
        return 0;
    }

    private int getListLeft(RecyclerView view) {
        if (view.getLayoutManager().getClipToPadding()) {
            return view.getPaddingLeft();
        }
        return 0;
    }
}

