/*
 * Decompiled with CFR 0.152.
 */
package com.timehop.stickyheadersrecyclerview;

import android.graphics.Canvas;
import android.graphics.Rect;
import android.support.v4.util.LongSparseArray;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import com.timehop.stickyheadersrecyclerview.StickyRecyclerHeadersAdapter;

public class StickyRecyclerHeadersDecoration
extends RecyclerView.ItemDecoration {
    private final StickyRecyclerHeadersAdapter mAdapter;
    private final LongSparseArray<View> mHeaderViews = new LongSparseArray();
    private final SparseArray<Rect> mHeaderRects = new SparseArray();

    public StickyRecyclerHeadersDecoration(StickyRecyclerHeadersAdapter adapter) {
        this.mAdapter = adapter;
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        super.getItemOffsets(outRect, view, parent, state);
        int orientation = this.getOrientation(parent);
        int itemPosition = parent.getChildPosition(view);
        if (this.hasNewHeader(itemPosition)) {
            View header = this.getHeaderView(parent, itemPosition);
            if (orientation == 1) {
                outRect.top = header.getHeight();
            } else {
                outRect.left = header.getWidth();
            }
        }
    }

    public void onDrawOver(Canvas canvas, RecyclerView parent, RecyclerView.State state) {
        super.onDrawOver(canvas, parent, state);
        int orientation = this.getOrientation(parent);
        this.mHeaderRects.clear();
        if (parent.getChildCount() > 0 && this.mAdapter.getItemCount() > 0) {
            int translationY;
            int translationX;
            View firstView = parent.getChildAt(0);
            int firstPosition = parent.getChildPosition(firstView);
            if (this.mAdapter.getHeaderId(firstPosition) >= 0L) {
                View firstHeader = this.getHeaderView(parent, firstPosition);
                View nextView = this.getNextView(parent);
                translationX = Math.max(parent.getChildAt(0).getLeft() - firstHeader.getWidth(), 0);
                translationY = Math.max(parent.getChildAt(0).getTop() - firstHeader.getHeight(), 0);
                int nextPosition = parent.getChildPosition(nextView);
                if (nextPosition > 0 && this.hasNewHeader(nextPosition)) {
                    View secondHeader = this.getHeaderView(parent, nextPosition);
                    if (orientation == 1 && nextView.getTop() - secondHeader.getHeight() - firstHeader.getHeight() < 0) {
                        translationY += nextView.getTop() - secondHeader.getHeight() - firstHeader.getHeight();
                    } else if (orientation == 0 && nextView.getLeft() - secondHeader.getWidth() - firstHeader.getWidth() < 0) {
                        translationX += nextView.getLeft() - secondHeader.getWidth() - firstHeader.getWidth();
                    }
                }
                canvas.save();
                canvas.translate((float)translationX, (float)translationY);
                firstHeader.draw(canvas);
                canvas.restore();
                this.mHeaderRects.put(firstPosition, (Object)new Rect(translationX, translationY, translationX + firstHeader.getWidth(), translationY + firstHeader.getHeight()));
            }
            for (int i = 1; i < parent.getChildCount(); ++i) {
                int position = parent.getChildPosition(parent.getChildAt(i));
                if (!this.hasNewHeader(position)) continue;
                translationX = 0;
                translationY = 0;
                View header = this.getHeaderView(parent, position);
                if (orientation == 1) {
                    translationY = parent.getChildAt(i).getTop() - header.getHeight();
                } else {
                    translationX = parent.getChildAt(i).getLeft() - header.getWidth();
                }
                canvas.save();
                canvas.translate((float)translationX, (float)translationY);
                header.draw(canvas);
                canvas.restore();
                this.mHeaderRects.put(position, (Object)new Rect(translationX, translationY, translationX + header.getWidth(), translationY + header.getHeight()));
            }
        }
    }

    private View getNextView(RecyclerView parent) {
        View firstView = parent.getChildAt(0);
        int firstPosition = parent.getChildPosition(firstView);
        View firstHeader = this.getHeaderView(parent, firstPosition);
        for (int i = 0; i < parent.getChildCount(); ++i) {
            View child = parent.getChildAt(i);
            RecyclerView.LayoutParams layoutParams = (RecyclerView.LayoutParams)child.getLayoutParams();
            if (!(this.getOrientation(parent) == 1 ? child.getTop() - layoutParams.topMargin > firstHeader.getHeight() : child.getLeft() - layoutParams.leftMargin > firstHeader.getWidth())) continue;
            return child;
        }
        return null;
    }

    private int getOrientation(RecyclerView parent) {
        if (parent.getLayoutManager() instanceof LinearLayoutManager) {
            LinearLayoutManager layoutManager = (LinearLayoutManager)parent.getLayoutManager();
            return layoutManager.getOrientation();
        }
        throw new IllegalStateException("StickyListHeadersDecoration can only be used with a LinearLayoutManager.");
    }

    public int findHeaderPositionUnder(int x, int y) {
        for (int i = 0; i < this.mHeaderRects.size(); ++i) {
            Rect rect = (Rect)this.mHeaderRects.get(this.mHeaderRects.keyAt(i));
            if (!rect.contains(x, y)) continue;
            return this.mHeaderRects.keyAt(i);
        }
        return -1;
    }

    public View getHeaderView(RecyclerView parent, int position) {
        long headerId = this.mAdapter.getHeaderId(position);
        View header = (View)this.mHeaderViews.get(headerId);
        if (header == null) {
            int heightSpec;
            int widthSpec;
            Object viewHolder = this.mAdapter.onCreateHeaderViewHolder((ViewGroup)parent);
            this.mAdapter.onBindHeaderViewHolder(viewHolder, position);
            header = ((RecyclerView.ViewHolder)viewHolder).itemView;
            if (header.getLayoutParams() == null) {
                header.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
            }
            if (this.getOrientation(parent) == 1) {
                widthSpec = View.MeasureSpec.makeMeasureSpec((int)parent.getWidth(), (int)0x40000000);
                heightSpec = View.MeasureSpec.makeMeasureSpec((int)parent.getHeight(), (int)0);
            } else {
                widthSpec = View.MeasureSpec.makeMeasureSpec((int)parent.getWidth(), (int)0);
                heightSpec = View.MeasureSpec.makeMeasureSpec((int)parent.getHeight(), (int)0x40000000);
            }
            int childWidth = ViewGroup.getChildMeasureSpec((int)widthSpec, (int)(parent.getPaddingLeft() + parent.getPaddingRight()), (int)header.getLayoutParams().width);
            int childHeight = ViewGroup.getChildMeasureSpec((int)heightSpec, (int)(parent.getPaddingTop() + parent.getPaddingBottom()), (int)header.getLayoutParams().height);
            header.measure(childWidth, childHeight);
            header.layout(0, 0, header.getMeasuredWidth(), header.getMeasuredHeight());
            this.mHeaderViews.put(headerId, (Object)header);
        }
        return header;
    }

    private boolean hasNewHeader(int position) {
        if (this.getFirstHeaderPosition() == position) {
            return true;
        }
        if (this.mAdapter.getHeaderId(position) < 0L) {
            return false;
        }
        if (position > 0 && position < this.mAdapter.getItemCount()) {
            return this.mAdapter.getHeaderId(position) != this.mAdapter.getHeaderId(position - 1);
        }
        return false;
    }

    private int getFirstHeaderPosition() {
        for (int i = 0; i < this.mAdapter.getItemCount(); ++i) {
            if (this.mAdapter.getHeaderId(i) < 0L) continue;
            return i;
        }
        return -1;
    }
}

