/*
 * Decompiled with CFR 0.152.
 */
package com.tickaroo.tikxml;

import com.tickaroo.tikxml.TikXmlConfig;
import com.tickaroo.tikxml.TypeConverter;
import com.tickaroo.tikxml.XmlReader;
import com.tickaroo.tikxml.XmlWriter;
import com.tickaroo.tikxml.typeadapter.TypeAdapter;
import java.io.IOException;
import java.lang.reflect.Type;
import okio.BufferedSink;
import okio.BufferedSource;

public final class TikXml {
    final TikXmlConfig config;

    private TikXml(TikXmlConfig config) {
        this.config = config;
    }

    public <T> T read(BufferedSource source, Class<T> clazz) throws IOException {
        XmlReader reader = XmlReader.of(source);
        reader.beginElement();
        reader.nextElementName();
        T value = this.config.getTypeAdapter(clazz).fromXml(reader, this.config);
        reader.endElement();
        return value;
    }

    public <T> void write(BufferedSink sink, T valueToWrite) throws IOException {
        XmlWriter writer = XmlWriter.of(sink);
        TypeAdapter<?> adapter = this.config.getTypeAdapter(valueToWrite.getClass());
        if (this.config.writeDefaultXmlDeclaration()) {
            writer.xmlDeclaration();
        }
        adapter.toXml(writer, this.config, valueToWrite, null);
    }

    public static final class Builder {
        private TikXmlConfig config = new TikXmlConfig();

        public Builder exceptionOnUnreadXml(boolean throwException) {
            this.config.exceptionOnUnreadXml = throwException;
            return this;
        }

        public Builder writeDefaultXmlDeclaration(boolean writeDeclaration) {
            this.config.writeDefaultXmlDeclaration = writeDeclaration;
            return this;
        }

        public <T> Builder addTypeConverter(Type clazz, TypeConverter<T> converterForClass) {
            this.config.typeConverters.add(clazz, converterForClass);
            return this;
        }

        public <T> Builder addTypeAdapter(Type clazz, TypeAdapter<T> adapterForClass) {
            this.config.typeAdapters.add(clazz, adapterForClass);
            return this;
        }

        public TikXml build() {
            return new TikXml(this.config);
        }
    }
}

