/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.sourcemonitor;

import com.thalesgroup.hudson.plugins.sourcemonitor.SourceMonitorBuildAction;
import com.thalesgroup.hudson.plugins.sourcemonitor.SourceMonitorChartBuilder;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.util.ChartUtil;
import java.io.IOException;
import java.io.Serializable;
import org.jfree.chart.JFreeChart;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceMonitorProjectAction
implements Action,
Serializable {
    public static final String URL_NAME = "sourceMonitorResult";
    public static final int CHART_WIDTH = 500;
    public static final int CHART_HEIGHT = 200;
    public AbstractProject<?, ?> project;

    public SourceMonitorProjectAction(AbstractProject<?, ?> project) {
        this.project = project;
    }

    public String getIconFileName() {
        return "/plugin/sourcemonitor/icons/sourcemonitor-24.png";
    }

    public String getDisplayName() {
        return "SourceMonitor Results";
    }

    public String getUrlName() {
        return URL_NAME;
    }

    public void doIndex(StaplerRequest request, StaplerResponse response) throws IOException {
        AbstractBuild<?, ?> build = this.getLastFinishedBuild();
        if (build != null) {
            response.sendRedirect2(String.format("../%d/%s", build.getNumber(), "sourcemonitor"));
        }
    }

    public AbstractBuild<?, ?> getLastFinishedBuild() {
        AbstractBuild lastBuild;
        for (lastBuild = (AbstractBuild)this.project.getLastBuild(); lastBuild != null && (lastBuild.isBuilding() || lastBuild.getAction(SourceMonitorBuildAction.class) == null); lastBuild = (AbstractBuild)lastBuild.getPreviousBuild()) {
        }
        return lastBuild;
    }

    public final boolean hasValidResults() {
        SourceMonitorBuildAction resultAction;
        AbstractBuild<?, ?> build = this.getLastFinishedBuild();
        if (build != null && (resultAction = (SourceMonitorBuildAction)build.getAction(SourceMonitorBuildAction.class)) != null) {
            return resultAction.getPreviousResult() != null;
        }
        return false;
    }

    public void doTrendMap(StaplerRequest request, StaplerResponse response) throws IOException {
        AbstractBuild<?, ?> lastBuild = this.getLastFinishedBuild();
        SourceMonitorBuildAction lastAction = (SourceMonitorBuildAction)lastBuild.getAction(SourceMonitorBuildAction.class);
        ChartUtil.generateClickableMap((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)SourceMonitorChartBuilder.buildChart(lastAction), (int)500, (int)200);
    }

    public void doTrend(StaplerRequest request, StaplerResponse response) throws IOException {
        AbstractBuild<?, ?> lastBuild = this.getLastFinishedBuild();
        SourceMonitorBuildAction lastAction = (SourceMonitorBuildAction)lastBuild.getAction(SourceMonitorBuildAction.class);
        ChartUtil.generateGraph((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)SourceMonitorChartBuilder.buildChart(lastAction), (int)500, (int)200);
    }
}

