/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.testdroid.api.APIEntity;
import com.testdroid.api.model.APIDeviceSession;
import com.testdroid.api.util.TimeConverter;
import java.time.LocalDateTime;
import java.util.Date;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class APIUserDeviceTime
extends APIEntity {
    private Date createTime;
    private Date endTime;
    private String userName;
    private Long userId;
    private Long freeTime;
    private Long billableTime;
    private Long deviceTime;
    private APIDeviceSession.Type type;

    public APIUserDeviceTime() {
    }

    public APIUserDeviceTime(LocalDateTime createTime, LocalDateTime endTime, String userName, Long userId, Long freeTime, Long billableTime, APIDeviceSession.Type type) {
        this.createTime = TimeConverter.toDate(createTime);
        this.endTime = TimeConverter.toDate(endTime);
        this.userName = userName;
        this.userId = userId;
        this.freeTime = freeTime;
        this.billableTime = billableTime;
        this.deviceTime = freeTime + billableTime;
        this.type = type;
    }

    @Override
    @JsonIgnore
    protected <T extends APIEntity> void clone(T from) {
        APIUserDeviceTime apiUserDeviceTime = (APIUserDeviceTime)from;
        this.cloneBase(from);
        this.createTime = apiUserDeviceTime.createTime;
        this.endTime = apiUserDeviceTime.endTime;
        this.userName = apiUserDeviceTime.userName;
        this.userId = apiUserDeviceTime.userId;
        this.deviceTime = apiUserDeviceTime.deviceTime;
        this.type = apiUserDeviceTime.type;
        this.freeTime = apiUserDeviceTime.freeTime;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Long getDeviceTime() {
        return this.deviceTime;
    }

    public void setDeviceTime(Long deviceTime) {
        this.deviceTime = deviceTime;
    }

    public APIDeviceSession.Type getType() {
        return this.type;
    }

    public void setType(APIDeviceSession.Type type) {
        this.type = type;
    }

    public Long getFreeTime() {
        return this.freeTime;
    }

    public void setFreeTime(Long freeTime) {
        this.freeTime = freeTime;
    }

    public Long getBillableTime() {
        return this.billableTime;
    }

    public void setBillableTime(Long billableTime) {
        this.billableTime = billableTime;
    }
}

